/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.memory;

import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.Symbols;
import org.jsoar.util.adaptables.AbstractAdaptable;

public class DummyWme
extends AbstractAdaptable
implements Wme {
    private final Identifier id;
    private final Symbol attr;
    private final Symbol value;

    public static DummyWme create(SymbolFactory syms, Object id, Object attr, Object value) {
        return new DummyWme((Identifier)Symbols.create(syms, id), Symbols.create(syms, attr), Symbols.create(syms, value));
    }

    public static Set<Wme> create(SymbolFactory syms, Object ... wmes) {
        if (wmes.length % 3 != 0) {
            throw new IllegalArgumentException("wmes must be a multiple of 3");
        }
        LinkedHashSet<Wme> result = new LinkedHashSet<Wme>();
        for (int i = 0; i < wmes.length; i += 3) {
            result.add(DummyWme.create(syms, wmes[i], wmes[i + 1], wmes[i + 2]));
        }
        return result;
    }

    public DummyWme(Identifier id, Symbol attr, Symbol value) {
        this.id = id;
        this.attr = attr;
        this.value = value;
    }

    @Override
    public Symbol getAttribute() {
        return this.attr;
    }

    @Override
    public Iterator<Wme> getChildren() {
        return null;
    }

    @Override
    public Identifier getIdentifier() {
        return this.id;
    }

    @Override
    public Iterator<Preference> getPreferences() {
        return Collections.emptyIterator();
    }

    @Override
    public int getTimetag() {
        return -1;
    }

    @Override
    public Symbol getValue() {
        return this.value;
    }

    @Override
    public boolean isAcceptable() {
        return false;
    }

    @Override
    public void formatTo(Formatter fmt, int f, int width, int precision) {
        if ((f & 4) == 0) {
            fmt.format("(%d: %s ^%s %s%s)\n", this.getTimetag(), this.id, this.attr, this.value, this.isAcceptable() ? " +" : "");
        } else {
            fmt.format("(%s ^%s %s%s)\n", this.id, this.attr, this.value, this.isAcceptable() ? " +" : "");
        }
    }
}

