/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.memory;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.PositiveCondition;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.rete.NotStruct;
import org.jsoar.kernel.rete.Token;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.kernel.tracing.Traceable;

public class Instantiation
implements Traceable {
    public Production prod;
    public Instantiation nextInProdList;
    public Instantiation prevInProdList;
    public Token rete_token;
    public WmeImpl rete_wme;
    public Condition top_of_instantiated_conditions;
    public Condition bottom_of_instantiated_conditions;
    public NotStruct nots = null;
    public Preference preferences_generated = null;
    public IdentifierImpl match_goal;
    public int match_goal_level;
    public boolean reliable = true;
    public boolean in_ms = true;
    public int backtrace_number;
    public boolean GDS_evaluated_already = false;

    public Instantiation(Production prod, Token rete_token, WmeImpl rete_wme) {
        this.prod = prod;
        this.rete_token = rete_token;
        this.rete_wme = rete_wme;
    }

    public String toString() {
        return this.prod.getName().toString();
    }

    public void trace(Formatter formatter, Trace.WmeTraceType wtt) {
        formatter.format("%s", this.prod != null ? this.prod.getName() : "[dummy production]");
        if (wtt == Trace.WmeTraceType.NONE) {
            return;
        }
        formatter.format("\n", new Object[0]);
        for (Wme wme : this.getBacktraceWmes()) {
            switch (wtt) {
                case TIMETAG: {
                    formatter.format(" %d", wme.getTimetag());
                    break;
                }
                case FULL: {
                    formatter.format(" %s", wme);
                    break;
                }
            }
        }
    }

    public List<Wme> getBacktraceWmes() {
        ArrayList<Wme> result = new ArrayList<Wme>();
        Condition cond = this.top_of_instantiated_conditions;
        while (cond != null) {
            PositiveCondition pc = cond.asPositiveCondition();
            if (pc != null) {
                result.add(pc.bt().wme_);
            }
            cond = cond.next;
        }
        return result;
    }

    public void insertGeneratedPreference(Preference pref) {
        pref.inst_next = this.preferences_generated;
        if (this.preferences_generated != null) {
            this.preferences_generated.inst_prev = pref;
        }
        this.preferences_generated = pref;
        pref.inst_prev = null;
    }

    void removeGeneratedPreferece(Preference pref) {
        if (pref == this.preferences_generated) {
            this.preferences_generated = pref.inst_next;
            if (this.preferences_generated != null) {
                this.preferences_generated.inst_prev = null;
            }
        } else {
            pref.inst_prev.inst_next = pref.inst_next;
            if (pref.inst_next != null) {
                pref.inst_next.inst_prev = pref.inst_prev;
            }
        }
        pref.inst_prev = null;
        pref.inst_next = null;
    }

    public Instantiation insertAtHeadOfProdList(Instantiation currentHead) {
        this.nextInProdList = currentHead;
        if (this.nextInProdList != null) {
            this.nextInProdList.prevInProdList = this;
        }
        this.prevInProdList = null;
        return this;
    }

    public Instantiation removeFromProdList(Instantiation currentHead) {
        if (this == currentHead) {
            currentHead = this.nextInProdList;
            if (currentHead != null) {
                currentHead.prevInProdList = null;
            }
        } else {
            this.prevInProdList.nextInProdList = this.nextInProdList;
            if (this.nextInProdList != null) {
                this.nextInProdList.prevInProdList = this.prevInProdList;
            }
        }
        this.prevInProdList = null;
        this.nextInProdList = null;
        return currentHead;
    }

    @Override
    public void trace(Trace trace, Formatter formatter, int flags, int width, int precision) {
        this.trace(formatter, trace.getWmeTraceType());
    }
}

