/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.memory;

import org.jsoar.kernel.PredefinedSymbols;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.PositiveCondition;
import org.jsoar.kernel.memory.Instantiation;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.memory.PreferenceType;
import org.jsoar.kernel.memory.Slot;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.rhs.Action;
import org.jsoar.kernel.rhs.MakeAction;
import org.jsoar.kernel.rhs.ReteLocation;
import org.jsoar.kernel.rhs.RhsSymbolValue;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.util.ListHead;
import org.jsoar.util.ListItem;
import org.jsoar.util.markers.Marker;

public class OSupport {
    private final PredefinedSymbols syms;
    private final Printer printer;
    private Marker o_support_tc;
    private final ListHead<Preference> rhs_prefs_from_instantiation = ListHead.newInstance();

    public OSupport(PredefinedSymbols syms, Printer printer) {
        this.syms = syms;
        this.printer = printer;
    }

    private void add_to_os_tc_if_needed(SymbolImpl sym) {
        IdentifierImpl id = sym.asIdentifier();
        if (id != null) {
            this.add_to_os_tc(id, false);
        }
    }

    private void add_to_os_tc(IdentifierImpl id, boolean isa_state) {
        Preference pref;
        if (id.tc_number == this.o_support_tc) {
            return;
        }
        id.tc_number = this.o_support_tc;
        WmeImpl w = id.getInputWmes();
        while (w != null) {
            this.add_to_os_tc_if_needed(w.value);
            w = w.next;
        }
        Slot s = id.slots;
        while (s != null) {
            if (!isa_state || s.attr != this.syms.operator_symbol) {
                pref = s.getAllPreferences();
                while (pref != null) {
                    this.add_to_os_tc_if_needed(pref.value);
                    if (pref.type.isBinary()) {
                        this.add_to_os_tc_if_needed(pref.referent);
                    }
                    pref = pref.nextOfSlot;
                }
                WmeImpl w2 = s.getWmes();
                while (w2 != null) {
                    this.add_to_os_tc_if_needed(w2.value);
                    w2 = w2.next;
                }
            }
            s = s.next;
        }
        ListItem pit = this.rhs_prefs_from_instantiation.first;
        while (pit != null) {
            pref = (Preference)pit.item;
            if (!(pref.id != id || isa_state && pref.attr == this.syms.operator_symbol)) {
                this.add_to_os_tc_if_needed(pref.value);
                if (pref.type.isBinary()) {
                    this.add_to_os_tc_if_needed(pref.referent);
                }
            }
            pit = pit.next;
        }
    }

    public void calculate_support_for_instantiation_preferences(Instantiation inst) {
        boolean op_elab;
        boolean o_support;
        block14: {
            block15: {
                block13: {
                    o_support = false;
                    op_elab = false;
                    if (inst.prod.getDeclaredSupport() != Production.Support.DECLARED_O_SUPPORT) break block13;
                    o_support = true;
                    break block14;
                }
                if (inst.prod.getDeclaredSupport() != Production.Support.DECLARED_I_SUPPORT) break block15;
                o_support = false;
                break block14;
            }
            if (inst.prod.getDeclaredSupport() != Production.Support.UNDECLARED) break block14;
            boolean operator_proposal = false;
            Action act = inst.prod.getFirstAction();
            while (act != null) {
                MakeAction ma = act.asMakeAction();
                if (ma != null && ma.attr.asSymbolValue() != null && this.syms.operator_symbol == ma.attr.asSymbolValue().sym && act.preference_type == PreferenceType.ACCEPTABLE) {
                    operator_proposal = true;
                    o_support = false;
                    break;
                }
                act = act.next;
            }
            if (operator_proposal) break block14;
            WmeImpl lowest_goal_wme = null;
            for (int pass = 0; pass != 2; ++pass) {
                Condition c = inst.top_of_instantiated_conditions;
                while (c != null) {
                    block16: {
                        WmeImpl w;
                        block17: {
                            block18: {
                                PositiveCondition pc = c.asPositiveCondition();
                                if (pc == null) break block16;
                                w = pc.bt().wme_;
                                if (pass != 0) break block17;
                                if (!w.id.isGoal()) break block16;
                                if (lowest_goal_wme != null) break block18;
                                lowest_goal_wme = w;
                                break block16;
                            }
                            if (w.id.level <= lowest_goal_wme.id.level) break block16;
                            lowest_goal_wme = w;
                            break block16;
                        }
                        if (w.attr == this.syms.operator_symbol && !w.acceptable && w.id == lowest_goal_wme.id) {
                            act = inst.prod.getFirstAction();
                            while (act != null) {
                                MakeAction ma = act.asMakeAction();
                                if (ma != null) {
                                    RhsSymbolValue symVal = ma.id.asSymbolValue();
                                    ReteLocation reteLoc = ma.id.asReteLocation();
                                    if (symVal != null && symVal.sym == w.value) {
                                        op_elab = true;
                                    } else if (reteLoc != null && w.value == reteLoc.lookupSymbol(inst.rete_token, w)) {
                                        op_elab = true;
                                    } else {
                                        o_support = true;
                                    }
                                }
                                act = act.next;
                            }
                        }
                    }
                    c = c.next;
                }
            }
        }
        if (o_support && op_elab) {
            this.printer.warn("\nWARNING: operator elaborations mixed with operator applications\nget i_support in prod %s", inst.prod.getName());
            o_support = false;
        }
        Preference pref = inst.preferences_generated;
        while (pref != null) {
            pref.o_supported = o_support;
            pref = pref.inst_next;
        }
    }
}

