/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.memory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Consistency;
import org.jsoar.kernel.Decider;
import org.jsoar.kernel.DecisionCycle;
import org.jsoar.kernel.Phase;
import org.jsoar.kernel.PredefinedSymbols;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.ProductionType;
import org.jsoar.kernel.SavedFiringType;
import org.jsoar.kernel.SoarConstants;
import org.jsoar.kernel.SoarProperties;
import org.jsoar.kernel.learning.Chunker;
import org.jsoar.kernel.learning.rl.ReinforcementLearning;
import org.jsoar.kernel.lhs.BackTraceInfo;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.PositiveCondition;
import org.jsoar.kernel.memory.Instantiation;
import org.jsoar.kernel.memory.OSupport;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.memory.PreferenceType;
import org.jsoar.kernel.memory.Slot;
import org.jsoar.kernel.memory.TemporaryMemory;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.rete.ConditionsAndNots;
import org.jsoar.kernel.rete.Rete;
import org.jsoar.kernel.rete.SoarReteAssertion;
import org.jsoar.kernel.rete.SoarReteListener;
import org.jsoar.kernel.rete.Token;
import org.jsoar.kernel.rhs.Action;
import org.jsoar.kernel.rhs.FunctionAction;
import org.jsoar.kernel.rhs.MakeAction;
import org.jsoar.kernel.rhs.ReteLocation;
import org.jsoar.kernel.rhs.RhsFunctionCall;
import org.jsoar.kernel.rhs.RhsSymbolValue;
import org.jsoar.kernel.rhs.RhsValue;
import org.jsoar.kernel.rhs.UnboundVariable;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.SymbolFactoryImpl;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.kernel.wma.DefaultWorkingMemoryActivation;
import org.jsoar.util.Arguments;
import org.jsoar.util.ByRef;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.properties.LongPropertyProvider;
import org.jsoar.util.timing.ExecutionTimers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecognitionMemory {
    private static final Logger logger = LoggerFactory.getLogger(RecognitionMemory.class);
    private final Agent context;
    private PredefinedSymbols predefinedSyms;
    private Decider decider;
    private Chunker chunker;
    private DecisionCycle decisionCycle;
    private Rete rete;
    private TemporaryMemory tempMemory;
    private OSupport osupport;
    private SoarReteListener soarReteListener;
    private Consistency consistency;
    private ReinforcementLearning rl;
    private DefaultWorkingMemoryActivation wma;
    private int firer_highest_rhs_unboundvar_index;
    public Instantiation newly_created_instantiations;
    private Production production_being_fired;
    private final LongPropertyProvider production_firing_count = new LongPropertyProvider(SoarProperties.PRODUCTION_FIRING_COUNT);
    public SavedFiringType FIRING_TYPE;
    private final RhsFunctionContext rhsFuncContext = new RhsFunctionContextImpl();
    private final LinkedList<Preference> rhsFunctionPreferences = new LinkedList();
    private PreferenceType rhsFunctionPreferenceType;

    public RecognitionMemory(Agent context) {
        this.context = context;
    }

    public RhsFunctionContext getRhsFunctionContext() {
        return this.rhsFuncContext;
    }

    public void initialize() {
        this.predefinedSyms = Adaptables.adapt(this.context, PredefinedSymbols.class);
        this.decider = Adaptables.adapt(this.context, Decider.class);
        this.chunker = Adaptables.adapt(this.context, Chunker.class);
        this.decisionCycle = Adaptables.adapt(this.context, DecisionCycle.class);
        this.rete = Adaptables.adapt(this.context, Rete.class);
        this.tempMemory = Adaptables.adapt(this.context, TemporaryMemory.class);
        this.osupport = Adaptables.adapt(this.context, OSupport.class);
        this.soarReteListener = Adaptables.adapt(this.context, SoarReteListener.class);
        this.consistency = Adaptables.adapt(this.context, Consistency.class);
        this.rl = Adaptables.adapt(this.context, ReinforcementLearning.class);
        this.wma = Adaptables.adapt(this.context, DefaultWorkingMemoryActivation.class);
        this.context.getProperties().setProvider(SoarProperties.PRODUCTION_FIRING_COUNT, this.production_firing_count);
    }

    public void reset() {
        this.production_firing_count.reset();
        this.FIRING_TYPE = SavedFiringType.IE_PRODS;
    }

    void build_CDPS(Instantiation inst) {
        Condition cond = inst.top_of_instantiated_conditions;
        while (cond != null) {
            BackTraceInfo bt;
            PositiveCondition pc = cond.asPositiveCondition();
            BackTraceInfo backTraceInfo = bt = pc != null ? pc.bt() : null;
            if (pc != null) {
                bt.clearContextDependentPreferenceSet(this.context);
            }
            if (pc != null && bt.trace != null && bt.trace.slot != null) {
                if (this.chunker.chunkThroughEvaluationRules) {
                    if (bt.trace.slot.hasContextDependentPreferenceSet()) {
                        for (Preference pref : bt.trace.slot.getContextDependentPreferenceSet()) {
                            Preference new_pref = null;
                            if (pref.inst.match_goal_level == inst.match_goal_level && pref.isInTempMemory()) {
                                bt.addContextDependentPreference(pref);
                                continue;
                            }
                            new_pref = Preference.find_clone_for_level(pref, inst.match_goal_level);
                            if (new_pref == null || !new_pref.isInTempMemory()) continue;
                            bt.addContextDependentPreference(new_pref);
                        }
                    }
                } else {
                    Preference pref = bt.trace.slot.getPreferencesByType(PreferenceType.PROHIBIT);
                    while (pref != null) {
                        Preference new_pref = null;
                        if (pref.inst.match_goal_level == inst.match_goal_level && pref.isInTempMemory()) {
                            bt.addContextDependentPreference(pref);
                        } else {
                            new_pref = Preference.find_clone_for_level(pref, inst.match_goal_level);
                            if (new_pref != null && new_pref.isInTempMemory()) {
                                bt.addContextDependentPreference(new_pref);
                            }
                        }
                        pref = pref.next;
                    }
                }
            }
            cond = cond.next;
        }
    }

    private static void find_match_goal(Instantiation inst) {
        IdentifierImpl lowest_goal_so_far = null;
        int lowest_level_so_far = -1;
        Condition cond = inst.top_of_instantiated_conditions;
        while (cond != null) {
            PositiveCondition pc = cond.asPositiveCondition();
            if (pc != null) {
                BackTraceInfo bt = pc.bt();
                IdentifierImpl id = bt.wme_.id;
                if (id.isGoal() && bt.level > lowest_level_so_far) {
                    lowest_goal_so_far = id;
                    lowest_level_so_far = bt.level;
                }
            }
            cond = cond.next;
        }
        inst.match_goal = lowest_goal_so_far;
        inst.match_goal_level = lowest_goal_so_far != null ? lowest_level_so_far : Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymbolImpl instantiate_rhs_value(RhsValue rv, int new_id_level, char new_id_letter, Token tok, WmeImpl w) {
        RhsSymbolValue rsv = rv.asSymbolValue();
        if (rsv != null) {
            SymbolImpl result = rsv.getSym();
            IdentifierImpl resultAsId = result.asIdentifier();
            if (resultAsId != null && resultAsId.smem_lti != 0L && resultAsId.level == 0) {
                resultAsId.level = new_id_level;
                resultAsId.promotion_level = new_id_level;
            }
            return result;
        }
        UnboundVariable uv = rv.asUnboundVariable();
        if (uv != null) {
            int index = uv.getIndex();
            if (this.firer_highest_rhs_unboundvar_index < index) {
                this.firer_highest_rhs_unboundvar_index = index;
            }
            SymbolImpl sym = this.rete.getRhsVariableBinding(index);
            SymbolFactoryImpl syms = this.predefinedSyms.getSyms();
            if (sym == null) {
                sym = syms.make_new_identifier(new_id_letter, new_id_level);
                this.rete.setRhsVariableBinding(index, sym);
                return sym;
            }
            if (sym.asVariable() != null) {
                Variable v = sym.asVariable();
                new_id_letter = v.getFirstLetter();
                sym = syms.make_new_identifier(new_id_letter, new_id_level);
                this.rete.setRhsVariableBinding(index, sym);
                return sym;
            }
            return sym;
        }
        ReteLocation rl = rv.asReteLocation();
        if (rl != null) {
            return rl.lookupSymbol(tok, w);
        }
        RhsFunctionCall fc = rv.asFunctionCall();
        if (fc == null) {
            throw new IllegalStateException("Unknow RhsValue type: " + rv);
        }
        ArrayList<Symbol> arguments = new ArrayList<Symbol>(fc.getArguments().size());
        boolean nil_arg_found = false;
        for (RhsValue arg : fc.getArguments()) {
            SymbolImpl instArg = this.instantiate_rhs_value(arg, new_id_level, new_id_letter, tok, w);
            if (instArg == null) {
                nil_arg_found = true;
            }
            arguments.add(instArg);
        }
        if (!nil_arg_found) {
            ExecutionTimers.pause(this.context.getTotalKernelTimer());
            ExecutionTimers.update(this.context.getTotalCpuTimer());
            try {
                SymbolImpl symbolImpl = (SymbolImpl)this.context.getRhsFunctions().execute(fc.getName().getValue(), arguments);
                return symbolImpl;
            }
            catch (RhsFunctionException e) {
                logger.error("Error executing RHS function '" + fc.getName() + "' with args " + arguments + ": " + e.getMessage(), (Throwable)e);
                this.context.getPrinter().error("Error executing RHS function '%s' with args %s: %s\n", fc.getName(), arguments, e.getMessage());
            }
            finally {
                ExecutionTimers.start(this.context.getTotalKernelTimer());
            }
        }
        return null;
    }

    private Preference execute_action(Action a, Token tok, WmeImpl w) {
        this.rhsFunctionPreferenceType = a.preference_type;
        FunctionAction fa = a.asFunctionAction();
        if (fa != null) {
            this.instantiate_rhs_value(fa.getCall(), -1, 'v', tok, w);
            return null;
        }
        MakeAction ma = a.asMakeAction();
        SymbolImpl idSym = this.instantiate_rhs_value(ma.id, -1, 's', tok, w);
        if (idSym == null) {
            return null;
        }
        IdentifierImpl id = idSym.asIdentifier();
        if (id == null) {
            this.context.getPrinter().error("[%s] RHS makes a preference for %s (not an identifier)\n", this.production_being_fired, idSym);
            return null;
        }
        SymbolImpl attr = this.instantiate_rhs_value(ma.attr, id.level, 'a', tok, w);
        if (attr == null) {
            return null;
        }
        char first_letter = attr.getFirstLetter();
        SymbolImpl value = this.instantiate_rhs_value(ma.value, id.level, first_letter, tok, w);
        if (value == null) {
            return null;
        }
        SymbolImpl referent = null;
        if (a.preference_type.isBinary() && (referent = this.instantiate_rhs_value(ma.referent, id.level, first_letter, tok, w)) == null) {
            return null;
        }
        if (!(a.preference_type == PreferenceType.ACCEPTABLE || a.preference_type == PreferenceType.REJECT || id.isGoal() && attr == this.predefinedSyms.operator_symbol)) {
            this.context.getPrinter().error("[%s] attribute preference other than +/- for %s ^%s -- ignoring it.", this.production_being_fired, id, attr);
            return null;
        }
        PreferenceType type = a.preference_type;
        if (type == PreferenceType.BINARY_INDIFFERENT && (referent.asDouble() != null || referent.asInteger() != null)) {
            type = PreferenceType.NUMERIC_INDIFFERENT;
        }
        return new Preference(type, id, attr, value, referent);
    }

    public void fill_in_new_instantiation_stuff(Instantiation inst, boolean need_to_do_support_calculations) {
        RecognitionMemory.find_match_goal(inst);
        int level = inst.match_goal_level;
        Condition cond = inst.top_of_instantiated_conditions;
        while (cond != null) {
            PositiveCondition pc = cond.asPositiveCondition();
            if (pc != null) {
                if (SoarConstants.DO_TOP_LEVEL_REF_CTS || level > 1) {
                    // empty if block
                }
                BackTraceInfo bt = pc.bt();
                if (bt.trace != null) {
                    if (bt.trace.inst.match_goal_level > level) {
                        bt.trace = Preference.find_clone_for_level(bt.trace, level);
                    }
                    if (SoarConstants.DO_TOP_LEVEL_REF_CTS) {
                        if (bt.trace != null) {
                            bt.trace.preference_add_ref();
                        }
                    } else if (bt.trace != null && level > 1) {
                        bt.trace.preference_add_ref();
                    }
                }
            }
            cond = cond.next;
        }
        if (inst.match_goal != null) {
            Preference p = inst.preferences_generated;
            while (p != null) {
                inst.match_goal.goalInfo.addGoalPreference(p);
                p.on_goal_list = true;
                p = p.inst_next;
            }
        }
        inst.backtrace_number = 0;
        if (need_to_do_support_calculations) {
            this.osupport.calculate_support_for_instantiation_preferences(inst);
        }
    }

    private void create_instantiation(Production prod, Token tok, WmeImpl w) {
        boolean trace_it;
        Trace trace = this.context.getTrace();
        assert (prod.getType() != ProductionType.JUSTIFICATION);
        Instantiation inst = new Instantiation(prod, tok, w);
        this.newly_created_instantiations = inst.insertAtHeadOfProdList(this.newly_created_instantiations);
        trace.print(Trace.Category.VERBOSE, "\n in create_instantiation: %s", inst.prod.getName());
        this.production_being_fired = inst.prod;
        prod.incrementFiringCount();
        this.production_firing_count.increment();
        ConditionsAndNots cans = this.rete.p_node_to_conditions_and_nots(prod.getReteNode(), tok, w, false);
        inst.top_of_instantiated_conditions = cans.top;
        inst.bottom_of_instantiated_conditions = cans.bottom;
        inst.nots = cans.nots;
        Condition cond = inst.top_of_instantiated_conditions;
        while (cond != null) {
            PositiveCondition pc = cond.asPositiveCondition();
            if (pc != null) {
                BackTraceInfo bt = pc.bt();
                bt.level = bt.wme_.id.level;
                bt.trace = bt.wme_.preference;
            }
            cond = cond.next;
        }
        boolean bl = trace_it = trace.isEnabled(inst.prod.getType().getTraceCategory()) || inst.prod.isTraceFirings();
        if (trace_it) {
            trace.startNewLine().print("Firing %s", inst);
        }
        int index = 0;
        for (Variable c : prod.getRhsUnboundVariables()) {
            this.rete.setRhsVariableBinding(index, c);
            ++index;
        }
        this.firer_highest_rhs_unboundvar_index = index - 1;
        if (trace_it && trace.isEnabled(Trace.Category.FIRINGS_PREFERENCES)) {
            trace.startNewLine().print("-->");
        }
        assert (inst.preferences_generated == null);
        boolean need_to_do_support_calculations = false;
        Action a = prod.getFirstAction();
        while (a != null) {
            Preference pref = null;
            if (prod.getType() != ProductionType.TEMPLATE) {
                pref = this.execute_action(a, tok, w);
            } else {
                pref = null;
                this.rl.rl_build_template_instantiation(inst, tok, w);
            }
            while (pref != null) {
                pref.setInstantiation(inst);
                pref.o_supported = inst.prod.getDeclaredSupport() == Production.Support.DECLARED_O_SUPPORT ? true : (inst.prod.getDeclaredSupport() == Production.Support.DECLARED_I_SUPPORT ? false : this.FIRING_TYPE == SavedFiringType.PE_PRODS);
                pref = !this.rhsFunctionPreferences.isEmpty() ? this.rhsFunctionPreferences.pop() : null;
            }
            a = a.next;
        }
        for (index = 0; index <= this.firer_highest_rhs_unboundvar_index; ++index) {
            this.rete.setRhsVariableBinding(index, null);
        }
        this.fill_in_new_instantiation_stuff(inst, need_to_do_support_calculations);
        if (trace_it && trace.isEnabled(Trace.Category.FIRINGS_PREFERENCES)) {
            trace.startNewLine();
            Preference pref = inst.preferences_generated;
            while (pref != null) {
                trace.print("%s", pref);
                pref = pref.inst_next;
            }
        }
        this.build_CDPS(inst);
        this.production_being_fired = null;
        ByRef<Instantiation> new_created_byref = ByRef.create(this.newly_created_instantiations);
        this.chunker.chunk_instantiation(inst, false, new_created_byref);
        this.newly_created_instantiations = (Instantiation)new_created_byref.value;
    }

    private boolean shouldCreateInstantiation(Production prod, Token tok, WmeImpl w) {
        if (this.decider.active_level == this.decider.highest_active_level) {
            return true;
        }
        if (prod.getType() == ProductionType.TEMPLATE) {
            return true;
        }
        Action a = prod.getFirstAction();
        while (a != null) {
            block8: {
                SymbolImpl idSym;
                block10: {
                    MakeAction ma;
                    block9: {
                        ma = a.asMakeAction();
                        if (ma == null || ma.id.asUnboundVariable() != null) break block8;
                        idSym = null;
                        RhsSymbolValue rsv = ma.id.asSymbolValue();
                        if (rsv == null) break block9;
                        idSym = rsv.getSym();
                        break block10;
                    }
                    ReteLocation rl = ma.id.asReteLocation();
                    if (rl == null) break block8;
                    idSym = rl.lookupSymbol(tok, w);
                }
                assert (idSym != null);
                IdentifierImpl id = idSym.asIdentifier();
                if (id != null && id.level <= this.decider.change_level) {
                    this.context.getTrace().print(Trace.Category.WATERFALL, "*** Waterfall: aborting firing because (%s * *) level %d is on or higher (lower int) than change level %d\n", id, id.level, this.decider.change_level);
                    return false;
                }
            }
            a = a.next;
        }
        return true;
    }

    private void deallocate_instantiation(Instantiation inst) {
        Preference trace;
        Stack<Condition> cond_stack = new Stack<Condition>();
        LinkedList<Instantiation> inst_list = new LinkedList<Instantiation>();
        inst_list.add(inst);
        ListIterator next_iter = inst_list.listIterator();
        while (next_iter.hasNext()) {
            inst = (Instantiation)next_iter.next();
            assert (inst != null);
            int level = inst.match_goal_level;
            Condition cond = inst.top_of_instantiated_conditions;
            while (cond != null) {
                PositiveCondition pc = cond.asPositiveCondition();
                if (pc != null) {
                    BackTraceInfo backTraceInfo = pc.bt();
                    backTraceInfo.clearContextDependentPreferenceSet(this.context);
                    if ((SoarConstants.DO_TOP_LEVEL_REF_CTS || level > 1) && (trace = backTraceInfo.trace) != null) {
                        --trace.reference_count;
                        if (trace.reference_count == 0) {
                            boolean has_active_clones = false;
                            Preference clone = trace.next_clone;
                            while (clone != null) {
                                if (clone.reference_count != 0) {
                                    has_active_clones = true;
                                }
                                clone = clone.next_clone;
                            }
                            if (!has_active_clones) {
                                clone = trace.prev_clone;
                                while (clone != null) {
                                    if (clone.reference_count != 0) {
                                        has_active_clones = true;
                                    }
                                    clone = clone.prev_clone;
                                }
                                if (!has_active_clones) {
                                    Preference next;
                                    clone = trace.next_clone;
                                    while (clone != null) {
                                        next = clone.next_clone;
                                        Preference.deallocate_preference(clone, this);
                                        clone = next;
                                    }
                                    clone = trace.prev_clone;
                                    while (clone != null) {
                                        next = clone.prev_clone;
                                        Preference.deallocate_preference(clone, this);
                                        clone = next;
                                    }
                                    if (trace.on_goal_list) {
                                        trace.inst.match_goal.goalInfo.removeGoalPreference(trace);
                                    }
                                    trace.inst.removeGeneratedPreferece(trace);
                                    if (trace.inst.preferences_generated == null && !trace.inst.in_ms) {
                                        int index = next_iter.previousIndex() + 1;
                                        inst_list.add(index, trace.inst);
                                        next_iter = inst_list.listIterator(index);
                                    }
                                    cond_stack.push(cond);
                                }
                            }
                        }
                    }
                }
                cond = cond.next;
            }
        }
        for (Condition condition : cond_stack) {
            trace = condition.asPositiveCondition().bt().trace;
            if (trace != null) {
                if (trace.type == PreferenceType.BINARY_INDIFFERENT) {
                    trace.referent = null;
                }
                trace.wma_o_set = null;
            }
            condition.asPositiveCondition().bt().trace = null;
            if (condition.next != null) {
                condition.next.prev = condition.prev;
            }
            if (condition.prev != null) {
                condition.prev.next = condition.next;
            }
            condition.prev = null;
            condition.next = null;
        }
        for (Instantiation instantiation : inst_list) {
            instantiation.top_of_instantiated_conditions = null;
            instantiation.bottom_of_instantiated_conditions = null;
            instantiation.nots = null;
            instantiation.prod = null;
        }
    }

    void possibly_deallocate_instantiation(Instantiation inst) {
        if (inst.preferences_generated == null && !inst.in_ms) {
            this.deallocate_instantiation(inst);
        }
    }

    private void retract_instantiation(Instantiation inst) {
        boolean retracted_a_preference = false;
        Trace trace = this.context.getTrace();
        boolean trace_it = trace.isEnabled(inst.prod.getType().getTraceCategory()) || inst.prod.isTraceFirings();
        Preference pref = inst.preferences_generated;
        while (pref != null) {
            Preference next = pref.inst_next;
            if (pref.isInTempMemory() && !pref.o_supported) {
                if (trace_it) {
                    if (!retracted_a_preference) {
                        trace.startNewLine().print("Retracting %s", inst);
                        if (trace.isEnabled(Trace.Category.FIRINGS_PREFERENCES)) {
                            trace.startNewLine().print("-->");
                        }
                    }
                    if (trace.isEnabled(Trace.Category.FIRINGS_PREFERENCES)) {
                        trace.startNewLine().print("%s", pref);
                    }
                }
                this.remove_preference_from_tm(pref);
                retracted_a_preference = true;
            }
            pref = next;
        }
        inst.prod.instantiations = inst.removeFromProdList(inst.prod.instantiations);
        if (inst.prod.getType() == ProductionType.JUSTIFICATION) {
            this.context.getProductions().exciseProduction(inst.prod, false);
        }
        inst.in_ms = false;
        this.possibly_deallocate_instantiation(inst);
    }

    private void assert_new_preferences(List<Preference> bufdeallo) {
        Preference next_pref;
        Preference pref;
        Instantiation next_inst;
        Trace trace = this.context.getTrace();
        LinkedList<Preference> o_rejects = new LinkedList<Preference>();
        trace.print(Trace.Category.VERBOSE, "\n in assert_new_preferences:");
        Instantiation inst = this.newly_created_instantiations;
        while (inst != null) {
            next_inst = inst.nextInProdList;
            pref = inst.preferences_generated;
            while (pref != null) {
                next_pref = pref.inst_next;
                if (pref.type == PreferenceType.REJECT && pref.o_supported) {
                    o_rejects.push(pref);
                }
                pref = next_pref;
            }
            inst = next_inst;
        }
        if (!o_rejects.isEmpty()) {
            this.process_o_rejects_and_deallocate_them(o_rejects, bufdeallo);
        }
        inst = this.newly_created_instantiations;
        while (inst != null) {
            next_inst = inst.nextInProdList;
            if (inst.in_ms) {
                inst.prod.instantiations = inst.insertAtHeadOfProdList(inst.prod.instantiations);
                trace.print(Trace.Category.VERBOSE, "\n asserting instantiation: %s\n", inst.prod.getName());
            }
            pref = inst.preferences_generated;
            while (pref != null) {
                next_pref = pref.inst_next;
                if (inst.in_ms || pref.o_supported) {
                    this.add_preference_to_tm(pref);
                    if (this.wma.wma_enabled()) {
                        this.wma.wma_activate_wmes_in_pref(pref);
                    }
                } else {
                    if (pref.next_clone != null) {
                        pref.next_clone.prev_clone = pref.prev_clone;
                    }
                    if (pref.prev_clone != null) {
                        pref.prev_clone.next_clone = pref.next_clone;
                    }
                    pref.prev_clone = null;
                    pref.next_clone = null;
                    pref.preference_add_ref();
                    pref.preference_remove_ref(this);
                }
                pref = next_pref;
            }
            inst = next_inst;
        }
    }

    private void process_o_rejects_and_deallocate_them(List<Preference> o_rejects, List<Preference> bufdeallo) {
        for (Preference pref : o_rejects) {
            pref.preference_add_ref();
        }
        for (Preference pref : o_rejects) {
            Slot s = Slot.find_slot(pref.id, pref.attr);
            if (s != null) {
                Preference p = s.getAllPreferences();
                while (p != null) {
                    Preference next_p = p.nextOfSlot;
                    if (p.value == pref.value) {
                        p.preference_add_ref();
                        bufdeallo.add(p);
                        this.remove_preference_from_tm(p);
                    }
                    p = next_p;
                }
            }
            pref.preference_remove_ref(this);
        }
    }

    public void add_preference_to_tm(Preference pref) {
        IdentifierImpl refId;
        IdentifierImpl valueId;
        Slot s;
        pref.slot = s = Slot.make_slot(pref.id, pref.attr, this.predefinedSyms.operator_symbol);
        s.addPreference(pref);
        pref.preference_add_ref();
        if (this.wma.wma_enabled() && !s.isa_context_slot && s.changed == null && s.wma_val_references != null) {
            s.wma_val_references.clear();
        }
        this.tempMemory.mark_slot_as_changed(s);
        if (this.wma.wma_enabled() && !s.isa_context_slot) {
            boolean exists = false;
            WmeImpl w = pref.slot.getWmes();
            while (!exists && w != null) {
                if (w.getValue() == pref.value) {
                    exists = true;
                }
                w = w.next;
            }
            if (!exists) {
                Long numRef;
                if (s.wma_val_references == null) {
                    s.wma_val_references = new HashMap<Symbol, Long>();
                }
                if ((numRef = s.wma_val_references.get(pref.value)) == null) {
                    numRef = 0L;
                }
                numRef = numRef + 1L;
                s.wma_val_references.put(pref.value, numRef);
            }
        }
        if ((valueId = pref.value.asIdentifier()) != null) {
            this.decider.post_link_addition(pref.id, valueId);
        }
        if (pref.type.isBinary() && (refId = pref.referent.asIdentifier()) != null) {
            this.decider.post_link_addition(pref.id, refId);
        }
        if (s.isa_context_slot && (pref.type == PreferenceType.ACCEPTABLE || pref.type == PreferenceType.REQUIRE)) {
            this.decider.mark_context_slot_as_acceptable_preference_changed(s);
        }
    }

    public void remove_preference_from_tm(Preference pref) {
        IdentifierImpl refId;
        IdentifierImpl valueId;
        Slot s = pref.slot;
        s.removePreference(pref);
        this.tempMemory.mark_slot_as_changed(s);
        if (s.isa_context_slot && (pref.type == PreferenceType.ACCEPTABLE || pref.type == PreferenceType.REQUIRE)) {
            this.decider.mark_context_slot_as_acceptable_preference_changed(s);
        }
        if ((valueId = pref.value.asIdentifier()) != null) {
            this.decider.post_link_removal(pref.id, valueId);
        }
        if (pref.type.isBinary() && (refId = pref.referent.asIdentifier()) != null) {
            this.decider.post_link_removal(pref.id, refId);
        }
        pref.preference_remove_ref(this);
    }

    public void do_preference_phase(IdentifierImpl top_goal) {
        ArrayList bufdeallo;
        block22: {
            Trace trace = this.context.getTrace();
            if (trace.isEnabled(Trace.Category.PHASES) && this.decisionCycle.current_phase.get() == Phase.APPLY) {
                switch (this.FIRING_TYPE) {
                    case PE_PRODS: {
                        trace.startNewLine().print("--- Firing Productions (PE) For State At Depth %d ---", this.decider.active_level);
                        break;
                    }
                    case IE_PRODS: {
                        trace.startNewLine().print("--- Firing Productions (IE) For State At Depth %d ---", this.decider.active_level);
                        break;
                    }
                }
            }
            if (this.wma.wma_enabled()) {
                this.soarReteListener.wma_activate_wmes_tested_in_prods();
            }
            this.decider.highest_active_level = this.decider.active_level;
            this.decider.highest_active_goal = this.decider.active_goal;
            this.decider.change_level = this.decider.highest_active_level;
            this.decider.next_change_level = this.decider.highest_active_level;
            bufdeallo = Lists.newArrayList();
            while (true) {
                this.decider.change_level = this.decider.next_change_level;
                if (trace.isEnabled(Trace.Category.WATERFALL)) {
                    trace.print("--- Inner Elaboration Phase, active level: %d", this.decider.active_level);
                    if (this.decider.active_goal != null) {
                        trace.print(" (%s)", this.decider.active_goal);
                    }
                    trace.print(" ---\n");
                }
                this.newly_created_instantiations = null;
                Object assertion = null;
                boolean assertionsExist = false;
                while ((assertion = this.soarReteListener.postpone_assertion()) != null) {
                    assertionsExist = true;
                    if (this.chunker.isMaxChunksReached()) {
                        this.soarReteListener.consume_last_postponed_assertion();
                        this.decisionCycle.halt("Max chunks reached");
                        return;
                    }
                    if (((SoarReteAssertion)assertion).production.getType() == ProductionType.JUSTIFICATION) {
                        this.soarReteListener.consume_last_postponed_assertion();
                        continue;
                    }
                    if (!this.shouldCreateInstantiation(((SoarReteAssertion)assertion).production, ((SoarReteAssertion)assertion).token, ((SoarReteAssertion)assertion).wme)) continue;
                    this.soarReteListener.consume_last_postponed_assertion();
                    this.create_instantiation(((SoarReteAssertion)assertion).production, ((SoarReteAssertion)assertion).token, ((SoarReteAssertion)assertion).wme);
                }
                if (assertionsExist && this.decider.active_level > this.decider.next_change_level) {
                    this.decider.next_change_level = this.decider.active_level;
                }
                this.soarReteListener.restore_postponed_assertions();
                this.assert_new_preferences(bufdeallo);
                this.decisionCycle.inner_e_cycle_count.increment();
                if (this.decider.active_goal == null) {
                    trace.print(Trace.Category.WATERFALL, " inner preference loop doesn't have active goal.\n");
                    break block22;
                }
                if (this.decider.active_goal.goalInfo.lower_goal == null) {
                    trace.print(Trace.Category.WATERFALL, " inner preference loop at bottom goal.\n");
                    break block22;
                }
                if (this.decisionCycle.current_phase.get() == Phase.APPLY) {
                    this.decider.active_goal = this.consistency.highest_active_goal_apply(this.decider.active_goal.goalInfo.lower_goal, true);
                } else if (this.decisionCycle.current_phase.get() == Phase.PROPOSE) {
                    this.decider.active_goal = this.consistency.highest_active_goal_propose(this.decider.active_goal.goalInfo.lower_goal, true);
                }
                if (this.decider.active_goal == null) break;
                this.decider.active_level = this.decider.active_goal.level;
            }
            trace.print(Trace.Category.WATERFALL, " inner preference loop finished but not at quiescence.\n");
        }
        for (Preference p : bufdeallo) {
            p.preference_remove_ref(this);
        }
        this.decider.active_level = this.decider.highest_active_level;
        this.decider.active_goal = this.decider.highest_active_goal;
        Instantiation inst = null;
        while ((inst = this.soarReteListener.get_next_retraction()) != null) {
            this.retract_instantiation(inst);
        }
        if (this.soarReteListener.hasNilGoalRetractions()) {
            while ((inst = this.soarReteListener.get_next_nil_goal_retraction()) != null) {
                this.retract_instantiation(inst);
            }
        }
    }

    private class RhsFunctionContextImpl
    implements RhsFunctionContext {
        private RhsFunctionContextImpl() {
        }

        @Override
        public SymbolFactory getSymbols() {
            return RecognitionMemory.this.context.getSymbols();
        }

        @Override
        public Void addWme(Identifier id, Symbol attr, Symbol value) {
            Arguments.checkNotNull(id, "id");
            Arguments.checkNotNull(attr, "attr");
            Arguments.checkNotNull(value, "value");
            Preference p = new Preference(RecognitionMemory.this.rhsFunctionPreferenceType, (IdentifierImpl)id, (SymbolImpl)attr, (SymbolImpl)value, null);
            RecognitionMemory.this.rhsFunctionPreferences.add(p);
            return null;
        }

        @Override
        public Production getProductionBeingFired() {
            return RecognitionMemory.this.production_being_fired;
        }
    }
}

