/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.memory;

import com.google.common.collect.Iterators;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.jsoar.kernel.ImpasseType;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.memory.PreferenceType;
import org.jsoar.kernel.memory.RecognitionMemory;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.memory.WmeIterator;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.StringSymbolImpl;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.util.adaptables.Adaptable;
import org.jsoar.util.adaptables.Adaptables;

public class Slot {
    public Slot next;
    public Slot prev;
    public final IdentifierImpl id;
    public final SymbolImpl attr;
    private WmeImpl wmes;
    private WmeImpl acceptable_preference_wmes;
    private Preference all_preferences;
    private EnumMap<PreferenceType, Preference> preferencesByType;
    private LinkedList<Preference> cdps;
    public IdentifierImpl impasse_id = null;
    public final boolean isa_context_slot;
    public ImpasseType impasse_type = ImpasseType.NONE;
    public boolean marked_for_possible_removal = false;
    public Object changed;
    public Object acceptable_preference_changed;
    public Map<Symbol, Long> wma_val_references;

    public static Slot make_slot(IdentifierImpl id, SymbolImpl attr, StringSymbolImpl operator_symbol) {
        Slot s = Slot.find_slot(id, attr);
        if (s != null) {
            return s;
        }
        return new Slot(id, attr, operator_symbol);
    }

    private Slot(IdentifierImpl id, SymbolImpl attr, StringSymbolImpl operator_symbol) {
        id.addSlot(this);
        this.isa_context_slot = id.isGoal() && attr == operator_symbol;
        this.id = id;
        this.attr = attr;
    }

    public static Slot find_slot(IdentifierImpl id, Symbol attr) {
        if (id == null) {
            return null;
        }
        Slot s = id.slots;
        while (s != null) {
            if (s.attr == attr) {
                return s;
            }
            s = s.next;
        }
        return null;
    }

    public Preference getPreferencesByType(PreferenceType type) {
        if (this.preferencesByType == null) {
            return null;
        }
        return this.preferencesByType.get((Object)type);
    }

    public WmeImpl getWmes() {
        return this.wmes;
    }

    public void addWme(WmeImpl w) {
        this.wmes = w.addToList(this.wmes);
    }

    public void removeWme(WmeImpl w) {
        this.wmes = w.removeFromList(this.wmes);
    }

    public void removeAllWmes() {
        this.wmes = null;
    }

    public Iterator<Wme> getWmeIterator() {
        return Iterators.concat((Iterator)new WmeIterator(this.acceptable_preference_wmes), (Iterator)new WmeIterator(this.wmes));
    }

    public WmeImpl getAcceptablePreferenceWmes() {
        return this.acceptable_preference_wmes;
    }

    public void addAcceptablePreferenceWme(WmeImpl wme) {
        this.acceptable_preference_wmes = wme.addToList(this.acceptable_preference_wmes);
    }

    public void removeAcceptablePreferenceWme(WmeImpl w) {
        this.acceptable_preference_wmes = w.removeFromList(this.acceptable_preference_wmes);
    }

    public Preference getAllPreferences() {
        return this.all_preferences;
    }

    public void addPreference(Preference pref) {
        pref.slot = this;
        pref.nextOfSlot = this.all_preferences;
        pref.previousOfSlot = null;
        if (this.all_preferences != null) {
            this.all_preferences.previousOfSlot = pref;
        }
        this.all_preferences = pref;
        this.addPreferenceToCorrectTypeList(pref);
    }

    public void removePreference(Preference pref) {
        pref.slot = null;
        this.removePreferenceByType(pref);
        if (pref.nextOfSlot != null) {
            pref.nextOfSlot.previousOfSlot = pref.previousOfSlot;
        }
        if (pref.previousOfSlot != null) {
            pref.previousOfSlot.nextOfSlot = pref.nextOfSlot;
        } else {
            this.all_preferences = pref.nextOfSlot;
        }
        pref.nextOfSlot = null;
        pref.previousOfSlot = null;
    }

    private void addPreferenceToCorrectTypeList(Preference pref) {
        Preference s_prefs = this.getPreferencesByType(pref.type);
        if (s_prefs == null) {
            this.addPreferenceByType(pref, null);
        } else if (s_prefs.inst.match_goal_level >= pref.inst.match_goal_level) {
            this.addPreferenceByType(pref, null);
        } else {
            Preference it = s_prefs;
            while (it.next != null && it.inst.match_goal_level < pref.inst.match_goal_level) {
                it = it.next;
            }
            this.addPreferenceByType(pref, it);
        }
    }

    private void addPreferenceByType(Preference pref, Preference after) {
        if (this.preferencesByType == null) {
            this.preferencesByType = new EnumMap(PreferenceType.class);
        }
        if (after == null) {
            Preference head;
            pref.next = head = this.preferencesByType.get((Object)pref.type);
            pref.previous = null;
            if (head != null) {
                head.previous = pref;
            }
            this.preferencesByType.put(pref.type, pref);
        } else {
            assert (this.preferencesByType.get((Object)pref.type) != null);
            pref.next = after.next;
            pref.previous = after;
            after.next = pref;
            if (pref.next != null) {
                pref.next.previous = pref;
            }
        }
    }

    private void removePreferenceByType(Preference pref) {
        if (this.preferencesByType == null) {
            return;
        }
        if (pref.next != null) {
            pref.next.previous = pref.previous;
        }
        if (pref.previous != null) {
            pref.previous.next = pref.next;
        } else if (pref.next == null) {
            this.preferencesByType.remove((Object)pref.type);
        } else {
            this.preferencesByType.put(pref.type, pref.next);
        }
        pref.next = null;
        pref.previous = null;
    }

    public void clear_CDPS(Adaptable context) {
        if (!this.hasContextDependentPreferenceSet()) {
            return;
        }
        RecognitionMemory recMemory = Adaptables.adapt(context, RecognitionMemory.class);
        Iterator it = this.cdps.iterator();
        while (it.hasNext()) {
            Preference p = (Preference)it.next();
            p.preference_remove_ref(recMemory);
            it.remove();
        }
    }

    public boolean hasContextDependentPreferenceSet() {
        return this.cdps != null && !this.cdps.isEmpty();
    }

    LinkedList<Preference> getContextDependentPreferenceSet() {
        return this.cdps;
    }

    public void add_to_CDPS(Adaptable context, Preference pref) {
        this.add_to_CDPS(context, pref, true);
    }

    public void add_to_CDPS(Adaptable context, Preference pref, boolean unique_value) {
        Trace trace = Adaptables.adapt(context, Trace.class);
        Printer printer = trace.getPrinter();
        boolean traceBacktracing = trace.isEnabled(Trace.Category.BACKTRACING);
        if (traceBacktracing) {
            printer.print("--> Adding preference to CDPS: %s", pref);
        }
        if (this.cdps == null) {
            this.cdps = new LinkedList();
        }
        boolean already_exists = false;
        for (Preference p : this.cdps) {
            if (p == pref) {
                already_exists = true;
                break;
            }
            if (!unique_value) continue;
            if (!(pref.type != PreferenceType.BETTER && pref.type != PreferenceType.WORSE || p.type != PreferenceType.BETTER && p.type != PreferenceType.WORSE)) {
                already_exists = pref.type == p.type ? pref.value == p.value && pref.referent == p.referent : pref.value == p.referent && pref.referent == p.value;
            } else if (pref.type == PreferenceType.BINARY_INDIFFERENT && p.type == PreferenceType.BINARY_INDIFFERENT) {
                already_exists = pref.value == p.value && pref.referent == p.referent || pref.value == p.referent && pref.referent == p.value;
            } else {
                boolean bl = already_exists = pref.value == p.value && pref.type == p.type;
            }
            if (!already_exists) continue;
            break;
        }
        if (!already_exists) {
            this.cdps.push(pref);
            pref.preference_add_ref();
        } else if (traceBacktracing) {
            printer.print("--> equivalent pref already exists. Not adding.\n");
        }
    }
}

