/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.memory;

import java.util.HashMap;
import java.util.Map;
import org.jsoar.kernel.memory.WmeFactory;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.Symbols;

public class WmeBuilder<T> {
    private final WmeFactory<T> wmeFactory;
    private final Identifier id;
    private final WmeBuilder<T> parent;
    private final Map<String, Identifier> idMap;
    private final Map<String, T> wmeMap;

    public static <U> WmeBuilder<U> create(WmeFactory<U> wmeFactory, String rootName) {
        return new WmeBuilder<U>(wmeFactory, null, rootName, new HashMap<String, Identifier>(), new HashMap());
    }

    public static <U> WmeBuilder<U> create(WmeFactory<U> wmeFactory, Identifier root) {
        return new WmeBuilder<U>(wmeFactory, null, root, new HashMap<String, Identifier>(), new HashMap());
    }

    private WmeBuilder(WmeFactory<T> wmeFactory, WmeBuilder<T> parent, String rootAttr, Map<String, Identifier> idMap, Map<String, T> wmeMap) {
        Identifier newId = wmeFactory.getSymbols().createIdentifier(Symbols.getFirstLetter(rootAttr));
        this.wmeFactory = wmeFactory;
        this.parent = parent;
        this.id = newId;
        this.idMap = idMap;
        this.wmeMap = wmeMap;
    }

    private WmeBuilder(WmeFactory<T> wmeFactory, WmeBuilder<T> parent, Identifier id, Map<String, Identifier> idMap, Map<String, T> wmeMap) {
        this.wmeFactory = wmeFactory;
        this.parent = parent;
        this.id = id;
        this.idMap = idMap;
        this.wmeMap = wmeMap;
    }

    public WmeBuilder<T> add(Object attr, Object value) {
        SymbolFactory syms = this.wmeFactory.getSymbols();
        this.wmeMap.put(null, this.wmeFactory.addWme(this.id, Symbols.create(syms, attr), Symbols.create(syms, value)));
        return this;
    }

    public WmeBuilder<T> push(Object attr) {
        Identifier newId = this.wmeFactory.getSymbols().createIdentifier(Symbols.getFirstLetter(attr));
        SymbolFactory syms = this.wmeFactory.getSymbols();
        this.wmeMap.put(null, this.wmeFactory.addWme(this.id, Symbols.create(syms, attr), Symbols.create(syms, newId)));
        return new WmeBuilder<T>(this.wmeFactory, this, newId, this.idMap, this.wmeMap);
    }

    public WmeBuilder<T> markId(String name) {
        this.idMap.put(name, this.id);
        return this;
    }

    public Identifier getId(String name) {
        return this.idMap.get(name);
    }

    public WmeBuilder<T> markWme(String name) {
        this.wmeMap.put(name, this.wmeMap.get(null));
        return this;
    }

    public T getWme(String name) {
        return this.wmeMap.get(name);
    }

    public WmeBuilder<T> pop() {
        if (this.parent == null) {
            throw new IllegalStateException("Can't pop");
        }
        return this.parent;
    }

    public WmeBuilder<T> top() {
        if (this.parent == null) {
            return this;
        }
        WmeBuilder<T> p = this.parent;
        while (p.parent != null) {
            p = p.parent;
        }
        return p;
    }

    public Identifier topId() {
        return this.top().id;
    }

    public WmeBuilder<T> jump(String idName) {
        Identifier newId = this.idMap.get(idName);
        if (newId == null) {
            throw new IllegalArgumentException("No id with name '" + idName + "'");
        }
        return new WmeBuilder<T>(this.wmeFactory, this, newId, this.idMap, this.wmeMap);
    }
}

