/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.memory;

import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import org.jsoar.kernel.GoalDependencySet;
import org.jsoar.kernel.GoalDependencySetImpl;
import org.jsoar.kernel.io.InputWme;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeIterator;
import org.jsoar.kernel.memory.WmePreferenceIterator;
import org.jsoar.kernel.rete.RightMemory;
import org.jsoar.kernel.rete.Token;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.wma.WorkingMemoryActivation;
import org.jsoar.util.adaptables.AbstractAdaptable;

public class WmeImpl
extends AbstractAdaptable
implements Wme {
    public final IdentifierImpl id;
    public final SymbolImpl attr;
    public final SymbolImpl value;
    public final boolean acceptable;
    public final int timetag;
    private InputWme outerInputWme;
    private RightMemory right_mems;
    public Token tokens = null;
    public WmeImpl next;
    private WmeImpl previous;
    public Preference preference;
    public int grounds_tc;
    public int potentials_tc;
    public int locals_tc;
    public long epmem_id = 0L;
    public long epmem_valid = 0L;
    public Preference chunker_bt_pref;
    public GoalDependencySetImpl gds;
    public WmeImpl gds_next;
    public WmeImpl gds_prev;
    public WorkingMemoryActivation wma;

    public WmeImpl(IdentifierImpl id, SymbolImpl attr, SymbolImpl value, boolean acceptable, int timetag) {
        this(id, attr, value, acceptable, timetag, null);
    }

    public WmeImpl(IdentifierImpl id, SymbolImpl attr, SymbolImpl value, boolean acceptable, int timetag, WorkingMemoryActivation wma) {
        this.id = id;
        this.attr = attr;
        this.value = value;
        this.acceptable = acceptable;
        this.timetag = timetag;
        this.wma = wma;
    }

    public void setOuterInputWme(InputWme outer) {
        assert (this.outerInputWme == null && outer != null || this.outerInputWme != null && outer == null);
        this.outerInputWme = outer;
    }

    public SymbolImpl getField(int field) {
        switch (field) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.attr;
            }
            case 2: {
                return this.value;
            }
        }
        throw new IllegalArgumentException("field_num must be 0, 1, or 2, got" + field);
    }

    public boolean isMemberOfList(WmeImpl head) {
        WmeImpl w = head;
        while (w != null) {
            if (w == this) {
                return true;
            }
            w = w.next;
        }
        return false;
    }

    public WmeImpl addToList(WmeImpl head) {
        this.next = head;
        this.previous = null;
        if (head != null) {
            head.previous = this;
        }
        return this;
    }

    public WmeImpl removeFromList(WmeImpl head) {
        if (this.next != null) {
            this.next.previous = this.previous;
        }
        if (this.previous != null) {
            this.previous.next = this.next;
        } else {
            head = this.next;
        }
        this.next = null;
        this.previous = null;
        return head;
    }

    public Iterator<Wme> iterator() {
        return new WmeIterator(this);
    }

    public RightMemory getRightMemories() {
        return this.right_mems;
    }

    public void clearRightMemories() {
        this.right_mems = null;
    }

    public void addRightMemory(RightMemory rm) {
        this.right_mems = rm.addToWme(this.right_mems);
    }

    public void removeRightMemory(RightMemory rm) {
        this.right_mems = rm.removeFromWme(this.right_mems);
    }

    @Override
    public Symbol getAttribute() {
        return this.attr;
    }

    @Override
    public Identifier getIdentifier() {
        return this.id;
    }

    @Override
    public int getTimetag() {
        return this.timetag;
    }

    @Override
    public Symbol getValue() {
        return this.value;
    }

    @Override
    public boolean isAcceptable() {
        return this.acceptable;
    }

    @Override
    public Iterator<Wme> getChildren() {
        IdentifierImpl valueAsId = this.value.asIdentifier();
        return valueAsId != null ? valueAsId.getWmes() : Collections.emptyIterator();
    }

    @Override
    public Iterator<Preference> getPreferences() {
        return new WmePreferenceIterator(this);
    }

    public String toString() {
        return "(" + this.timetag + ": " + this.id + " ^" + this.attr + " " + this.value + ")";
    }

    @Override
    public void formatTo(Formatter fmt, int f, int width, int precision) {
        if ((f & 4) == 0) {
            if (this.wma != null && this.wma.wma_enabled()) {
                fmt.format("(%d: %s ^%s %s [%1.2g] %s)\n", this.timetag, this.id, this.attr, this.value, this.wma.wma_get_wme_activation(this, true), this.acceptable ? " +" : "");
            } else {
                fmt.format("(%d: %s ^%s %s%s)\n", this.timetag, this.id, this.attr, this.value, this.acceptable ? " +" : "");
            }
        } else {
            fmt.format("(%s ^%s %s%s)\n", this.id, this.attr, this.value, this.acceptable ? " +" : "");
        }
    }

    @Override
    public Object getAdapter(Class<?> klass) {
        if (InputWme.class.equals(klass)) {
            return this.outerInputWme;
        }
        if (GoalDependencySet.class.equals(klass)) {
            return this.gds;
        }
        return super.getAdapter(klass);
    }

    public static class SymbolTriple {
        public final SymbolImpl id;
        public final SymbolImpl attr;
        public final SymbolImpl value;

        public SymbolTriple(SymbolImpl id, SymbolImpl attr, SymbolImpl value) {
            this.id = id;
            this.attr = attr;
            this.value = value;
        }
    }
}

