/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.memory;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.PredefinedSymbols;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.memory.PreferenceType;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.tracing.TraceFormats;
import org.jsoar.util.Arguments;
import org.jsoar.util.adaptables.AbstractAdaptable;
import org.jsoar.util.adaptables.Adaptables;

public class WmeSupportInfo {
    private final Wme wme;
    private final List<Support> supports;

    public static WmeSupportInfo get(Agent agent, Wme wme) {
        Arguments.checkNotNull(agent, "agent");
        Arguments.checkNotNull(wme, "wme");
        ArrayList<Support> sources = new ArrayList<Support>();
        Iterator<Preference> prefIt = wme.getPreferences();
        while (prefIt.hasNext()) {
            sources.add(WmeSupportInfo.createSupport(agent, prefIt.next()));
        }
        return new WmeSupportInfo(wme, sources);
    }

    public Wme getWme() {
        return this.wme;
    }

    public List<Support> getSupports() {
        return this.supports;
    }

    private static Support createSupport(Agent agent, Preference pref) {
        String valueTrace;
        TraceFormats traceFormats = Adaptables.adapt(agent, TraceFormats.class);
        PredefinedSymbols predefinedSyms = Adaptables.adapt(agent, PredefinedSymbols.class);
        List<Wme> sourceWmes = pref.inst.getBacktraceWmes();
        if (pref.attr == predefinedSyms.operator_symbol) {
            StringWriter w = new StringWriter();
            try {
                traceFormats.print_object_trace(w, pref.value);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            valueTrace = w.toString();
        } else {
            valueTrace = String.format("%s", pref.value);
        }
        return new Support(pref, pref.o_supported, valueTrace, sourceWmes);
    }

    private WmeSupportInfo(Wme wme, List<Support> supports) {
        this.wme = wme;
        this.supports = Collections.unmodifiableList(supports);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(String.format("%s is supported by:\n", this.wme));
        for (Support s : this.supports) {
            b.append(String.format("   %s\n", s.getSource()));
            for (Wme w : s.getSourceWmes()) {
                b.append(String.format("      %s\n", w));
            }
        }
        return b.toString();
    }

    public static class Support
    extends AbstractAdaptable {
        private final Preference pref;
        private final boolean osupported;
        private final String valueTrace;
        private final List<Wme> wmes;

        private Support(Preference pref, boolean osupported, String valueTrace, List<Wme> wmes) {
            this.pref = pref;
            this.osupported = osupported;
            this.valueTrace = valueTrace;
            this.wmes = wmes;
        }

        public PreferenceType getType() {
            return this.pref.type;
        }

        public Identifier getIdentifier() {
            return this.pref.id;
        }

        public Symbol getAttribute() {
            return this.pref.attr;
        }

        public Symbol getValue() {
            return this.pref.value;
        }

        public String getValueTrace() {
            return this.valueTrace;
        }

        public Symbol getReferent() {
            return this.pref.referent;
        }

        public boolean isOSupported() {
            return this.osupported;
        }

        public Production getSource() {
            return this.pref.inst.prod;
        }

        public List<Wme> getSourceWmes() {
            return this.wmes;
        }

        @Override
        public Object getAdapter(Class<?> klass) {
            if (klass.equals(Production.class)) {
                return this.getSource();
            }
            return super.getAdapter(klass);
        }
    }
}

