/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.memory;

import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Decider;
import org.jsoar.kernel.PredefinedSymbols;
import org.jsoar.kernel.SoarProperties;
import org.jsoar.kernel.events.InputWmeGarbageCollectedEvent;
import org.jsoar.kernel.events.WorkingMemoryChangedEvent;
import org.jsoar.kernel.io.InputOutputImpl;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.rete.Rete;
import org.jsoar.kernel.smem.SemanticMemory;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.SymbolFactoryImpl;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.kernel.wma.WorkingMemoryActivation;
import org.jsoar.util.ListHead;
import org.jsoar.util.ListItem;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.events.SoarEventManager;
import org.jsoar.util.properties.LongPropertyProvider;
import org.jsoar.util.properties.PropertyManager;

public class WorkingMemory {
    private Rete rete;
    private PredefinedSymbols predefinedSyms;
    private Trace trace;
    private Decider decider;
    private SoarEventManager eventManager;
    private WorkingMemoryActivation wma;
    private SemanticMemory smem;
    private SymbolFactoryImpl symbols;
    private int current_wme_timetag = 1;
    private final ListHead<WmeImpl> wmes_to_add = ListHead.newInstance();
    private final ListHead<WmeImpl> wmes_to_remove = ListHead.newInstance();
    private final LongPropertyProvider wme_addition_count = new LongPropertyProvider(SoarProperties.WME_ADDITION_COUNT);
    private final LongPropertyProvider wme_removal_count = new LongPropertyProvider(SoarProperties.WME_REMOVAL_COUNT);
    private final LongPropertyProvider max_wm_size = new LongPropertyProvider(SoarProperties.MAX_WM_SIZE);
    private final LongPropertyProvider cumulative_wm_size = new LongPropertyProvider(SoarProperties.CUMULATIVE_WM_SIZE);
    private final LongPropertyProvider num_wm_sizes_accumulated = new LongPropertyProvider(SoarProperties.NUM_WM_SIZES_ACCUMULATED);

    public void initialize(Agent context) {
        PropertyManager pm = context.getProperties();
        pm.setProvider(this.wme_addition_count.key, this.wme_addition_count);
        pm.setProvider(this.wme_removal_count.key, this.wme_removal_count);
        pm.setProvider(this.max_wm_size.key, this.max_wm_size);
        pm.setProvider(this.cumulative_wm_size.key, this.cumulative_wm_size);
        pm.setProvider(this.num_wm_sizes_accumulated.key, this.num_wm_sizes_accumulated);
        this.rete = Adaptables.adapt(context, Rete.class);
        this.predefinedSyms = Adaptables.adapt(context, PredefinedSymbols.class);
        this.trace = context.getTrace();
        this.decider = Adaptables.adapt(context, Decider.class);
        this.eventManager = context.getEvents();
        this.wma = Adaptables.adapt(context, WorkingMemoryActivation.class);
        this.smem = Adaptables.adapt(context, SemanticMemory.class);
        this.symbols = Adaptables.adapt(context, SymbolFactoryImpl.class);
    }

    public void reset() {
        this.wme_addition_count.reset();
        this.wme_removal_count.reset();
        this.max_wm_size.reset();
        this.cumulative_wm_size.reset();
        this.num_wm_sizes_accumulated.reset();
        this.current_wme_timetag = 1;
    }

    public void updateStats(int num_wmes_in_rete) {
        if ((long)num_wmes_in_rete > this.max_wm_size.longValue()) {
            this.max_wm_size.value.set(num_wmes_in_rete);
        }
        this.cumulative_wm_size.value.addAndGet(num_wmes_in_rete);
        this.num_wm_sizes_accumulated.increment();
    }

    public WmeImpl make_wme(IdentifierImpl id, SymbolImpl attr, SymbolImpl value, boolean acceptable) {
        WmeImpl w = new WmeImpl(id, attr, value, acceptable, this.current_wme_timetag++, this.wma);
        return w;
    }

    public void add_wme_to_wm(WmeImpl w) {
        this.wmes_to_add.push(w);
        IdentifierImpl valueId = w.value.asIdentifier();
        if (valueId != null) {
            this.decider.post_link_addition(w.id, valueId);
            if (w.attr == this.predefinedSyms.operator_symbol) {
                valueId.isa_operator = (short)(valueId.isa_operator + 1);
            }
        }
    }

    public void remove_wme_from_wm(WmeImpl w) {
        this.wmes_to_remove.push(w);
        IdentifierImpl valueId = w.value.asIdentifier();
        if (valueId != null) {
            if (valueId.decider_wme == w) {
                valueId.decider_wme = null;
            }
            this.decider.post_link_removal(w.id, valueId);
            if (w.attr == this.predefinedSyms.operator_symbol) {
                valueId.isa_operator = (short)(valueId.isa_operator - 1);
            }
        }
        w.preference = null;
        w.chunker_bt_pref = null;
        if (w.gds != null) {
            w.gds.removeWme(w);
        }
    }

    public void remove_wme_list_from_wm(WmeImpl w, boolean updateWmeMap) {
        if (updateWmeMap) {
            this.eventManager.fireEvent(new InputWmeGarbageCollectedEvent(w));
        }
        while (w != null) {
            WmeImpl next_w = w.next;
            this.remove_wme_from_wm(w);
            w = next_w;
        }
    }

    public void do_buffered_wm_changes(InputOutputImpl io) {
        if (this.wmes_to_add.isEmpty() && this.wmes_to_remove.isEmpty()) {
            return;
        }
        io.inform_output_module_of_wm_changes(this.wmes_to_add, this.wmes_to_remove);
        this.eventManager.fireEvent(new WorkingMemoryChangedEvent(this.wmes_to_add, this.wmes_to_remove));
        ListItem w = this.wmes_to_add.first;
        while (w != null) {
            this.rete.add_wme_to_rete((WmeImpl)w.item);
            w = w.next;
        }
        w = this.wmes_to_remove.first;
        while (w != null) {
            this.rete.remove_wme_from_rete((WmeImpl)w.item);
            if (this.wma.wma_enabled()) {
                this.wma.wma_remove_decay_element((Wme)w.item);
            }
            if (this.smem.smem_enabled() && ((WmeImpl)w.item).id != null && ((WmeImpl)w.item).id.smem_lti > 0L) {
                this.symbols.findAndNullIdentifier(((WmeImpl)w.item).id);
            }
            w = w.next;
        }
        this.warnIfSameWmeAddedAndRemoved();
        boolean traceChanges = this.trace.isEnabled(Trace.Category.WM_CHANGES);
        ListItem w2 = this.wmes_to_add.first;
        while (w2 != null) {
            if (traceChanges) {
                this.trace.startNewLine().print("=>WM: %s", w2.item);
            }
            this.wme_addition_count.increment();
            w2 = w2.next;
        }
        w2 = this.wmes_to_remove.first;
        while (w2 != null) {
            if (traceChanges) {
                this.trace.startNewLine().print("<=WM: %s", w2.item);
            }
            this.wme_removal_count.increment();
            w2 = w2.next;
        }
        this.wmes_to_add.clear();
        this.wmes_to_remove.clear();
    }

    public long getWmeRemovalCount() {
        return this.wme_removal_count.get();
    }

    private void warnIfSameWmeAddedAndRemoved() {
    }
}

