/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.memory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.memory.Slot;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.memory.Wmes;
import org.jsoar.kernel.memory.WorkingMemoryPatternReader;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.util.Arguments;
import org.jsoar.util.markers.DefaultMarker;
import org.jsoar.util.markers.Marker;

public class WorkingMemoryPrinter {
    private Printer printer;
    private int depth = 1;
    private boolean internal = false;
    private boolean tree = false;
    private boolean exact = false;
    private static final Comparator<WmeImpl> ATTRIBUTE_COMPARATOR = new Comparator<WmeImpl>(){

        @Override
        public int compare(WmeImpl o1, WmeImpl o2) {
            return o1.attr.toString().compareTo(o2.attr.toString());
        }
    };

    public void print(Agent agent, Printer printer, Symbol idIn, String pattern) throws Exception {
        Arguments.checkNotNull(agent, "agent");
        Arguments.checkNotNull(printer, "printer");
        this.printer = printer;
        if (idIn == null) {
            if (pattern.length() > 2 && pattern.charAt(0) == '(' && pattern.charAt(pattern.length() - 1) == ')') {
                pattern = pattern.substring(1, pattern.length() - 1);
            }
            List<Wme> wmes = Wmes.filter(agent.getAllWmesInRete().iterator(), WorkingMemoryPatternReader.getPredicate(agent, pattern));
            if (this.internal) {
                for (Wme w : wmes) {
                    if (this.exact) {
                        printer.print("%s", w);
                        continue;
                    }
                    this.do_print_for_identifier((IdentifierImpl)w.getIdentifier());
                }
            } else {
                HashMap objects = new HashMap();
                for (Wme w : wmes) {
                    if (!objects.containsKey(w.getIdentifier())) {
                        objects.put(w.getIdentifier(), new ArrayList());
                    }
                    List l = (List)objects.get(w.getIdentifier());
                    l.add(w);
                }
                for (Symbol id : objects.keySet()) {
                    if (this.exact) {
                        printer.print("(%s", id);
                        for (Wme w : (List)objects.get(id)) {
                            printer.print(" ^%s %s", w.getAttribute(), w.getValue());
                            if (!w.isAcceptable()) continue;
                            printer.print(" +");
                        }
                        printer.print(")\n");
                        continue;
                    }
                    for (Wme w : (List)objects.get(id)) {
                        this.do_print_for_identifier((IdentifierImpl)id.asIdentifier());
                    }
                }
            }
        } else {
            this.do_print_for_identifier((IdentifierImpl)idIn);
        }
        this.printer = null;
    }

    public WorkingMemoryPrinter setDefaults() {
        this.depth = 1;
        this.internal = false;
        this.tree = false;
        return this;
    }

    public int getDepth() {
        return this.depth;
    }

    public WorkingMemoryPrinter setDepth(int depth) {
        this.depth = depth;
        return this;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public WorkingMemoryPrinter setInternal(boolean internal) {
        this.internal = internal;
        return this;
    }

    public boolean isTree() {
        return this.tree;
    }

    public WorkingMemoryPrinter setTree(boolean tree) {
        this.tree = tree;
        return this;
    }

    public boolean isExact() {
        return this.exact;
    }

    public WorkingMemoryPrinter setExact(boolean exact) {
        this.exact = exact;
        return this;
    }

    private void neatly_print_wme_augmentation_of_id(Wme w, int indentation) {
        String buf = String.format(" ^%s %s%s", w.getAttribute(), w.getValue(), w.isAcceptable() ? " +" : "");
        this.printer.print(buf);
    }

    private void do_print_for_identifier(IdentifierImpl id) {
        DefaultMarker tc = DefaultMarker.create();
        this.mark_depths_augs_of_id(id, this.depth, tc);
        tc = DefaultMarker.create();
        this.print_augs_of_id(id, this.depth, this.depth, this.internal, this.tree, tc);
    }

    private void mark_depths_augs_of_id(SymbolImpl idIn, int depth, Marker tc) {
        IdentifierImpl id = idIn.asIdentifier();
        if (id == null) {
            return;
        }
        if (id.tc_number == tc && id.depth >= depth) {
            return;
        }
        id.depth = depth;
        id.tc_number = tc;
        if (depth <= 1) {
            return;
        }
        WmeImpl w = id.getInputWmes();
        while (w != null) {
            this.mark_depths_augs_of_id(w.attr, depth - 1, tc);
            this.mark_depths_augs_of_id(w.value, depth - 1, tc);
            w = w.next;
        }
        WmeImpl wmeImpl = w = id.goalInfo != null ? id.goalInfo.getImpasseWmes() : null;
        while (w != null) {
            this.mark_depths_augs_of_id(w.attr, depth - 1, tc);
            this.mark_depths_augs_of_id(w.value, depth - 1, tc);
            w = w.next;
        }
        Slot s = id.slots;
        while (s != null) {
            WmeImpl w2 = s.getWmes();
            while (w2 != null) {
                this.mark_depths_augs_of_id(w2.attr, depth - 1, tc);
                this.mark_depths_augs_of_id(w2.value, depth - 1, tc);
                w2 = w2.next;
            }
            w2 = s.getAcceptablePreferenceWmes();
            while (w2 != null) {
                this.mark_depths_augs_of_id(w2.attr, depth - 1, tc);
                this.mark_depths_augs_of_id(w2.value, depth - 1, tc);
                w2 = w2.next;
            }
            s = s.next;
        }
    }

    private void print_augs_of_id(SymbolImpl idIn, int depth, int maxdepth, boolean internal, boolean tree, Marker tc) {
        block16: {
            WmeImpl w;
            int attr;
            ArrayList<WmeImpl> list;
            int indent;
            IdentifierImpl id;
            block15: {
                WmeImpl w2;
                id = idIn.asIdentifier();
                if (id == null) {
                    return;
                }
                if (id.tc_number == tc) {
                    return;
                }
                if (id.depth > depth) {
                    return;
                }
                depth = id.depth;
                indent = (maxdepth - depth) * 2;
                id.tc_number = tc;
                list = new ArrayList<WmeImpl>();
                WmeImpl wmeImpl = w2 = id.goalInfo != null ? id.goalInfo.getImpasseWmes() : null;
                while (w2 != null) {
                    list.add(w2);
                    w2 = w2.next;
                }
                w2 = id.getInputWmes();
                while (w2 != null) {
                    list.add(w2);
                    w2 = w2.next;
                }
                Object s = id.slots;
                while (s != null) {
                    WmeImpl w3 = ((Slot)s).getWmes();
                    while (w3 != null) {
                        list.add(w3);
                        w3 = w3.next;
                    }
                    w3 = ((Slot)s).getAcceptablePreferenceWmes();
                    while (w3 != null) {
                        list.add(w3);
                        w3 = w3.next;
                    }
                    s = ((Slot)s).next;
                }
                Collections.sort(list, ATTRIBUTE_COMPARATOR);
                if (!tree) break block15;
                for (WmeImpl w3 : list) {
                    this.printer.spaces(indent);
                    if (internal) {
                        this.printer.print("%s", w3);
                    } else {
                        this.printer.print("%#s", w3);
                    }
                    if (depth <= 1) continue;
                    this.print_augs_of_id(w3.attr, depth - 1, maxdepth, internal, tree, tc);
                    this.print_augs_of_id(w3.value, depth - 1, maxdepth, internal, tree, tc);
                }
                break block16;
            }
            int num_attr = list.size();
            for (attr = 0; attr < num_attr; ++attr) {
                w = (WmeImpl)list.get(attr);
                this.printer.spaces(indent);
                if (internal) {
                    this.printer.print("%s", w);
                    continue;
                }
                this.printer.print("(%s", id);
                for (attr = 0; attr < num_attr; ++attr) {
                    w = (WmeImpl)list.get(attr);
                    this.neatly_print_wme_augmentation_of_id(w, indent);
                }
                this.printer.print(")\n");
            }
            if (depth <= 1) break block16;
            for (attr = 0; attr < num_attr; ++attr) {
                w = (WmeImpl)list.get(attr);
                this.print_augs_of_id(w.attr, depth - 1, maxdepth, internal, tree, tc);
                this.print_augs_of_id(w.value, depth - 1, maxdepth, internal, tree, tc);
            }
        }
    }
}

