/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.parser.original;

import java.io.IOException;
import java.io.Reader;
import org.jsoar.kernel.parser.PossibleSymbolTypes;
import org.jsoar.kernel.parser.original.BasicLexerRoutine;
import org.jsoar.kernel.parser.original.Lexeme;
import org.jsoar.kernel.parser.original.LexemeType;
import org.jsoar.kernel.parser.original.LexerRoutine;
import org.jsoar.kernel.tracing.Printer;

public class Lexer {
    private static final int LENGTH_OF_LONGEST_SPECIAL_LEXEME = 3;
    private static final char EOF_AS_CHAR = '\uffff';
    private final Printer printer;
    private Reader input;
    private char current_char;
    private int prev_char;
    private int current_column = 0;
    private int current_line = 0;
    private int column_of_start_of_last_lexeme = 0;
    private int line_of_start_of_last_lexeme = 0;
    private boolean allow_ids;
    private int parentheses_level = 0;
    private Lexeme lexeme = new Lexeme();
    private static final LexerRoutine lex_unknown = new LexerRoutine(){

        @Override
        public void lex(Lexer lexer) throws IOException {
            lexer.printer.error("Unknown character encountered '%c'", Character.valueOf(lexer.current_char));
            lexer.current_char = '\uffff';
        }
    };
    private LexerRoutine lex_eof = new LexerRoutine(){

        @Override
        public void lex(Lexer lexer) throws IOException {
            lexer.store_and_advance();
            lexer.setLexemeType(LexemeType.EOF);
        }
    };
    private LexerRoutine lex_equal = new LexerRoutine(){

        @Override
        public void lex(Lexer lexer) throws IOException {
            lexer.read_constituent_string();
            if (lexer.lexeme.length() == 1) {
                ((Lexer)lexer).lexeme.type = LexemeType.EQUAL;
            } else {
                lexer.determine_type_of_constituent_string();
            }
        }
    };
    private static LexerRoutine lex_lparen = new BasicLexerRoutine(LexemeType.L_PAREN){

        @Override
        public void lex(Lexer lexer) throws IOException {
            super.lex(lexer);
            lexer.parentheses_level++;
        }
    };
    private static LexerRoutine lex_rparen = new BasicLexerRoutine(LexemeType.R_PAREN){

        @Override
        public void lex(Lexer lexer) throws IOException {
            super.lex(lexer);
            if (lexer.parentheses_level > 0) {
                lexer.parentheses_level--;
            }
        }
    };
    private static LexerRoutine lex_greater = new LexerRoutine(){

        @Override
        public void lex(Lexer lexer) throws IOException {
            lexer.read_constituent_string();
            if (lexer.lexeme.length() == 1) {
                ((Lexer)lexer).lexeme.type = LexemeType.GREATER;
                return;
            }
            if (lexer.lexeme.length() == 2) {
                if (lexer.lexeme.at(1) == '>') {
                    ((Lexer)lexer).lexeme.type = LexemeType.GREATER_GREATER;
                    return;
                }
                if (lexer.lexeme.at(1) == '=') {
                    ((Lexer)lexer).lexeme.type = LexemeType.GREATER_EQUAL;
                    return;
                }
            }
            lexer.determine_type_of_constituent_string();
        }
    };
    private static LexerRoutine lex_less = new LexerRoutine(){

        @Override
        public void lex(Lexer lexer) throws IOException {
            lexer.read_constituent_string();
            if (lexer.lexeme.length() == 1) {
                ((Lexer)lexer).lexeme.type = LexemeType.LESS;
                return;
            }
            if (lexer.lexeme.length() == 2) {
                if (lexer.lexeme.at(1) == '>') {
                    ((Lexer)lexer).lexeme.type = LexemeType.NOT_EQUAL;
                    return;
                }
                if (lexer.lexeme.at(1) == '=') {
                    ((Lexer)lexer).lexeme.type = LexemeType.LESS_EQUAL;
                    return;
                }
                if (lexer.lexeme.at(1) == '<') {
                    ((Lexer)lexer).lexeme.type = LexemeType.LESS_LESS;
                    return;
                }
            }
            if (lexer.lexeme.length() == 3 && lexer.lexeme.at(1) == '=' && lexer.lexeme.at(2) == '>') {
                ((Lexer)lexer).lexeme.type = LexemeType.LESS_EQUAL_GREATER;
                return;
            }
            lexer.determine_type_of_constituent_string();
        }
    };
    private static LexerRoutine lex_period = new LexerRoutine(){

        @Override
        public void lex(Lexer lexer) throws IOException {
            boolean float_disallowed = !Character.isWhitespace(lexer.prev_char) && (((Lexer)lexer).lexeme.type == LexemeType.SYM_CONSTANT || ((Lexer)lexer).lexeme.type == LexemeType.VARIABLE);
            lexer.store_and_advance();
            if (!float_disallowed && Character.isDigit(lexer.current_char)) {
                lexer.read_rest_of_floating_point_number();
            }
            if (lexer.lexeme.length() == 1) {
                ((Lexer)lexer).lexeme.type = LexemeType.PERIOD;
                return;
            }
            lexer.determine_type_of_constituent_string();
        }
    };
    private static LexerRoutine lex_plus = new LexerRoutine(){

        @Override
        public void lex(Lexer lexer) throws IOException {
            lexer.read_constituent_string();
            if (lexer.current_char == '.') {
                boolean could_be_floating_point = true;
                for (int i = 1; i < lexer.lexeme.length(); ++i) {
                    if (Character.isDigit(lexer.lexeme.at(i))) continue;
                    could_be_floating_point = false;
                }
                if (could_be_floating_point) {
                    lexer.read_rest_of_floating_point_number();
                }
            }
            if (lexer.lexeme.length() == 1) {
                ((Lexer)lexer).lexeme.type = LexemeType.PLUS;
                return;
            }
            lexer.determine_type_of_constituent_string();
        }
    };
    private static LexerRoutine lex_minus = new LexerRoutine(){

        @Override
        public void lex(Lexer lexer) throws IOException {
            lexer.read_constituent_string();
            if (lexer.current_char == '.') {
                boolean could_be_floating_point = true;
                for (int i = 1; i < lexer.lexeme.length(); ++i) {
                    if (Character.isDigit(lexer.lexeme.at(i))) continue;
                    could_be_floating_point = false;
                }
                if (could_be_floating_point) {
                    lexer.read_rest_of_floating_point_number();
                }
            }
            if (lexer.lexeme.length() == 1) {
                ((Lexer)lexer).lexeme.type = LexemeType.MINUS;
                return;
            }
            if (lexer.lexeme.length() == 3 && lexer.lexeme.at(1) == '-' && lexer.lexeme.at(2) == '>') {
                ((Lexer)lexer).lexeme.type = LexemeType.RIGHT_ARROW;
                return;
            }
            lexer.determine_type_of_constituent_string();
        }
    };
    private static LexerRoutine lex_digit = new LexerRoutine(){

        @Override
        public void lex(Lexer lexer) throws IOException {
            lexer.read_constituent_string();
            if (lexer.current_char == '.') {
                boolean could_be_floating_point = true;
                for (int i = 1; i < lexer.lexeme.length(); ++i) {
                    if (Character.isDigit(lexer.lexeme.at(i))) continue;
                    could_be_floating_point = false;
                }
                if (could_be_floating_point) {
                    lexer.read_rest_of_floating_point_number();
                }
            }
            lexer.determine_type_of_constituent_string();
        }
    };
    private static LexerRoutine lex_constituent_string = new LexerRoutine(){

        @Override
        public void lex(Lexer lexer) throws IOException {
            lexer.read_constituent_string();
            lexer.determine_type_of_constituent_string();
        }
    };
    private static LexerRoutine lex_vbar = new LexerRoutine(){

        @Override
        public void lex(Lexer lexer) throws IOException {
            ((Lexer)lexer).lexeme.type = LexemeType.SYM_CONSTANT;
            lexer.get_next_char();
            while (true) {
                if (lexer.current_char == '\uffff') {
                    lexer.printer.print("Error: opening '|' without closing '|'\n");
                    lexer.print_location_of_most_recent_lexeme();
                    ((Lexer)lexer).lexeme.type = LexemeType.EOF;
                    return;
                }
                if (lexer.current_char == '\\') {
                    lexer.get_next_char();
                    ((Lexer)lexer).lexeme.string = ((Lexer)lexer).lexeme.string + lexer.current_char;
                    lexer.get_next_char();
                    continue;
                }
                if (lexer.current_char == '|') break;
                ((Lexer)lexer).lexeme.string = ((Lexer)lexer).lexeme.string + lexer.current_char;
                lexer.get_next_char();
            }
            lexer.get_next_char();
        }
    };
    private static LexerRoutine lex_quote = new LexerRoutine(){

        @Override
        public void lex(Lexer lexer) throws IOException {
            ((Lexer)lexer).lexeme.type = LexemeType.QUOTED_STRING;
            lexer.get_next_char();
            while (true) {
                if (lexer.current_char == '\uffff') {
                    lexer.printer.print("Error: opening '\"' without closing '\"'\n");
                    lexer.print_location_of_most_recent_lexeme();
                    ((Lexer)lexer).lexeme.type = LexemeType.EOF;
                    return;
                }
                if (lexer.current_char == '\\') {
                    lexer.get_next_char();
                    ((Lexer)lexer).lexeme.string = ((Lexer)lexer).lexeme.string + lexer.current_char;
                    lexer.get_next_char();
                    continue;
                }
                if (lexer.current_char == '\"') break;
                ((Lexer)lexer).lexeme.string = ((Lexer)lexer).lexeme.string + lexer.current_char;
                lexer.get_next_char();
            }
            lexer.get_next_char();
        }
    };
    private final LexerRoutine[] lexer_routines = new LexerRoutine[256];
    static final boolean[] constituent_char = new boolean[256];
    static final boolean[] number_starters;

    private static boolean isConstituentChar(char c) {
        return c < constituent_char.length && constituent_char[c];
    }

    public Lexer(Printer printer, Reader reader) throws IOException {
        this.printer = printer;
        this.input = reader;
        this.init_lexer();
        this.get_next_char();
    }

    Printer getPrinter() {
        return this.printer;
    }

    public Lexeme getCurrentLexeme() {
        return this.lexeme;
    }

    public boolean isEof() {
        return this.lexeme.type == LexemeType.EOF;
    }

    private void get_next_char() throws IOException {
        if (this.current_char == '\uffff') {
            this.prev_char = 65535;
            return;
        }
        this.prev_char = this.current_char;
        int next_char = this.input.read();
        this.current_char = next_char >= 0 ? (int)next_char : 65535;
    }

    private void record_position_of_start_of_lexeme() {
        this.column_of_start_of_last_lexeme = this.current_column - 1;
        this.line_of_start_of_last_lexeme = this.current_line;
    }

    public void setLexemeType(LexemeType type) {
        this.lexeme.type = type;
    }

    void store_and_advance() throws IOException {
        this.lexeme.append(this.current_char);
        this.get_next_char();
    }

    void read_constituent_string() throws IOException {
        while (this.current_char != '\uffff' && Lexer.isConstituentChar(this.current_char)) {
            this.store_and_advance();
        }
    }

    void read_rest_of_floating_point_number() throws IOException {
        this.store_and_advance();
        while (Character.isDigit(this.current_char)) {
            this.store_and_advance();
        }
        if (this.current_char == 'e' || this.current_char == 'E') {
            this.store_and_advance();
            if (this.current_char == '+' || this.current_char == '-') {
                this.store_and_advance();
            }
            while (Character.isDigit(this.current_char)) {
                this.store_and_advance();
            }
        }
    }

    private boolean determine_type_of_constituent_string() {
        PossibleSymbolTypes possibleType = Lexer.determine_possible_symbol_types_for_string(this.lexeme.string);
        if (possibleType.possible_var) {
            this.lexeme.type = LexemeType.VARIABLE;
            return true;
        }
        if (possibleType.possible_ic) {
            try {
                this.lexeme.type = LexemeType.INTEGER;
                this.lexeme.int_val = this.lexeme.string.charAt(0) != '+' ? Long.valueOf(this.lexeme.string).longValue() : Long.valueOf(this.lexeme.string.substring(1)).longValue();
            }
            catch (NumberFormatException e) {
                this.printer.print("Error: bad integer '" + this.lexeme.string + "' (possibly too large)\n");
                this.print_location_of_most_recent_lexeme();
                this.lexeme.int_val = 0L;
                return false;
            }
            return true;
        }
        if (possibleType.possible_fc) {
            try {
                this.lexeme.type = LexemeType.FLOAT;
                this.lexeme.float_val = Double.valueOf(this.lexeme.string);
            }
            catch (NumberFormatException e) {
                this.printer.print("Error: bad floating point number: '" + this.lexeme.string + "\n");
                this.print_location_of_most_recent_lexeme();
                this.lexeme.float_val = 0.0;
                return false;
            }
            return true;
        }
        if (this.allow_ids && possibleType.possible_id) {
            try {
                this.lexeme.id_letter = Character.toUpperCase(this.lexeme.string.charAt(0));
                this.lexeme.type = LexemeType.IDENTIFIER;
                this.lexeme.id_number = Long.valueOf(this.lexeme.string.substring(1));
            }
            catch (NumberFormatException e) {
                this.printer.print("Error: bad number for identifier (probably too large)\n");
                this.print_location_of_most_recent_lexeme();
                this.lexeme.id_number = 0L;
                return false;
            }
            return true;
        }
        this.lexeme.type = LexemeType.SYM_CONSTANT;
        if (this.printer.isPrintWarnings() && (this.lexeme.string.startsWith("<") || this.lexeme.string.endsWith(">"))) {
            this.printer.print("Warning: Suspicious string constant \"%s\"\n", this.lexeme.string);
            this.print_location_of_most_recent_lexeme();
        }
        return true;
    }

    public void getNextLexeme() throws IOException {
        this.lexeme.string = "";
        this.consumeWhitespaceAndComments();
        this.record_position_of_start_of_lexeme();
        if (this.current_char != '\uffff') {
            this.lexer_routines[this.current_char].lex(this);
        } else {
            this.lex_eof.lex(this);
        }
    }

    private void consumeWhitespaceAndComments() throws IOException {
        while (this.current_char != '\uffff') {
            if (Character.isWhitespace(this.current_char)) {
                this.get_next_char();
                continue;
            }
            if (this.current_char == ';') {
                this.get_next_char();
                continue;
            }
            if (this.current_char != '#') break;
            while (this.current_char != '\n' && this.current_char != '\uffff') {
                this.get_next_char();
            }
            if (this.current_char == '\uffff') continue;
            this.get_next_char();
        }
    }

    private void init_lexer() {
        block19: for (int i = 0; i < this.lexer_routines.length; ++i) {
            switch (i) {
                case 64: {
                    this.lexer_routines[i] = new BasicLexerRoutine(LexemeType.AT);
                    continue block19;
                }
                case 40: {
                    this.lexer_routines[i] = lex_lparen;
                    continue block19;
                }
                case 41: {
                    this.lexer_routines[i] = lex_rparen;
                    continue block19;
                }
                case 43: {
                    this.lexer_routines[i] = lex_plus;
                    continue block19;
                }
                case 45: {
                    this.lexer_routines[i] = lex_minus;
                    continue block19;
                }
                case 126: {
                    this.lexer_routines[i] = new BasicLexerRoutine(LexemeType.TILDE);
                    continue block19;
                }
                case 94: {
                    this.lexer_routines[i] = new BasicLexerRoutine(LexemeType.UP_ARROW);
                    continue block19;
                }
                case 123: {
                    this.lexer_routines[i] = new BasicLexerRoutine(LexemeType.L_BRACE);
                    continue block19;
                }
                case 125: {
                    this.lexer_routines[i] = new BasicLexerRoutine(LexemeType.R_BRACE);
                    continue block19;
                }
                case 33: {
                    this.lexer_routines[i] = new BasicLexerRoutine(LexemeType.EXCLAMATION_POINT);
                    continue block19;
                }
                case 62: {
                    this.lexer_routines[i] = lex_greater;
                    continue block19;
                }
                case 60: {
                    this.lexer_routines[i] = lex_less;
                    continue block19;
                }
                case 61: {
                    this.lexer_routines[i] = this.lex_equal;
                    continue block19;
                }
                case 124: {
                    this.lexer_routines[i] = lex_vbar;
                    continue block19;
                }
                case 44: {
                    this.lexer_routines[i] = new BasicLexerRoutine(LexemeType.COMMA);
                    continue block19;
                }
                case 46: {
                    this.lexer_routines[i] = lex_period;
                    continue block19;
                }
                case 34: {
                    this.lexer_routines[i] = lex_quote;
                    continue block19;
                }
                default: {
                    this.lexer_routines[i] = Character.isDigit((char)i) ? lex_digit : (Lexer.isConstituentChar((char)i) ? lex_constituent_string : lex_unknown);
                }
            }
        }
    }

    private void print_location_of_most_recent_lexeme() {
    }

    public void setAllowIds(boolean allow_identifiers) {
        this.allow_ids = allow_identifiers;
    }

    public boolean isAllowIds() {
        return this.allow_ids;
    }

    public static PossibleSymbolTypes determine_possible_symbol_types_for_string(String s) {
        PossibleSymbolTypes p = new PossibleSymbolTypes();
        if (s.length() == 0) {
            return p;
        }
        if (number_starters[s.charAt(0)]) {
            int ch = 0;
            if (s.charAt(ch) == '+' || s.charAt(ch) == '-') {
                ++ch;
            }
            while (ch < s.length() && Character.isDigit(s.charAt(ch))) {
                ++ch;
            }
            if (ch == s.length() && Character.isDigit(s.charAt(ch - 1))) {
                p.possible_ic = true;
            }
            if (ch < s.length() && s.charAt(ch) == '.') {
                ++ch;
                while (ch < s.length() && Character.isDigit(s.charAt(ch))) {
                    ++ch;
                }
                if (ch < s.length() && (s.charAt(ch) == 'e' || s.charAt(ch) == 'E')) {
                    if (++ch < s.length() && (s.charAt(ch) == '+' || s.charAt(ch) == '-')) {
                        ++ch;
                    }
                    while (ch < s.length() && Character.isDigit(s.charAt(ch))) {
                        ++ch;
                    }
                }
                if (ch == s.length()) {
                    p.possible_fc = true;
                }
            }
        }
        boolean all_alphanum = true;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Lexer.isConstituentChar(c)) {
                return p;
            }
            all_alphanum = all_alphanum && Character.isLetterOrDigit(c);
        }
        if (all_alphanum || s.length() > 3 || s.length() == 1 && s.charAt(0) == '*') {
            p.rereadable = true;
        }
        p.possible_sc = true;
        if (s.charAt(0) == '<' && s.charAt(s.length() - 1) == '>') {
            p.possible_var = true;
        }
        int idStartIndex = s.charAt(0) == '@' ? 1 : 0;
        char idStart = s.charAt(idStartIndex);
        if (s.length() > 1 && Character.isLetter(idStart)) {
            int i;
            for (i = idStartIndex + 1; i < s.length() && Character.isDigit(s.charAt(i)); ++i) {
            }
            p.possible_id = i == s.length();
        }
        return p;
    }

    public void get_lexeme_from_string(String the_lexeme) {
        boolean sym_constant_start_found = false;
        boolean sym_constant_end_found = false;
        this.lexeme.string = new String();
        for (int c = 0; c < the_lexeme.length(); ++c) {
            if (the_lexeme.charAt(c) == '|') {
                if (!sym_constant_start_found) {
                    sym_constant_start_found = true;
                    continue;
                }
                sym_constant_end_found = true;
                continue;
            }
            this.lexeme.string = this.lexeme.string + the_lexeme.charAt(c);
        }
        if (sym_constant_end_found) {
            this.lexeme.type = LexemeType.SYM_CONSTANT;
        } else {
            this.determine_type_of_constituent_string();
        }
    }

    static {
        String extra_constituents = "$%&*+-/:<=>?_";
        for (int i = 0; i < constituent_char.length; ++i) {
            Lexer.constituent_char[i] = i != 0 && "$%&*+-/:<=>?_".indexOf((char)i) != -1 ? true : Character.isLetterOrDigit((char)i);
        }
        number_starters = new boolean[256];
        block6: for (int i = 0; i < number_starters.length; ++i) {
            switch (i) {
                case 43: {
                    Lexer.number_starters[i] = true;
                    continue block6;
                }
                case 45: {
                    Lexer.number_starters[i] = true;
                    continue block6;
                }
                case 46: {
                    Lexer.number_starters[i] = true;
                    continue block6;
                }
                default: {
                    Lexer.number_starters[i] = Character.isDigit((char)i);
                }
            }
        }
    }
}

