/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rete;

import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.rete.Rete;
import org.jsoar.kernel.rete.ReteNode;
import org.jsoar.kernel.rete.RightMemory;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.util.HashFunction;
import org.jsoar.util.HashTable;
import org.jsoar.util.HashTableItem;

public class AlphaMemory
extends HashTableItem {
    final int am_id;
    final SymbolImpl id;
    final SymbolImpl attr;
    final SymbolImpl value;
    final boolean acceptable;
    RightMemory right_mems = null;
    ReteNode beta_nodes;
    ReteNode last_beta_node;
    int reference_count = 1;
    int retesave_amindex;
    public static HashFunction<AlphaMemory> HASH_FUNCTION = new HashFunction<AlphaMemory>(){

        @Override
        public int calculate(AlphaMemory item, int num_bits) {
            AlphaMemory am = item;
            return AlphaMemory.alpha_hash_value(am.id, am.attr, am.value, num_bits);
        }
    };

    public AlphaMemory(int am_id, SymbolImpl id, SymbolImpl attr, SymbolImpl value, boolean acceptable) {
        this.am_id = am_id;
        this.id = id;
        this.attr = attr;
        this.value = value;
        this.acceptable = acceptable;
    }

    boolean wme_matches_alpha_mem(WmeImpl w) {
        return !(this.id != null && this.id != w.id || this.attr != null && this.attr != w.attr || this.value != null && this.value != w.value || this.acceptable != w.acceptable);
    }

    static int alpha_hash_value(SymbolImpl i, SymbolImpl a, SymbolImpl v, int num_bits) {
        return ((i != null ? i.hash_id : 0) ^ (a != null ? a.hash_id : 0) ^ (v != null ? v.hash_id : 0)) & HashTable.masks_for_n_low_order_bits[num_bits];
    }

    void remove_ref_to_alpha_mem(Rete rete) {
        --this.reference_count;
        if (this.reference_count != 0) {
            return;
        }
        HashTable<AlphaMemory> ht = rete.table_for_tests(this.id, this.attr, this.value, this.acceptable);
        ht.remove_from_hash_table(this);
        while (this.right_mems != null) {
            rete.remove_wme_from_alpha_mem(this.right_mems);
        }
    }

    void insertRightMemoryAtHead(RightMemory rm) {
        if (this.right_mems == null) {
            this.right_mems = rm;
            rm.next_in_am = null;
        } else {
            rm.next_in_am = this.right_mems;
            if (this.right_mems != null) {
                this.right_mems.prev_in_am = rm;
            }
            this.right_mems = rm;
        }
        rm.prev_in_am = null;
    }

    void removeRightMemory(RightMemory rm) {
        if (rm == this.right_mems) {
            this.right_mems = rm.next_in_am;
            if (this.right_mems != null) {
                this.right_mems.prev_in_am = null;
            }
        } else {
            rm.prev_in_am.next_in_am = rm.next_in_am;
            if (rm.next_in_am != null) {
                rm.next_in_am.prev_in_am = rm.prev_in_am;
            }
        }
        rm.next_in_am = null;
        rm.prev_in_am = null;
    }

    public String toString() {
        return this.am_id + ": <" + this.id + "," + this.attr + "," + this.value + ">";
    }
}

