/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rete;

import org.jsoar.kernel.Production;
import org.jsoar.kernel.memory.Instantiation;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.rete.ReteNode;
import org.jsoar.kernel.rete.ReteNodeType;
import org.jsoar.kernel.rete.Token;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.util.ListItem;

public class MatchSetChange {
    MatchSetChange next_of_all;
    MatchSetChange prev_of_all;
    MatchSetChange next_of_node;
    MatchSetChange prev_of_node;
    public ReteNode p_node;
    public final Token tok;
    public final WmeImpl w;
    public final Instantiation inst;
    public IdentifierImpl goal;
    public int level;
    public final ListItem<MatchSetChange> in_level = new ListItem<MatchSetChange>(this);

    public static MatchSetChange createAssertion(ReteNode p_node, Token tok, WmeImpl w) {
        return new MatchSetChange(p_node, tok, w);
    }

    public static MatchSetChange createRetraction(ReteNode p_node, Instantiation inst) {
        return new MatchSetChange(p_node, inst);
    }

    public static MatchSetChange createRefracted(ReteNode p_node, Instantiation inst) {
        return new MatchSetChange(p_node, inst);
    }

    private MatchSetChange(ReteNode p_node, Token tok, WmeImpl w) {
        assert (p_node.node_type == ReteNodeType.P_BNODE);
        assert (p_node.b_p() != null);
        this.p_node = p_node;
        this.tok = tok;
        this.w = w;
        this.inst = null;
    }

    private MatchSetChange(ReteNode p_node, Instantiation inst) {
        assert (p_node.node_type == ReteNodeType.P_BNODE);
        assert (p_node.b_p() != null);
        assert (inst != null);
        assert (inst.prod == p_node.b_p().prod);
        this.p_node = p_node;
        this.inst = inst;
        this.w = null;
        this.tok = null;
    }

    public Production getProduction() {
        return this.inst != null ? this.inst.prod : this.p_node.b_p().prod;
    }

    public IdentifierImpl find_goal_for_match_set_change_assertion(Token dummy_top_token) {
        WmeImpl lowest_goal_wme = null;
        if (this.w != null && this.w.id.isGoal()) {
            lowest_goal_wme = this.w;
        }
        Token tok = this.tok;
        while (tok != dummy_top_token) {
            if (tok.w != null && tok.w.id.isGoal()) {
                if (lowest_goal_wme == null) {
                    lowest_goal_wme = tok.w;
                } else if (tok.w.id.level > lowest_goal_wme.id.level) {
                    lowest_goal_wme = tok.w;
                }
            }
            tok = tok.parent;
        }
        if (lowest_goal_wme != null) {
            return lowest_goal_wme.id;
        }
        throw new IllegalStateException("\nError: Did not find goal for ms_change assertion: " + this.p_node.b_p().prod.getName());
    }

    public IdentifierImpl find_goal_for_match_set_change_retraction() {
        if (this.inst.match_goal != null) {
            return this.inst.match_goal;
        }
        return null;
    }

    MatchSetChange addToHeadOfNodeList(MatchSetChange currentHead) {
        this.next_of_node = currentHead;
        this.prev_of_node = null;
        if (currentHead != null) {
            currentHead.prev_of_node = this;
        }
        return this;
    }

    MatchSetChange removeFromNodeList(MatchSetChange currentHead) {
        if (currentHead == this) {
            currentHead = this.next_of_node;
            if (this.next_of_node != null) {
                this.next_of_node.prev_of_node = null;
            }
        } else {
            this.prev_of_node.next_of_node = this.next_of_node;
            if (this.next_of_node != null) {
                this.next_of_node.prev_of_node = this.prev_of_node;
            }
        }
        this.prev_of_node = null;
        this.next_of_node = null;
        return currentHead;
    }

    MatchSetChange addToHeadOfAllList(MatchSetChange currentHead) {
        this.next_of_all = currentHead;
        this.prev_of_all = null;
        if (currentHead != null) {
            currentHead.prev_of_all = this;
        }
        return this;
    }

    MatchSetChange removeFromAllList(MatchSetChange currentHead) {
        if (currentHead == this) {
            currentHead = this.next_of_all;
            if (this.next_of_all != null) {
                this.next_of_all.prev_of_all = null;
            }
        } else {
            this.prev_of_all.next_of_all = this.next_of_all;
            if (this.next_of_all != null) {
                this.next_of_all.prev_of_all = this.prev_of_all;
            }
        }
        this.prev_of_all = null;
        this.next_of_all = null;
        return currentHead;
    }
}

