/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rete;

import org.jsoar.kernel.rete.RightMemory;

public class RightMemoryHashTable {
    private static final int LOG2_RIGHT_HT_SIZE = 14;
    private static final int RIGHT_HT_SIZE = 16384;
    private static final int RIGHT_HT_MASK = 16383;
    private final RightMemory[] buckets = new RightMemory[16384];

    RightMemory right_ht_bucket(int hv) {
        int index = hv & 0x3FFF;
        return this.buckets[index];
    }

    void insertAtHeadOfBucket(int hv, RightMemory rm) {
        int index = hv & 0x3FFF;
        RightMemory oldHead = this.buckets[index];
        if (oldHead == null) {
            rm.next_in_bucket = null;
        } else {
            rm.next_in_bucket = oldHead;
            oldHead.prev_in_bucket = rm;
        }
        rm.prev_in_bucket = null;
        this.buckets[index] = rm;
    }

    void removeFromBucket(int hv, RightMemory rm) {
        int index = hv & 0x3FFF;
        if (rm == this.buckets[index]) {
            if (rm.next_in_bucket != null) {
                rm.next_in_bucket.prev_in_bucket = null;
            }
            this.buckets[index] = rm.next_in_bucket;
        } else {
            rm.prev_in_bucket.next_in_bucket = rm.next_in_bucket;
            if (rm.next_in_bucket != null) {
                rm.next_in_bucket.prev_in_bucket = rm.prev_in_bucket;
            }
        }
        rm.prev_in_bucket = null;
        rm.next_in_bucket = null;
    }
}

