/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rete;

import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.memory.Instantiation;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.memory.Wmes;
import org.jsoar.kernel.parser.ParserContext;
import org.jsoar.kernel.parser.ParserException;
import org.jsoar.kernel.parser.original.OriginalParser;
import org.jsoar.kernel.rete.PartialMatches;
import org.jsoar.kernel.rete.ProductionAddResult;
import org.jsoar.kernel.rete.Rete;
import org.jsoar.kernel.rete.ReteListener;
import org.jsoar.kernel.rete.ReteNode;
import org.jsoar.kernel.rete.Token;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionManager;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.SymbolFactoryImpl;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Trace;

public class SimpleMatcher {
    private final SymbolFactoryImpl syms = new SymbolFactoryImpl();
    private final Listener listener = new Listener();
    private final Rete rete = new Rete(Trace.createStdOutTrace().enableAll(), this.syms);
    private final Map<String, Production> productions = new HashMap<String, Production>();
    private RhsFunctionContext rhsFuncContext = new RhsFunctionContext(){

        @Override
        public SymbolFactory getSymbols() {
            return SimpleMatcher.this.syms;
        }

        @Override
        public Void addWme(Identifier id, Symbol attr, Symbol value) {
            throw new UnsupportedOperationException("This test implementation of RhsFunctionContext doesn't support addWme");
        }

        @Override
        public Production getProductionBeingFired() {
            return null;
        }
    };

    public SimpleMatcher() {
        this.rete.setReteListener(this.listener);
    }

    public Production addProduction(String s) throws ParserException {
        OriginalParser parser = new OriginalParser();
        ParserContext context = new ParserContext(){

            @Override
            public Object getAdapter(Class<?> klass) {
                if (klass.equals(SymbolFactoryImpl.class)) {
                    return SimpleMatcher.this.syms;
                }
                if (klass.equals(RhsFunctionManager.class)) {
                    return new RhsFunctionManager(SimpleMatcher.this.rhsFuncContext);
                }
                if (klass.equals(Printer.class)) {
                    return Printer.createStdOutPrinter();
                }
                return null;
            }
        };
        StringReader reader = new StringReader(s);
        Production p = parser.parseProduction(context, reader);
        ProductionAddResult result = this.rete.add_production_to_rete(p);
        if (result == ProductionAddResult.DUPLICATE_PRODUCTION) {
            throw new IllegalArgumentException("duplicate production " + p.getName());
        }
        this.productions.put(p.getName(), p);
        return p;
    }

    public void removeProduction(Production p) {
        this.rete.excise_production_from_rete(p);
        this.productions.remove(p.getName());
    }

    public void removeProduction(String productionName) throws IllegalArgumentException {
        Production p = this.productions.get(productionName);
        if (p == null) {
            throw new IllegalArgumentException("production " + productionName + " doesn't exist");
        }
        this.removeProduction(p);
    }

    public void removeAllProductions() {
        for (Production p : this.productions.values()) {
            this.removeProduction(p);
        }
    }

    public void addWme(Wme w) {
        IdentifierImpl id = this.copySymbol(this.syms, w.getIdentifier()).asIdentifier();
        SymbolImpl attr = this.copySymbol(this.syms, w.getAttribute());
        SymbolImpl value = this.copySymbol(this.syms, w.getValue());
        WmeImpl wme = new WmeImpl(id, attr, value, false, 0);
        this.rete.add_wme_to_rete(wme);
    }

    public void removeWme(Wme w) throws IllegalArgumentException {
        for (WmeImpl matcherWme : this.rete.getAllWmes()) {
            if (!Wmes.equalByValue(w, matcherWme)) continue;
            this.rete.remove_wme_from_rete(matcherWme);
            return;
        }
        throw new IllegalArgumentException("wme " + w.toString() + " not in rete");
    }

    public void removeAllWmes() {
        HashSet<WmeImpl> wmes = new HashSet<WmeImpl>(this.rete.getAllWmes());
        for (WmeImpl w : wmes) {
            this.rete.remove_wme_from_rete(w);
        }
    }

    public int getNumberMatches(Production p) {
        Integer numMatches = this.listener.matching.get(p);
        if (numMatches != null) {
            return numMatches;
        }
        return 0;
    }

    public int getNumberMatches(String productionName) throws IllegalArgumentException {
        Production p = this.productions.get(productionName);
        if (p == null) {
            throw new IllegalArgumentException("production " + productionName + " doesn't exist");
        }
        return this.getNumberMatches(p);
    }

    public PartialMatches getMatches(Production p) {
        return this.rete.getPartialMatches(p.getReteNode());
    }

    public PartialMatches getMatches(String productionName) throws IllegalArgumentException {
        Production p = this.productions.get(productionName);
        if (p == null) {
            throw new IllegalArgumentException("production " + productionName + " doesn't exist");
        }
        return this.getMatches(p);
    }

    private SymbolImpl copySymbol(SymbolFactoryImpl syms, Symbol origSym) {
        Identifier sId = origSym.asIdentifier();
        SymbolImpl copySym = sId != null ? syms.findOrCreateIdentifierExact(sId.getNameLetter(), sId.getNameNumber()) : (SymbolImpl)syms.importSymbol(origSym);
        return copySym;
    }

    private class Listener
    implements ReteListener {
        Map<Production, Integer> matching = new HashMap<Production, Integer>();

        private Listener() {
        }

        @Override
        public boolean finishRefraction(Rete rete, Production p, Instantiation refracted_inst, ReteNode p_node) {
            return false;
        }

        @Override
        public void p_node_left_addition(Rete rete, ReteNode node, Token tok, WmeImpl w) {
            Integer i;
            Production p = node.b_p().prod;
            if (this.matching.containsKey(p)) {
                i = this.matching.get(p);
                i = i + 1;
            } else {
                i = 1;
            }
            this.matching.put(p, i);
        }

        @Override
        public void p_node_left_removal(Rete rete, ReteNode node, Token tok, WmeImpl w) {
            Production p = node.b_p().prod;
            Integer i = this.matching.get(p);
            if ((i = Integer.valueOf(i - 1)) > 0) {
                this.matching.put(p, i);
            } else {
                this.matching.remove(p);
            }
        }

        @Override
        public void startRefraction(Rete rete, Production p, Instantiation refracted_inst, ReteNode p_node) {
        }

        @Override
        public void removingProductionNode(Rete rete, ReteNode p_node) {
        }
    }
}

