/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Decider;
import org.jsoar.kernel.DecisionCycle;
import org.jsoar.kernel.MatchSet;
import org.jsoar.kernel.MatchSetEntry;
import org.jsoar.kernel.PredefinedSymbols;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.ProductionType;
import org.jsoar.kernel.SavedFiringType;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.memory.Instantiation;
import org.jsoar.kernel.memory.PreferenceType;
import org.jsoar.kernel.memory.RecognitionMemory;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.rete.DefaultMatchSetEntry;
import org.jsoar.kernel.rete.MatchSetChange;
import org.jsoar.kernel.rete.ProductionNodeData;
import org.jsoar.kernel.rete.Rete;
import org.jsoar.kernel.rete.ReteListener;
import org.jsoar.kernel.rete.ReteNode;
import org.jsoar.kernel.rete.ReteNodeType;
import org.jsoar.kernel.rete.SoarReteAssertion;
import org.jsoar.kernel.rete.Token;
import org.jsoar.kernel.rhs.Action;
import org.jsoar.kernel.rhs.MakeAction;
import org.jsoar.kernel.rhs.ReteLocation;
import org.jsoar.kernel.rhs.RhsSymbolValue;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.kernel.wma.WorkingMemoryActivation;
import org.jsoar.util.ListHead;
import org.jsoar.util.adaptables.Adaptables;

public class SoarReteListener
implements ReteListener {
    private final Agent context;
    private final Rete rete;
    private PredefinedSymbols predefinedSyms;
    private Decider decider;
    private RecognitionMemory recMemory;
    private WorkingMemoryActivation wma;
    public ListHead<MatchSetChange> nil_goal_retractions = ListHead.newInstance();
    MatchSetChange ms_assertions;
    public MatchSetChange ms_retractions;
    public MatchSetChange ms_o_assertions;
    public MatchSetChange ms_i_assertions;
    public final ListHead<MatchSetChange> postponed_assertions = ListHead.newInstance();

    public SoarReteListener(Agent context, Rete rete) {
        this.context = context;
        this.rete = rete;
        this.rete.setReteListener(this);
    }

    public void initialize() {
        this.predefinedSyms = Adaptables.adapt(this.context, PredefinedSymbols.class);
        this.decider = Adaptables.adapt(this.context, Decider.class);
        this.recMemory = Adaptables.adapt(this.context, RecognitionMemory.class);
        this.wma = Adaptables.adapt(this.context, WorkingMemoryActivation.class);
    }

    @Override
    public boolean finishRefraction(Rete rete, Production p, Instantiation refracted_inst, ReteNode p_node) {
        boolean refactedInstMatched;
        p.instantiations = refracted_inst.removeFromProdList(p.instantiations);
        boolean bl = refactedInstMatched = p_node.b_p().tentative_retractions == null;
        if (!refactedInstMatched) {
            MatchSetChange msc = p_node.b_p().tentative_retractions;
            p_node.b_p().tentative_retractions = null;
            this.ms_retractions = msc.removeFromAllList(this.ms_retractions);
            if (msc.goal != null) {
                msc.in_level.remove(msc.goal.goalInfo.ms_retractions);
            } else {
                msc.in_level.remove(this.nil_goal_retractions);
            }
        }
        return refactedInstMatched;
    }

    @Override
    public void p_node_left_addition(Rete rete, ReteNode node, Token tok, WmeImpl w) {
        DecisionCycle dc;
        SavedFiringType prod_type;
        MatchSetChange msc;
        block26: {
            block27: {
                block25: {
                    boolean match_found = false;
                    msc = null;
                    msc = node.b_p().tentative_retractions;
                    while (msc != null) {
                        match_found = true;
                        Condition cond = msc.inst.bottom_of_instantiated_conditions;
                        Token current_token = tok;
                        WmeImpl current_wme = w;
                        ReteNode current_node = node.parent;
                        while (current_node.node_type != ReteNodeType.DUMMY_TOP_BNODE) {
                            if (current_node.node_type.bnode_is_positive() && current_wme != cond.asPositiveCondition().bt().wme_) {
                                match_found = false;
                                break;
                            }
                            current_node = current_node.real_parent_node();
                            current_wme = current_token.w;
                            current_token = current_token.parent;
                            cond = cond.prev;
                        }
                        if (match_found) break;
                        msc = msc.next_of_node;
                    }
                    if (match_found && node.b_p().prod.getType() == ProductionType.JUSTIFICATION) {
                        if (node.b_p().justificationAlreadyFired) {
                            return;
                        }
                        node.b_p().justificationAlreadyFired = true;
                    }
                    if (match_found) {
                        msc.inst.rete_token = tok;
                        msc.inst.rete_wme = w;
                        node.b_p().tentative_retractions = msc.removeFromNodeList(node.b_p().tentative_retractions);
                        this.ms_retractions = msc.removeFromAllList(this.ms_retractions);
                        if (msc.goal != null) {
                            msc.in_level.remove(msc.goal.goalInfo.ms_retractions);
                        } else {
                            msc.in_level.remove(this.nil_goal_retractions);
                        }
                        return;
                    }
                    msc = MatchSetChange.createAssertion(node, tok, w);
                    msc.goal = msc.find_goal_for_match_set_change_assertion(rete.dummy_top_token);
                    msc.level = msc.goal.level;
                    prod_type = SavedFiringType.IE_PRODS;
                    if (node.b_p().prod.getDeclaredSupport() != Production.Support.DECLARED_O_SUPPORT) break block25;
                    prod_type = SavedFiringType.PE_PRODS;
                    break block26;
                }
                if (node.b_p().prod.getDeclaredSupport() != Production.Support.DECLARED_I_SUPPORT) break block27;
                prod_type = SavedFiringType.IE_PRODS;
                break block26;
            }
            if (node.b_p().prod.getDeclaredSupport() != Production.Support.UNDECLARED) break block26;
            boolean operator_proposal = false;
            Action act = node.b_p().prod.getFirstAction();
            while (act != null) {
                RhsSymbolValue attr;
                MakeAction ma = act.asMakeAction();
                RhsSymbolValue rhsSymbolValue = attr = ma != null ? ma.attr.asSymbolValue() : null;
                if (attr != null && this.predefinedSyms.operator_symbol == attr.getSym() && act.preference_type == PreferenceType.ACCEPTABLE) {
                    operator_proposal = true;
                    prod_type = SavedFiringType.IE_PRODS;
                    break;
                }
                act = act.next;
            }
            if (operator_proposal) break block26;
            Token it = node.a_np().tokens;
            while (it != null) {
                Token OPERAND_curr_tok = it;
                boolean op_elab = false;
                WmeImpl lowest_goal_wme = null;
                for (int pass = 0; pass != 2; ++pass) {
                    Token temp_tok = OPERAND_curr_tok;
                    while (temp_tok != null) {
                        block29: {
                            block28: {
                                block30: {
                                    while (temp_tok.w == null && (temp_tok = temp_tok.parent) != null) {
                                    }
                                    if (temp_tok == null || temp_tok.w == null) break;
                                    if (pass != 0) break block28;
                                    if (!temp_tok.w.id.isGoal()) break block29;
                                    if (lowest_goal_wme != null) break block30;
                                    lowest_goal_wme = temp_tok.w;
                                    break block29;
                                }
                                if (temp_tok.w.id.level <= lowest_goal_wme.id.level) break block29;
                                lowest_goal_wme = temp_tok.w;
                                break block29;
                            }
                            if (temp_tok.w.attr == this.predefinedSyms.operator_symbol && !temp_tok.w.acceptable && temp_tok.w.id == lowest_goal_wme.id) {
                                Action act2 = node.b_p().prod.getFirstAction();
                                while (act2 != null) {
                                    MakeAction ma = act2.asMakeAction();
                                    if (ma != null) {
                                        RhsSymbolValue rhsSym = ma.id.asSymbolValue();
                                        ReteLocation rl = ma.id.asReteLocation();
                                        if (rhsSym != null && rhsSym.sym == temp_tok.w.value) {
                                            op_elab = true;
                                        } else if (rl != null && temp_tok.w.value == rl.lookupSymbol(tok, w)) {
                                            op_elab = true;
                                        } else {
                                            prod_type = SavedFiringType.PE_PRODS;
                                        }
                                    }
                                    act2 = act2.next;
                                }
                            }
                        }
                        temp_tok = temp_tok.parent;
                    }
                    if (prod_type != SavedFiringType.PE_PRODS || !op_elab) continue;
                    if (this.context.getPrinter().isPrintWarnings()) {
                        this.context.getPrinter().warn("\nWARNING: operator elaborations mixed with operator applications\nget i_support in prod %s", node.b_p().prod.getName());
                    }
                    prod_type = SavedFiringType.IE_PRODS;
                    break;
                }
                it = it.next_of_node;
            }
        }
        Trace trace = this.context.getTrace();
        if (prod_type == SavedFiringType.PE_PRODS) {
            this.ms_o_assertions = msc.addToHeadOfAllList(this.ms_o_assertions);
            msc.in_level.insertAtHead(msc.goal.goalInfo.ms_o_assertions);
            node.b_p().OPERAND_which_assert_list = ProductionNodeData.AssertListType.O_LIST;
            trace.print(Trace.Category.VERBOSE, "\n   RETE: putting [%s] into ms_o_assertions", node.b_p().prod.getName());
        } else {
            this.ms_i_assertions = msc.addToHeadOfAllList(this.ms_i_assertions);
            msc.in_level.insertAtHead(msc.goal.goalInfo.ms_i_assertions);
            node.b_p().OPERAND_which_assert_list = ProductionNodeData.AssertListType.I_LIST;
            trace.print(Trace.Category.VERBOSE, "\n   RETE: putting [%s] into ms_i_assertions", node.b_p().prod.getName());
        }
        if (node.b_p().prod.isBreakpointEnabled() && (dc = Adaptables.adapt(this.context, DecisionCycle.class)) != null) {
            dc.interrupt(node.b_p().prod.getName());
        }
        node.b_p().tentative_assertions = msc.addToHeadOfNodeList(node.b_p().tentative_assertions);
    }

    @Override
    public void p_node_left_removal(Rete rete, ReteNode node, Token tok, WmeImpl w) {
        MatchSetChange msc = node.b_p().tentative_assertions;
        while (msc != null) {
            if (msc.tok == tok && msc.w == w) {
                node.b_p().tentative_assertions = msc.removeFromNodeList(node.b_p().tentative_assertions);
                if (node.b_p().OPERAND_which_assert_list == ProductionNodeData.AssertListType.O_LIST) {
                    this.ms_o_assertions = msc.removeFromAllList(this.ms_o_assertions);
                    msc.in_level.remove(msc.goal.goalInfo.ms_o_assertions);
                } else if (node.b_p().OPERAND_which_assert_list == ProductionNodeData.AssertListType.I_LIST) {
                    this.ms_i_assertions = msc.removeFromAllList(this.ms_i_assertions);
                    msc.in_level.remove(msc.goal.goalInfo.ms_i_assertions);
                }
                return;
            }
            msc = msc.next_of_node;
        }
        Instantiation inst = null;
        Instantiation instTemp = node.b_p().prod.instantiations;
        while (instTemp != null) {
            inst = instTemp;
            if (inst.rete_token == tok && inst.rete_wme == w) break;
            instTemp = instTemp.nextInProdList;
        }
        if (inst != null) {
            inst.rete_token = null;
            inst.rete_wme = null;
            MatchSetChange msc2 = MatchSetChange.createRetraction(node, inst);
            node.b_p().tentative_retractions = msc2.addToHeadOfNodeList(node.b_p().tentative_retractions);
            msc2.goal = msc2.find_goal_for_match_set_change_retraction();
            msc2.level = msc2.goal.level;
            if (msc2.goal.link_count == 0) {
                msc2.goal = null;
            }
            this.ms_retractions = msc2.addToHeadOfAllList(this.ms_retractions);
            if (msc2.goal != null) {
                msc2.in_level.insertAtHead(msc2.goal.goalInfo.ms_retractions);
            } else {
                msc2.in_level.insertAtHead(this.nil_goal_retractions);
            }
            return;
        }
        this.context.getTrace().print(Trace.Category.VERBOSE, "\n%s: ", node.b_p().prod.getName());
        if (node.b_p().prod.getType() == ProductionType.JUSTIFICATION) {
            return;
        }
        throw new IllegalStateException("Internal error: can't find existing instantiation to retract");
    }

    @Override
    public void startRefraction(Rete rete, Production p, Instantiation refracted_inst, ReteNode p_node) {
        p.instantiations = refracted_inst.insertAtHeadOfProdList(p.instantiations);
        refracted_inst.rete_token = null;
        refracted_inst.rete_wme = null;
        MatchSetChange msc = MatchSetChange.createRefracted(p_node, refracted_inst);
        msc.level = 0;
        msc.goal = null;
        msc.in_level.insertAtHead(this.nil_goal_retractions);
        msc.p_node.b_p().justificationAlreadyFired = false;
        this.ms_retractions = msc.addToHeadOfAllList(this.ms_retractions);
        p_node.b_p().tentative_retractions = msc.addToHeadOfNodeList(p_node.b_p().tentative_retractions);
    }

    @Override
    public void removingProductionNode(Rete rete, ReteNode p_node) {
        MatchSetChange msc = p_node.b_p().tentative_retractions;
        while (msc != null) {
            msc.p_node = null;
            msc = msc.next_of_node;
        }
    }

    public SoarReteAssertion postpone_assertion() {
        MatchSetChange msc = null;
        if (this.decider.active_goal != null) {
            if (this.recMemory.FIRING_TYPE == SavedFiringType.PE_PRODS) {
                if (this.decider.active_goal.goalInfo.ms_o_assertions.isEmpty()) {
                    return null;
                }
                msc = this.decider.active_goal.goalInfo.ms_o_assertions.pop();
                this.ms_o_assertions = msc.removeFromAllList(this.ms_o_assertions);
            } else {
                if (this.decider.active_goal.goalInfo.ms_i_assertions.isEmpty()) {
                    return null;
                }
                msc = this.decider.active_goal.goalInfo.ms_i_assertions.pop();
                this.ms_i_assertions = msc.removeFromAllList(this.ms_i_assertions);
            }
        } else {
            if (this.ms_i_assertions != null || this.ms_o_assertions != null) {
                // empty if block
            }
            return null;
        }
        msc.p_node.b_p().tentative_assertions = msc.removeFromNodeList(msc.p_node.b_p().tentative_assertions);
        this.postponed_assertions.push(msc);
        return new SoarReteAssertion(msc.p_node.b_p().prod, msc.tok, msc.w);
    }

    public void consume_last_postponed_assertion() {
        MatchSetChange msc = this.postponed_assertions.pop();
        assert (msc != null);
    }

    public void restore_postponed_assertions() {
        while (!this.postponed_assertions.isEmpty()) {
            MatchSetChange msc = this.postponed_assertions.pop();
            assert (msc != null);
            msc.p_node.b_p().tentative_assertions = msc.addToHeadOfNodeList(msc.p_node.b_p().tentative_assertions);
            assert (this.decider.active_goal != null);
            if (this.recMemory.FIRING_TYPE == SavedFiringType.PE_PRODS) {
                this.ms_o_assertions = msc.addToHeadOfAllList(this.ms_o_assertions);
                this.decider.active_goal.goalInfo.ms_o_assertions.push(msc);
                continue;
            }
            this.ms_i_assertions = msc.addToHeadOfAllList(this.ms_i_assertions);
            this.decider.active_goal.goalInfo.ms_i_assertions.push(msc);
        }
    }

    public Instantiation get_next_retraction() {
        if (this.decider.active_level == 0) {
            return null;
        }
        if (this.decider.active_goal.goalInfo.ms_retractions.isEmpty()) {
            return null;
        }
        MatchSetChange msc = this.decider.active_goal.goalInfo.ms_retractions.pop();
        this.ms_retractions = msc.removeFromAllList(this.ms_retractions);
        if (msc.p_node != null) {
            msc.p_node.b_p().tentative_retractions = msc.removeFromNodeList(msc.p_node.b_p().tentative_retractions);
        }
        return msc.inst;
    }

    public boolean hasNilGoalRetractions() {
        return !this.nil_goal_retractions.isEmpty();
    }

    public Instantiation get_next_nil_goal_retraction() {
        if (this.nil_goal_retractions.isEmpty()) {
            return null;
        }
        MatchSetChange msc = this.nil_goal_retractions.pop();
        this.ms_retractions = msc.removeFromAllList(this.ms_retractions);
        if (msc.p_node != null) {
            msc.p_node.b_p().tentative_retractions = msc.removeFromNodeList(msc.p_node.b_p().tentative_retractions);
        }
        return msc.inst;
    }

    public boolean any_assertions_or_retractions_ready() {
        if (!this.nil_goal_retractions.isEmpty()) {
            return true;
        }
        IdentifierImpl goal = this.decider.bottom_goal;
        while (goal != null) {
            if (!(goal.goalInfo.ms_o_assertions.isEmpty() && goal.goalInfo.ms_i_assertions.isEmpty() && goal.goalInfo.ms_retractions.isEmpty())) {
                return true;
            }
            goal = goal.goalInfo.higher_goal;
        }
        return false;
    }

    private void print_whole_token(Printer printer, MatchSetChange msc, Trace.WmeTraceType wtt) {
        this.rete.print_whole_token(printer, msc.tok, wtt);
        Rete.print_whole_token_wme(printer, msc.w, wtt);
    }

    private void printAssertions(MatchSetChange assertions, Printer printer, Trace.WmeTraceType wtt) {
        MS_trace ms_trace = null;
        MatchSetChange msc = assertions;
        while (msc != null) {
            if (wtt != Trace.WmeTraceType.NONE) {
                printer.print("  %s [%s] ", msc.getProduction().getName(), msc.goal);
                this.print_whole_token(printer, msc, wtt);
                printer.print("\n");
            } else {
                ms_trace = MS_trace.incrementOrCreate(ms_trace, this.context.getSymbols().createString(msc.getProduction().getName()), msc.goal);
            }
            msc = msc.next_of_all;
        }
        if (wtt == Trace.WmeTraceType.NONE) {
            while (ms_trace != null) {
                MS_trace tmp = ms_trace;
                ms_trace = tmp.next;
                printer.print("  %s [%s] ", tmp.sym, tmp.goal);
                if (tmp.count > 1) {
                    printer.print("(%d)", tmp.count);
                }
                printer.print("\n");
            }
        }
    }

    private void printRetractions(Printer printer, Trace.WmeTraceType wtt) {
        MS_trace ms_trace = null;
        MatchSetChange msc = this.ms_retractions;
        while (msc != null) {
            if (wtt != Trace.WmeTraceType.NONE) {
                printer.print("  ");
                msc.inst.trace(printer.asFormatter(), wtt);
                printer.print("\n");
            } else if (msc.inst.prod != null) {
                ms_trace = MS_trace.incrementOrCreate(ms_trace, this.context.getSymbols().createString(msc.getProduction().getName()), msc.goal);
            }
            msc = msc.next_of_all;
        }
        if (wtt == Trace.WmeTraceType.NONE) {
            while (ms_trace != null) {
                MS_trace tmp = ms_trace;
                ms_trace = tmp.next;
                printer.print("  %s ", tmp.sym);
                if (tmp.goal != null) {
                    printer.print(" [%s] ", tmp.goal);
                } else {
                    printer.print(" [NIL] ");
                }
                if (tmp.count > 1) {
                    printer.print("(%d)", tmp.count);
                }
                printer.print("\n");
            }
        }
    }

    public void print_match_set(Printer printer, Trace.WmeTraceType wtt, EnumSet<Trace.MatchSetTraceType> mst) {
        if (mst.contains((Object)Trace.MatchSetTraceType.MS_ASSERT)) {
            printer.print("O Assertions:\n");
            this.printAssertions(this.ms_o_assertions, printer, wtt);
        }
        if (mst.contains((Object)Trace.MatchSetTraceType.MS_ASSERT)) {
            printer.print("I Assertions:\n");
            this.printAssertions(this.ms_i_assertions, printer, wtt);
        }
        if (mst.contains((Object)Trace.MatchSetTraceType.MS_RETRACT)) {
            printer.print("Retractions:\n");
            this.printRetractions(printer, wtt);
        }
    }

    private MatchSetEntry getAssertion(MatchSetChange msc, MatchSetEntry.EntryType type) {
        LinkedList<Wme> wmes = new LinkedList<Wme>();
        Token tok = msc.tok;
        while (tok != this.rete.dummy_top_token) {
            if (tok.w != null) {
                wmes.addFirst(tok.w);
            }
            tok = tok.parent;
        }
        if (msc.w != null) {
            wmes.add(msc.w);
        }
        return new DefaultMatchSetEntry(msc.getProduction(), type, wmes);
    }

    private List<MatchSetEntry> getAssertions(MatchSetChange assertions, MatchSetEntry.EntryType type) {
        ArrayList<MatchSetEntry> entries = new ArrayList<MatchSetEntry>();
        MatchSetChange msc = assertions;
        while (msc != null) {
            entries.add(this.getAssertion(msc, type));
            msc = msc.next_of_all;
        }
        return entries;
    }

    private MatchSetEntry getRetraction(MatchSetChange msc) {
        return new DefaultMatchSetEntry(msc.getProduction(), MatchSetEntry.EntryType.RETRACTION, msc.inst.getBacktraceWmes());
    }

    private List<MatchSetEntry> getRetractions() {
        ArrayList<MatchSetEntry> entries = new ArrayList<MatchSetEntry>();
        MatchSetChange msc = this.ms_retractions;
        while (msc != null) {
            entries.add(this.getRetraction(msc));
            msc = msc.next_of_all;
        }
        return entries;
    }

    public MatchSet getMatchSet() {
        final ArrayList<MatchSetEntry> entries = new ArrayList<MatchSetEntry>();
        entries.addAll(this.getAssertions(this.ms_i_assertions, MatchSetEntry.EntryType.I_ASSERTION));
        entries.addAll(this.getAssertions(this.ms_o_assertions, MatchSetEntry.EntryType.O_ASSERTION));
        entries.addAll(this.getRetractions());
        return new MatchSet(){

            @Override
            public List<MatchSetEntry> getEntries() {
                return Collections.unmodifiableList(entries);
            }
        };
    }

    public void wma_activate_wmes_tested_in_prods() {
        Token t;
        MatchSetChange msc = this.ms_o_assertions;
        while (msc != null) {
            t = Token.createMatchesToken(msc.tok, msc.w);
            while (t != this.rete.dummy_top_token) {
                if (t.w != null) {
                    this.wma.wma_activate_wme(t.w);
                }
                t = t.parent;
            }
            msc = msc.next_of_all;
        }
        msc = this.ms_i_assertions;
        while (msc != null) {
            t = Token.createMatchesToken(msc.tok, msc.w);
            while (t != this.rete.dummy_top_token) {
                if (t.w != null) {
                    this.wma.wma_activate_wme(t.w);
                }
                t = t.parent;
            }
            msc = msc.next_of_all;
        }
    }

    private static class MS_trace {
        final Symbol sym;
        final Symbol goal;
        int count;
        MS_trace next;

        public MS_trace(Symbol sym, Symbol goal, MS_trace next) {
            this.sym = sym;
            this.count = 1;
            this.goal = goal;
            this.next = next;
        }

        public static MS_trace incrementOrCreate(MS_trace start, Symbol sym, Symbol goal) {
            MS_trace tmp = start;
            while (tmp != null) {
                if (tmp.sym == sym && goal == tmp.goal) {
                    ++tmp.count;
                    return start;
                }
                tmp = tmp.next;
            }
            return new MS_trace(sym, goal, start);
        }
    }
}

