/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs;

import java.util.Formatter;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.rete.Token;
import org.jsoar.kernel.rhs.AbstractRhsValue;
import org.jsoar.kernel.rhs.RhsValue;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.util.ListHead;
import org.jsoar.util.markers.Marker;

public class ReteLocation
extends AbstractRhsValue {
    private final int fieldNum;
    private final int levelsUp;
    private static final int NUM_FIELDS = 3;
    private static final int NUM_LEVELS = 64;
    private static final ReteLocation[][] COMMON = new ReteLocation[3][64];

    public static ReteLocation create(int fieldNum, int levelsUp) {
        if (fieldNum < 3 && levelsUp < 64) {
            return COMMON[fieldNum][levelsUp];
        }
        return new ReteLocation(fieldNum, levelsUp);
    }

    private ReteLocation(int fieldNum, int levelsUp) {
        this.fieldNum = fieldNum;
        this.levelsUp = levelsUp;
    }

    public int getFieldNum() {
        return this.fieldNum;
    }

    public int getLevelsUp() {
        return this.levelsUp;
    }

    public SymbolImpl lookupSymbol(Token tok, WmeImpl w) {
        for (int levels_up = this.levelsUp; levels_up != 0; --levels_up) {
            w = tok.w;
            tok = tok.parent;
        }
        if (this.fieldNum == 0) {
            return w.id;
        }
        if (this.fieldNum == 1) {
            return w.attr;
        }
        return w.value;
    }

    @Override
    public RhsValue copy() {
        return this;
    }

    @Override
    public ReteLocation asReteLocation() {
        return this;
    }

    @Override
    public void addAllVariables(Marker tc_number, ListHead<Variable> var_list) {
        throw new UnsupportedOperationException("addAllVariables not supported on ReteLocation RhsValue");
    }

    public String toString() {
        return "(rete-location " + this.levelsUp + ":" + this.fieldNum + ")";
    }

    @Override
    public void formatTo(Formatter formatter, int arg1, int arg2, int arg3) {
        throw new IllegalStateException("Internal error: rhs_value_to_string called on reteloc.");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fieldNum;
        result = 31 * result + this.levelsUp;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReteLocation)) {
            return false;
        }
        ReteLocation other = (ReteLocation)obj;
        if (this.fieldNum != other.fieldNum) {
            return false;
        }
        return this.levelsUp == other.levelsUp;
    }

    static {
        for (int i = 0; i < COMMON.length; ++i) {
            for (int j = 0; j < COMMON[i].length; ++j) {
                ReteLocation.COMMON[i][j] = new ReteLocation(i, j);
            }
        }
    }
}

