/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.jsoar.kernel.rhs.AbstractRhsValue;
import org.jsoar.kernel.rhs.RhsValue;
import org.jsoar.kernel.symbols.StringSymbol;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.util.ListHead;
import org.jsoar.util.markers.Marker;

public class RhsFunctionCall
extends AbstractRhsValue {
    private final StringSymbol name;
    private final boolean standalone;
    private final List<RhsValue> arguments = new ArrayList<RhsValue>();

    public RhsFunctionCall(StringSymbol name, boolean standalone) {
        this.name = name;
        this.standalone = standalone;
    }

    private RhsFunctionCall(RhsFunctionCall other) {
        this.name = other.name;
        this.standalone = other.standalone;
        for (RhsValue arg : other.arguments) {
            this.arguments.add(arg.copy());
        }
    }

    public StringSymbol getName() {
        return this.name;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public void addArgument(RhsValue arg) {
        this.arguments.add(arg);
    }

    public List<RhsValue> getArguments() {
        return this.arguments;
    }

    @Override
    public RhsFunctionCall asFunctionCall() {
        return this;
    }

    @Override
    public RhsValue copy() {
        return new RhsFunctionCall(this);
    }

    @Override
    public void addAllVariables(Marker tc_number, ListHead<Variable> var_list) {
        for (RhsValue arg : this.arguments) {
            arg.addAllVariables(tc_number, var_list);
        }
    }

    public String toString() {
        return "(" + this.name + " " + this.arguments + ")";
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        StringSymbol name = this.getName();
        String nameString = name.getValue();
        if ("+".equals(nameString) || "-".equals(nameString) || "/".equals(nameString)) {
            formatter.format("(%s", nameString);
        } else {
            formatter.format("(%s", name);
        }
        for (RhsValue v : this.arguments) {
            formatter.format(" %s", v);
        }
        formatter.format(")", new Object[0]);
    }
}

