/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.Symbol;

public class AcceptRhsFunction
extends AbstractRhsFunctionHandler {
    public AcceptRhsFunction() {
        super("accept", 0, 1);
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        RhsFunctions.checkArgumentCount(this, arguments);
        String message = arguments.isEmpty() ? "Input requested by agent:" : arguments.get(0).toString();
        try {
            String result = this.askUserForInput(context, message);
            return context.getSymbols().createString(result != null ? result : "");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RhsFunctionException("Interrupted waiting for user input");
        }
        catch (InvocationTargetException e) {
            throw new RhsFunctionException("Errot while waiting for user input: " + e.getMessage(), e);
        }
    }

    private String askUserForInput(final RhsFunctionContext context, final String message) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            return this.askUserForInputFromEventThread(context, message);
        }
        final AtomicReference result = new AtomicReference();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                result.set(AcceptRhsFunction.this.askUserForInputFromEventThread(context, message));
            }
        });
        return (String)result.get();
    }

    private String askUserForInputFromEventThread(RhsFunctionContext context, String message) {
        return JOptionPane.showInputDialog(null, message, "JSoar - firing rule '" + context.getProductionBeingFired().getName() + "'", 3);
    }
}

