/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.util.SourceLocation;
import org.jsoar.util.commands.DefaultSoarCommandContext;
import org.jsoar.util.commands.ParsedCommand;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandInterpreter;

public class CmdRhsFunction
extends AbstractRhsFunctionHandler {
    private final SoarCommandInterpreter interp;
    private final Agent agent;

    public CmdRhsFunction(SoarCommandInterpreter interp, Agent agent) {
        super("cmd", 1, Integer.MAX_VALUE);
        this.interp = interp;
        this.agent = agent;
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        RhsFunctions.checkArgumentCount(this, arguments);
        try {
            String commandName = arguments.get(0).toString();
            List<String> commandArgs = this.mapSymbolListToStringList(arguments);
            SourceLocation srcLoc = context.getProductionBeingFired().getLocation();
            ParsedCommand parsedCommand = this.interp.getParsedCommand(commandName, srcLoc);
            SoarCommand command = this.interp.getCommand(parsedCommand.getArgs().get(0), srcLoc);
            List<String> fullCommandArgs = parsedCommand.getArgs();
            fullCommandArgs.addAll(commandArgs.subList(1, commandArgs.size()));
            DefaultSoarCommandContext commandContext = new DefaultSoarCommandContext(srcLoc);
            Printer printer = this.agent.getPrinter();
            StringWriter stringWriter = new StringWriter();
            printer.pushWriter(stringWriter);
            String result = command.execute(commandContext, fullCommandArgs.toArray(new String[fullCommandArgs.size()]));
            printer.popWriter();
            result = stringWriter.toString() + result;
            return context.getSymbols().createString(result);
        }
        catch (SoarException e) {
            throw new RhsFunctionException(e.getMessage(), e);
        }
    }

    private List<String> mapSymbolListToStringList(List<Symbol> symList) {
        ArrayList<String> stringList = new ArrayList<String>(symList.size());
        for (Symbol s : symList) {
            stringList.add(String.format("%#s", s));
        }
        return stringList;
    }

    @Override
    public boolean mayBeStandalone() {
        return true;
    }
}

