/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.List;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;

public final class FloatingPointDivide
extends AbstractRhsFunctionHandler {
    public FloatingPointDivide() {
        super("/", 1, Integer.MAX_VALUE);
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        RhsFunctions.checkAllArgumentsAreNumeric(this.getName(), arguments);
        RhsFunctions.checkArgumentCount(this, arguments);
        SymbolFactory syms = context.getSymbols();
        Symbol arg = arguments.get(0);
        if (arguments.size() == 1) {
            double f;
            IntegerSymbol i = arg.asInteger();
            double d = f = i != null ? (double)i.getValue() : arg.asDouble().getValue();
            if (f == 0.0) {
                throw new RhsFunctionException("Attempt to divide ('/') by zero");
            }
            return syms.createDouble(1.0 / f);
        }
        double f = RhsFunctions.asDouble(arg);
        for (int index = 1; index < arguments.size(); ++index) {
            arg = arguments.get(index);
            double nextf = RhsFunctions.asDouble(arg);
            if (nextf == 0.0) {
                throw new RhsFunctionException("Attempt to divide ('/') by zero");
            }
            f /= nextf;
        }
        return syms.createDouble(f);
    }
}

