/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.StringSymbol;
import org.jsoar.kernel.symbols.Symbol;

public class GetUrl
extends AbstractRhsFunctionHandler {
    public GetUrl() {
        super("get-url", 1, 1);
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        BufferedInputStream is;
        URL url;
        RhsFunctions.checkArgumentCount(this, arguments);
        String urlString = arguments.get(0).toString();
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RhsFunctionException("In '" + this.getName() + "' RHS function: " + e.getMessage());
        }
        try {
            is = new BufferedInputStream(url.openStream());
        }
        catch (IOException e) {
            throw new RhsFunctionException("In '" + this.getName() + "' RHS function: " + e.getMessage());
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteStreams.copy((InputStream)is, (OutputStream)out);
            StringSymbol stringSymbol = context.getSymbols().createString(out.toString("UTF-8"));
            return stringSymbol;
        }
        catch (IOException e) {
            throw new RhsFunctionException("In '" + this.getName() + "' RHS function: " + e.getMessage());
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                throw new RhsFunctionException("In '" + this.getName() + "' RHS function: " + e.getMessage());
            }
        }
    }
}

