/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.DoubleSymbol;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.Symbol;

public class IntRhsFunction
extends AbstractRhsFunctionHandler {
    private static final Pattern number = Pattern.compile("^(-?\\d+).*?");

    public IntRhsFunction() {
        super("int", 1, 1);
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        RhsFunctions.checkArgumentCount(this, arguments);
        Symbol arg = arguments.get(0);
        IntegerSymbol intSym = arg.asInteger();
        if (intSym != null) {
            return intSym;
        }
        DoubleSymbol doubleSym = arg.asDouble();
        if (doubleSym != null) {
            return context.getSymbols().createInteger((long)doubleSym.getValue());
        }
        if (arg.asIdentifier() != null) {
            throw new RhsFunctionException("Identifier passed to int RHS function: " + arg);
        }
        String string = arg.toString();
        try {
            return context.getSymbols().createInteger(this.parseString(string));
        }
        catch (NumberFormatException e) {
            throw new RhsFunctionException(arg + " is not a valid number.");
        }
    }

    private long parseString(String s) {
        try {
            Long lng = Long.parseLong(s);
            return lng;
        }
        catch (NumberFormatException e) {
            Matcher matcher = number.matcher(s);
            Long lng = matcher.find() && matcher.groupCount() > 0 ? Long.valueOf(Long.parseLong(matcher.group(1))) : Long.valueOf(Long.parseLong(s));
            return lng;
        }
    }
}

