/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.Arrays;
import java.util.List;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.CumulativeNormalDistribution;
import org.jsoar.kernel.rhs.functions.Div;
import org.jsoar.kernel.rhs.functions.FloatingPointDivide;
import org.jsoar.kernel.rhs.functions.Max;
import org.jsoar.kernel.rhs.functions.Min;
import org.jsoar.kernel.rhs.functions.Minus;
import org.jsoar.kernel.rhs.functions.Mod;
import org.jsoar.kernel.rhs.functions.Multiply;
import org.jsoar.kernel.rhs.functions.Plus;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.DoubleSymbol;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.Symbol;

public class MathFunctions {
    public static final RhsFunctionHandler pi = new Constant("pi", Math.PI);
    public static final RhsFunctionHandler e = new Constant("e", Math.E);
    public static final RhsFunctionHandler abs = new AbstractRhsFunctionHandler("abs", 1, 1){

        @Override
        public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
            RhsFunctions.checkArgumentCount(this, arguments);
            IntegerSymbol i = arguments.get(0).asInteger();
            if (i != null) {
                return context.getSymbols().createInteger(Math.abs(i.getValue()));
            }
            DoubleSymbol d = arguments.get(0).asDouble();
            if (d != null) {
                return context.getSymbols().createDouble(Math.abs(d.getValue()));
            }
            throw new RhsFunctionException(this.getName() + " expected numeric argument, got " + arguments.get(0));
        }
    };
    public static final RhsFunctionHandler atan2 = new AbstractRhsFunctionHandler("atan2", 2, 2){

        @Override
        public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
            RhsFunctions.checkArgumentCount(this, arguments);
            RhsFunctions.checkAllArgumentsAreNumeric(this.getName(), arguments);
            Double y = RhsFunctions.asDouble(arguments.get(0));
            Double x = RhsFunctions.asDouble(arguments.get(1));
            return context.getSymbols().createDouble(Math.atan2(y, x));
        }
    };
    public static final RhsFunctionHandler sqrt = new OneArgMathFunction("sqrt"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.sqrt(arg);
        }
    };
    public static final RhsFunctionHandler sin = new OneArgMathFunction("sin"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.sin(arg);
        }
    };
    public static final RhsFunctionHandler cos = new OneArgMathFunction("cos"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.cos(arg);
        }
    };
    public static final RhsFunctionHandler tan = new OneArgMathFunction("tan"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.tan(arg);
        }
    };
    public static final RhsFunctionHandler acos = new OneArgMathFunction("acos"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.acos(arg);
        }
    };
    public static final RhsFunctionHandler asin = new OneArgMathFunction("asin"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.asin(arg);
        }
    };
    public static final RhsFunctionHandler atan = new OneArgMathFunction("atan"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.atan(arg);
        }
    };
    public static final RhsFunctionHandler cbrt = new OneArgMathFunction("cbrt"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.cbrt(arg);
        }
    };
    public static final RhsFunctionHandler ceil = new OneArgMathFunction("ceil"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.ceil(arg);
        }
    };
    public static final RhsFunctionHandler cosh = new OneArgMathFunction("cosh"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.cosh(arg);
        }
    };
    public static final RhsFunctionHandler exp = new OneArgMathFunction("exp"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.exp(arg);
        }
    };
    public static final RhsFunctionHandler expm1 = new OneArgMathFunction("expm1"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.expm1(arg);
        }
    };
    public static final RhsFunctionHandler floor = new OneArgMathFunction("floor"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.floor(arg);
        }
    };
    public static final RhsFunctionHandler log = new OneArgMathFunction("log"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.log(arg);
        }
    };
    public static final RhsFunctionHandler log10 = new OneArgMathFunction("log10"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.log10(arg);
        }
    };
    public static final RhsFunctionHandler log1p = new OneArgMathFunction("log1p"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.log1p(arg);
        }
    };
    public static final RhsFunctionHandler sinh = new OneArgMathFunction("sinh"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.sinh(arg);
        }
    };
    public static final RhsFunctionHandler tanh = new OneArgMathFunction("tanh"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.tanh(arg);
        }
    };
    public static final RhsFunctionHandler signum = new OneArgMathFunction("signum"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.signum(arg);
        }
    };
    public static final RhsFunctionHandler degrees = new OneArgMathFunction("degrees"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.toDegrees(arg);
        }
    };
    public static final RhsFunctionHandler radians = new OneArgMathFunction("radians"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.toRadians(arg);
        }
    };
    public static final RhsFunctionHandler ulp = new OneArgMathFunction("ulp"){

        @Override
        protected double call(double arg) throws RhsFunctionException {
            return Math.ulp(arg);
        }
    };
    public static final List<RhsFunctionHandler> all = Arrays.asList(new Plus(), new Multiply(), new Minus(), new FloatingPointDivide(), new Mod(), new Min(), new Max(), new CumulativeNormalDistribution(), new Div(), pi, e, abs, atan2, cos, sin, tan, sqrt, acos, asin, atan, cbrt, ceil, cosh, exp, expm1, floor, log, log10, log1p, sinh, tanh, degrees, radians, ulp);

    private MathFunctions() {
    }

    private static abstract class OneArgMathFunction
    extends AbstractRhsFunctionHandler {
        public OneArgMathFunction(String name) {
            super(name, 1, 1);
        }

        @Override
        public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
            RhsFunctions.checkArgumentCount(this, arguments);
            RhsFunctions.checkAllArgumentsAreNumeric(this.getName(), arguments);
            Double v = RhsFunctions.asDouble(arguments.get(0));
            return context.getSymbols().createDouble(this.call(v));
        }

        protected abstract double call(double var1) throws RhsFunctionException;
    }

    private static class Constant
    extends AbstractRhsFunctionHandler {
        private final double value;

        public Constant(String name, double value) {
            super(name, 0, 0);
            this.value = value;
        }

        @Override
        public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
            RhsFunctions.checkArgumentCount(this, arguments);
            return context.getSymbols().createDouble(this.value);
        }
    }
}

