/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.List;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.DoubleSymbol;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.Symbol;

public class Max
extends AbstractRhsFunctionHandler {
    public Max() {
        super("max", 1, Integer.MAX_VALUE);
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        RhsFunctions.checkAllArgumentsAreNumeric(this.getName(), arguments);
        long maxInt = Long.MIN_VALUE;
        double maxDouble = Double.MIN_VALUE;
        boolean useDouble = false;
        for (Symbol s : arguments) {
            IntegerSymbol i = s.asInteger();
            if (i != null) {
                if (useDouble) {
                    if (!((double)i.getValue() > maxDouble)) continue;
                    maxInt = i.getValue();
                    useDouble = false;
                    continue;
                }
                maxInt = Math.max(maxInt, i.getValue());
                continue;
            }
            DoubleSymbol d = s.asDouble();
            if (useDouble) {
                maxDouble = Math.max(maxDouble, d.getValue());
                continue;
            }
            if (!(d.getValue() > (double)maxInt)) continue;
            maxDouble = d.getValue();
            useDouble = true;
        }
        return useDouble ? context.getSymbols().createDouble(maxDouble) : context.getSymbols().createInteger(maxInt);
    }
}

