/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.List;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.DoubleSymbol;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.Symbol;

public class Min
extends AbstractRhsFunctionHandler {
    public Min() {
        super("min", 1, Integer.MAX_VALUE);
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        RhsFunctions.checkAllArgumentsAreNumeric(this.getName(), arguments);
        long minInt = Long.MAX_VALUE;
        double minDouble = Double.MAX_VALUE;
        boolean useDouble = false;
        for (Symbol s : arguments) {
            IntegerSymbol i = s.asInteger();
            if (i != null) {
                if (useDouble) {
                    if (!((double)i.getValue() < minDouble)) continue;
                    minInt = i.getValue();
                    useDouble = false;
                    continue;
                }
                minInt = Math.min(minInt, i.getValue());
                continue;
            }
            DoubleSymbol d = s.asDouble();
            if (useDouble) {
                minDouble = Math.min(minDouble, d.getValue());
                continue;
            }
            if (!(d.getValue() < (double)minInt)) continue;
            minDouble = d.getValue();
            useDouble = true;
        }
        return useDouble ? context.getSymbols().createDouble(minDouble) : context.getSymbols().createInteger(minInt);
    }
}

