/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.List;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.Symbol;

public class Mod
extends AbstractRhsFunctionHandler {
    public Mod() {
        super("mod", 2, 2);
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        RhsFunctions.checkArgumentCount(this, arguments);
        IntegerSymbol a = arguments.get(0).asInteger();
        if (a == null) {
            throw new RhsFunctionException(String.format("Non-integer (%d) passed to '%s' function", arguments.get(0), this.getName()));
        }
        IntegerSymbol b = arguments.get(1).asInteger();
        if (b == null) {
            throw new RhsFunctionException(String.format("Non-integer (%d) passed to '%s' function", arguments.get(1), this.getName()));
        }
        if (b.getValue() == 0L) {
            throw new RhsFunctionException("Attempt to divide (mod) by zero");
        }
        return context.getSymbols().createInteger(a.getValue() % b.getValue());
    }
}

