/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.List;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;

public final class Plus
extends AbstractRhsFunctionHandler {
    public Plus() {
        super("+");
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        RhsFunctions.checkAllArgumentsAreNumeric(this.getName(), arguments);
        long i = 0L;
        double f = 0.0;
        boolean float_found = false;
        for (Symbol arg : arguments) {
            IntegerSymbol ic = arg.asInteger();
            if (ic != null) {
                if (float_found) {
                    f += (double)ic.getValue();
                    continue;
                }
                i += ic.getValue();
                continue;
            }
            if (float_found) {
                f += arg.asDouble().getValue();
                continue;
            }
            float_found = true;
            f = (double)i + arg.asDouble().getValue();
        }
        SymbolFactory syms = context.getSymbols();
        return float_found ? syms.createDouble(f) : syms.createInteger(i);
    }
}

