/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.List;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctionHandler;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.Symbol;

public final class RhsFunctions {
    private RhsFunctions() {
    }

    public static void checkArgumentCount(RhsFunctionHandler handler, List<Symbol> arguments) throws RhsFunctionException {
        RhsFunctions.checkArgumentCount(handler.getName(), arguments, handler.getMinArguments(), handler.getMaxArguments());
    }

    public static void checkArgumentCount(String name, List<Symbol> arguments, int min, int max) throws RhsFunctionException {
        int count = arguments.size();
        if (min == max && count != min) {
            throw new RhsFunctionException("'" + name + "' function called with " + count + " arguments. Expected " + min + ".");
        }
        if (count < min) {
            throw new RhsFunctionException("'" + name + "' function called with " + count + " arguments. Expected at least " + min + ".");
        }
        if (count > max) {
            throw new RhsFunctionException("'" + name + "' function called with " + count + " arguments. Expected at most " + max + ".");
        }
    }

    public static void checkAllArgumentsAreNumeric(String name, List<Symbol> arguments) throws RhsFunctionException {
        for (Symbol arg : arguments) {
            if (arg.asInteger() != null || arg.asDouble() != null) continue;
            throw new RhsFunctionException("non-number (" + arg + ") passed to '" + name + "' function");
        }
    }

    static double asDouble(Symbol sym) {
        IntegerSymbol ic = sym.asInteger();
        return ic != null ? (double)ic.getValue() : sym.asDouble().getValue();
    }
}

