/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.List;
import org.jsoar.kernel.io.xml.DefaultWmeToXml;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.util.XmlTools;
import org.w3c.dom.Document;

public class ToXml
extends AbstractRhsFunctionHandler {
    public ToXml() {
        super("to-xml", 1, Integer.MAX_VALUE);
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        int i;
        RhsFunctions.checkArgumentCount(this, arguments);
        String rootName = "xml";
        for (i = 0; i < arguments.size(); ++i) {
            String arg = arguments.get(i).toString();
            if ("--root".equals(arg)) {
                if (i == arguments.size() - 1) {
                    throw new RhsFunctionException("Missing argument for --root option to '" + this.getName() + "'");
                }
            } else {
                if (!arg.startsWith("--")) break;
                throw new RhsFunctionException("Unknown option '" + arg + "' to '" + this.getName() + "'");
            }
            rootName = arguments.get(++i).toString();
        }
        if (i != arguments.size() - 1) {
            throw new RhsFunctionException("Expected single identifier argument to '" + this.getName() + "'");
        }
        Identifier root = arguments.get(i).asIdentifier();
        if (root == null) {
            throw new RhsFunctionException("Argument to '" + this.getName() + "' RHS function must be an identifier.");
        }
        DefaultWmeToXml toXml = new DefaultWmeToXml();
        Document doc = toXml.toXml(root, rootName);
        return context.getSymbols().createString(XmlTools.toString(doc));
    }
}

