/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.smem;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.epmem.EpisodicMemory;
import org.jsoar.kernel.parser.original.LexemeType;
import org.jsoar.kernel.parser.original.Lexer;
import org.jsoar.kernel.smem.DefaultSemanticMemory;
import org.jsoar.kernel.smem.DefaultSemanticMemoryParams;
import org.jsoar.kernel.smem.DefaultSemanticMemoryStats;
import org.jsoar.kernel.smem.SemanticMemoryDatabase;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.util.ByRef;
import org.jsoar.util.JdbcTools;
import org.jsoar.util.PrintHelper;
import org.jsoar.util.adaptables.Adaptable;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import org.jsoar.util.commands.SoarCommandInterpreter;
import org.jsoar.util.commands.SoarCommandProvider;
import org.jsoar.util.properties.PropertyKey;
import org.jsoar.util.properties.PropertyManager;
import picocli.CommandLine;

public class SmemCommand
implements SoarCommand {
    private final Agent agent;
    private final DefaultSemanticMemory smem;
    private Lexer lexer;

    public SmemCommand(Adaptable context) {
        this.agent = (Agent)context;
        this.smem = Adaptables.require(this.getClass(), context, DefaultSemanticMemory.class);
        try {
            this.lexer = new Lexer(new Printer(new PrintWriter(System.out)), new StringReader(""));
        }
        catch (IOException e) {
            System.out.print(e.getMessage());
            e.printStackTrace();
            this.lexer = null;
        }
    }

    @Override
    public Object getCommand() {
        return new SmemC(this.agent, this.smem, this.lexer);
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new SmemC(this.agent, this.smem, this.lexer), args);
        return "";
    }

    @CommandLine.Command(name="smem", description={"Controls the behavior of and displays information about semantic memory"}, subcommands={CommandLine.HelpCommand.class})
    public static class SmemC
    implements Runnable {
        private final Agent agent;
        private final DefaultSemanticMemory smem;
        private Lexer lexer;
        @CommandLine.Spec
        private CommandLine.Model.CommandSpec spec;
        @CommandLine.Option(names={"-a", "--add"}, description={"Adds concepts to semantic memory"})
        String conceptsToAdd = null;
        @CommandLine.Option(names={"-b", "--backup"}, arity="1..*", description={"Creates a backup of the semantic database on disk"})
        String[] backupFileName = null;
        @CommandLine.Option(names={"-c", "--commit"}, description={"Commits data to semantic database"})
        boolean commitData = false;
        @CommandLine.Option(names={"-g", "--get"}, description={"Prints current parameter setting"})
        String getParam = null;
        @CommandLine.Option(names={"-i", "--init"}, description={"Deletes all memories if 'append' is off"})
        boolean initialize = false;
        @CommandLine.Option(names={"-l", "--lastcue"}, description={"Prints the cue from the last decision cycle"})
        boolean getLastCue = false;
        @CommandLine.Option(names={"-p", "--print"}, description={"Prints general or specific contents of semantic memory"})
        boolean printContents = false;
        @CommandLine.Option(names={"-q", "--sql"}, arity="1..*", description={"Runs the SQL statement on the semantic database"})
        String[] sqlStatement = null;
        @CommandLine.Option(names={"-s", "--set"}, description={"Sets parameter value"})
        String setParam = null;
        @CommandLine.Option(names={"-S", "--stats"}, description={"Prints statistic summary or specific statistic"})
        boolean printStats = false;
        @CommandLine.Option(names={"-t", "--timers"}, description={"Prints timer summary or specific timer (not implemented)"})
        boolean printTimers = false;
        @CommandLine.Option(names={"-v", "--viz"}, description={"Prints semantic memory visualization"})
        boolean printVisualization = false;
        @CommandLine.Parameters(index="0", arity="0..1", description={"The contents to print; or the new value of the parameter; or the specific statistic to print"})
        String param = null;
        @CommandLine.Parameters(index="1", arity="0..1", description={"The print depth"})
        Integer printDepth = null;

        public SmemC(Agent agent, DefaultSemanticMemory smem, Lexer lexer) {
            this.agent = agent;
            this.smem = smem;
            this.lexer = lexer;
        }

        @Override
        public void run() {
            if (this.conceptsToAdd != null) {
                this.agent.getPrinter().print(this.doAdd(this.conceptsToAdd));
            } else if (this.backupFileName != null) {
                this.agent.getPrinter().print(this.doBackup(this.backupFileName));
            } else if (this.commitData) {
                this.agent.getPrinter().print(this.doCommit());
            } else if (this.getParam != null) {
                this.agent.getPrinter().print(this.doGet(this.getParam));
            } else if (this.initialize) {
                this.agent.getPrinter().print(this.doInit());
            } else if (this.getLastCue) {
                this.agent.getPrinter().print(this.doLastCue());
            } else if (this.printContents) {
                this.agent.getPrinter().print(this.doPrint(this.param, this.printDepth));
            } else if (this.sqlStatement != null) {
                this.agent.getPrinter().print(this.doSql(this.sqlStatement));
            } else if (this.setParam != null) {
                if (this.param == null) {
                    throw new CommandLine.ParameterException(this.spec.commandLine(), "No parameter value provided");
                }
                this.agent.getPrinter().print(this.doSet(this.setParam, this.param));
            } else if (this.printStats) {
                this.agent.getPrinter().print(this.doStats(this.param));
            } else if (this.printTimers) {
                this.agent.getPrinter().print(this.doTimers(this.param));
            } else if (this.printVisualization) {
                this.agent.getPrinter().print(this.doViz(this.param));
            } else {
                this.agent.getPrinter().print(this.doSmem());
            }
        }

        private String doAdd(String conceptsToAdd) {
            try {
                this.smem.smem_parse_chunks("{" + conceptsToAdd + "}");
            }
            catch (SoarException e) {
                this.agent.getPrinter().startNewLine().print(e.getMessage());
                return "";
            }
            return "SMem| Knowledge added to semantic memory.";
        }

        private String doBackup(String[] backupFileName) {
            ByRef<String> err = new ByRef<String>("");
            boolean success = false;
            String dbFile = "";
            for (String namePiece : backupFileName) {
                dbFile = dbFile + namePiece + " ";
            }
            dbFile = dbFile.trim();
            try {
                success = this.smem.smem_backup_db(dbFile, err);
            }
            catch (SQLException e) {
                throw new CommandLine.ExecutionException(this.spec.commandLine(), e.getMessage(), (Throwable)e);
            }
            if (!success) {
                throw new CommandLine.ExecutionException(this.spec.commandLine(), (String)err.value);
            }
            return "SMem| Database backed up to " + dbFile;
        }

        private String doCommit() {
            if (this.smem.getDatabase() == null) {
                this.agent.getPrinter().startNewLine().print("Semantic memory database is not open.");
                return "";
            }
            if (this.smem.getParams().lazy_commit.get() == DefaultSemanticMemoryParams.LazyCommitChoices.off) {
                return "Semantic memory database is not in lazy-commit mode.";
            }
            try {
                this.smem.commit();
            }
            catch (SoarException e) {
                this.agent.getPrinter().startNewLine().print(e.getMessage());
            }
            return "";
        }

        private String doGet(String getParam) {
            PropertyKey<?> key = DefaultSemanticMemoryParams.getProperty(this.smem.getParams().getProperties(), getParam);
            if (key == null) {
                if (getParam.equals("database")) {
                    PropertyKey<?> pathProperty = DefaultSemanticMemoryParams.getProperty(this.smem.getParams().getProperties(), "path");
                    if (pathProperty == null) {
                        this.agent.getPrinter().startNewLine().print("Path is null.");
                        return "";
                    }
                    String path = this.smem.getParams().getProperties().get(pathProperty).toString();
                    if (path.equals(":memory:")) {
                        return "memory";
                    }
                    return "file";
                }
                throw new CommandLine.ParameterException(this.spec.commandLine(), "Unknown parameter '" + getParam + "'");
            }
            return this.smem.getParams().getProperties().get(key).toString();
        }

        private String doInit() {
            EpisodicMemory epmem = Adaptables.require(this.getClass(), this.agent, EpisodicMemory.class);
            try {
                epmem.epmem_close();
                this.smem.smem_close();
            }
            catch (SoarException e) {
                this.agent.getPrinter().startNewLine().print(e.getMessage());
                return "";
            }
            int count = 0;
            for (Production p : new ArrayList<Production>(this.agent.getProductions().getProductions(null))) {
                this.agent.getProductions().exciseProduction(p, false);
                ++count;
            }
            this.agent.initialize();
            return "Agent reinitialized.\n" + count + " productions excised.\nSMem| Semantic memory system re-initialized.\n";
        }

        private String doLastCue() {
            DefaultSemanticMemory.BasicWeightedCue lastCue = this.smem.getLastCue();
            if (lastCue == null) {
                return "Either the last decision cycle did not contain a query, or the query was bad.";
            }
            return lastCue.cue.toString() + " Weight: " + lastCue.weight;
        }

        private String doPrint(String param, Integer printDepth) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            long lti_id = 0L;
            int depth = 1;
            try {
                this.smem.smem_attach();
            }
            catch (SoarException e) {
                this.agent.getPrinter().startNewLine().print(e.getMessage());
                return "";
            }
            StringBuilder viz = new StringBuilder("");
            try {
                if (param != null) {
                    boolean allowIdsOld = this.lexer.isAllowIds();
                    this.lexer.setAllowIds(true);
                    this.lexer.get_lexeme_from_string(param);
                    if (this.lexer.getCurrentLexeme().type == LexemeType.IDENTIFIER) {
                        char name_letter = this.lexer.getCurrentLexeme().id_letter;
                        long name_number = this.lexer.getCurrentLexeme().id_number;
                        if (this.smem.getDatabase() != null) {
                            lti_id = this.smem.smem_lti_get_id(name_letter, name_number);
                            if (lti_id == 0L) {
                                this.agent.getPrinter().startNewLine().print("'" + this.lexer.getCurrentLexeme() + "' is not an LTI");
                                return "";
                            }
                            if (lti_id != 0L && printDepth != null) {
                                depth = printDepth;
                            }
                        }
                    } else {
                        throw new CommandLine.ParameterException(this.spec.commandLine(), "Expected identifier, got '" + this.lexer.getCurrentLexeme() + "'");
                    }
                    this.smem.smem_print_lti(lti_id, depth, viz);
                    this.lexer.setAllowIds(allowIdsOld);
                } else {
                    this.smem.smem_print_store(viz);
                }
            }
            catch (SoarException e) {
                throw new CommandLine.ExecutionException(this.spec.commandLine(), e.getMessage(), (Throwable)e);
            }
            if (viz.length() == 0) {
                throw new CommandLine.ExecutionException(this.spec.commandLine(), "SMem| Semantic memory is empty.");
            }
            pw.printf(PrintHelper.generateHeader("Semantic Memory", 40), new Object[0]);
            pw.printf(viz.toString(), new Object[0]);
            pw.flush();
            return sw.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String doSql(String[] sqlStatement) {
            String string;
            String sql = Joiner.on((char)' ').join((Object[])Arrays.copyOfRange(sqlStatement, 0, sqlStatement.length)).trim();
            if (this.smem.getDatabase() == null) {
                this.agent.getPrinter().startNewLine().print("Semantic memory database is not open.");
                return "";
            }
            Statement s = this.smem.getDatabase().getConnection().createStatement();
            try {
                StringWriter out = new StringWriter();
                if (s.execute(sql)) {
                    JdbcTools.printResultSet(s.getResultSet(), out);
                }
                string = out.toString();
            }
            catch (Throwable throwable) {
                try {
                    s.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    this.agent.getPrinter().startNewLine().print(e.getMessage());
                    return "";
                }
            }
            s.close();
            return string;
        }

        private String doSet(String setParam, String value) {
            block22: {
                PropertyManager props = this.smem.getParams().getProperties();
                try {
                    if (setParam.equals("learning")) {
                        props.set(DefaultSemanticMemoryParams.LEARNING, DefaultSemanticMemoryParams.LearningChoices.valueOf(value));
                        break block22;
                    }
                    if (setParam.equals("driver")) {
                        props.set(DefaultSemanticMemoryParams.DRIVER, value);
                        break block22;
                    }
                    if (setParam.equals("protocol")) {
                        props.set(DefaultSemanticMemoryParams.PROTOCOL, value);
                        break block22;
                    }
                    if (setParam.equals("path")) {
                        props.set(DefaultSemanticMemoryParams.PATH, value);
                        break block22;
                    }
                    if (setParam.equals("lazy-commit")) {
                        props.set(DefaultSemanticMemoryParams.LAZY_COMMIT, DefaultSemanticMemoryParams.LazyCommitChoices.valueOf(value));
                        break block22;
                    }
                    if (setParam.equals("append-database")) {
                        props.set(DefaultSemanticMemoryParams.APPEND_DB, DefaultSemanticMemoryParams.AppendDatabaseChoices.valueOf(value));
                        break block22;
                    }
                    if (setParam.equals("page-size")) {
                        props.set(DefaultSemanticMemoryParams.PAGE_SIZE, DefaultSemanticMemoryParams.PageChoices.valueOf(value));
                        break block22;
                    }
                    if (setParam.equals("cache-size")) {
                        props.set(DefaultSemanticMemoryParams.CACHE_SIZE, Long.valueOf(value));
                        break block22;
                    }
                    if (setParam.equals("optimization")) {
                        props.set(DefaultSemanticMemoryParams.OPTIMIZATION, DefaultSemanticMemoryParams.Optimization.valueOf(value));
                        break block22;
                    }
                    if (setParam.equals("thresh")) {
                        props.set(DefaultSemanticMemoryParams.THRESH, Long.valueOf(value));
                        break block22;
                    }
                    if (setParam.equals("merge")) {
                        props.set(DefaultSemanticMemoryParams.MERGE, DefaultSemanticMemoryParams.MergeChoices.valueOf(value));
                        break block22;
                    }
                    if (setParam.equals("activation-mode")) {
                        props.set(DefaultSemanticMemoryParams.ACTIVATION_MODE, DefaultSemanticMemoryParams.ActivationChoices.getEnum(value));
                        break block22;
                    }
                    if (setParam.equals("activate-on-query")) {
                        props.set(DefaultSemanticMemoryParams.ACTIVATE_ON_QUERY, DefaultSemanticMemoryParams.ActivateOnQueryChoices.valueOf(value));
                        break block22;
                    }
                    if (setParam.equals("base-decay")) {
                        props.set(DefaultSemanticMemoryParams.BASE_DECAY, Double.valueOf(value));
                        break block22;
                    }
                    if (setParam.equals("base-update-policy")) {
                        props.set(DefaultSemanticMemoryParams.BASE_UPDATE, DefaultSemanticMemoryParams.BaseUpdateChoices.valueOf(value));
                        break block22;
                    }
                    if (setParam.equals("base-incremental-threshes")) {
                        props.set(DefaultSemanticMemoryParams.BASE_INCREMENTAL_THRESHES, this.smem.getParams().base_incremental_threshes.get().toSetWrapper(value));
                        break block22;
                    }
                    if (setParam.equals("mirroring")) {
                        props.set(DefaultSemanticMemoryParams.MIRRORING, DefaultSemanticMemoryParams.MirroringChoices.valueOf(value));
                        break block22;
                    }
                    if (setParam.equals("database")) {
                        if (value.equals("memory")) {
                            props.set(DefaultSemanticMemoryParams.PATH, ":memory:");
                            return "SMem| database = memory";
                        }
                        if (value.equals("file")) {
                            props.set(DefaultSemanticMemoryParams.PATH, "");
                            return "SMem| database = file";
                        }
                        throw new CommandLine.ParameterException(this.spec.commandLine(), "Invalid value for SMem database parameter");
                    }
                    throw new CommandLine.ParameterException(this.spec.commandLine(), "Unknown smem parameter '" + setParam + "'");
                }
                catch (IllegalArgumentException e) {
                    throw new CommandLine.ParameterException(this.spec.commandLine(), "Invalid value.", (Throwable)e);
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String doStats(String statToPrint) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            try {
                this.smem.smem_attach();
            }
            catch (SoarException e) {
                this.agent.getPrinter().startNewLine().print(e.getMessage());
                return "";
            }
            DefaultSemanticMemoryStats p = this.smem.getStats();
            if (statToPrint == null) {
                pw.printf(PrintHelper.generateHeader("Semantic Memory Statistics", 40), new Object[0]);
                try {
                    String database = this.smem.getDatabase().getConnection().getMetaData().getDatabaseProductName();
                    String version = this.smem.getDatabase().getConnection().getMetaData().getDatabaseProductVersion();
                    pw.printf(PrintHelper.generateItem(database + " Version:", version, 40), new Object[0]);
                }
                catch (SQLException e) {
                    this.agent.getPrinter().startNewLine().print(e.getMessage());
                    return "";
                }
                Statement s = null;
                long pageCount = 0L;
                long pageSize = 0L;
                try {
                    s = this.smem.getDatabase().getConnection().createStatement();
                    try (ResultSet rs = null;){
                        rs = s.executeQuery("PRAGMA page_count");
                        pageCount = rs.getLong(1);
                    }
                    try {
                        rs = s.executeQuery("PRAGMA page_size");
                        pageSize = rs.getLong(1);
                    }
                    finally {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    throw new CommandLine.ExecutionException(this.spec.commandLine(), e.getMessage(), (Throwable)e);
                }
                finally {
                    try {
                        s.close();
                    }
                    catch (SQLException e) {
                        throw new CommandLine.ExecutionException(this.spec.commandLine(), e.getMessage(), (Throwable)e);
                    }
                }
                p.mem_usage.set(pageCount * pageSize);
                pw.printf(PrintHelper.generateItem("Memory Usage:", new Double(p.mem_usage.get().longValue()) / 1024.0 + " KB", 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Memory Highwater:", p.mem_high.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Retrieves:", p.retrieves.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Queries:", p.queries.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Stores:", p.stores.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Activation Updates:", p.act_updates.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Mirrors:", p.mirrors.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Nodes:", p.nodes.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Edges:", p.edges.get(), 40), new Object[0]);
            } else {
                PropertyKey<?> key = DefaultSemanticMemoryStats.getProperty(this.smem.getParams().getProperties(), statToPrint);
                if (key == null) {
                    throw new CommandLine.ParameterException(this.spec.commandLine(), "Unknown stat '" + statToPrint + "'");
                }
                pw.printf(PrintHelper.generateItem(key + ":", this.smem.getParams().getProperties().get(key).toString(), 40), new Object[0]);
            }
            pw.flush();
            return sw.toString();
        }

        private String doTimers(String timerToPrint) {
            throw new CommandLine.ExecutionException(this.spec.commandLine(), "This command has not been implemented in JSoar.");
        }

        private String doViz(String arg) {
            if (arg == null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                try {
                    this.smem.smem_visualize_store(pw);
                }
                catch (SoarException e) {
                    throw new CommandLine.ExecutionException(this.spec.commandLine(), e.getMessage(), (Throwable)e);
                }
                pw.flush();
                return sw.toString();
            }
            throw new CommandLine.ExecutionException(this.spec.commandLine(), "smem --viz with args has not been implemented in JSoar.");
        }

        private String doSmem() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            DefaultSemanticMemoryParams p = this.smem.getParams();
            pw.printf(PrintHelper.generateHeader("Semantic Memory Settings", 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("learning:", p.learning.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateSection("Storage", 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("driver:", p.driver.get(), 40), new Object[0]);
            String nativeOrPure = null;
            try {
                SemanticMemoryDatabase db = this.smem.getDatabase();
                nativeOrPure = db != null ? db.getConnection().getMetaData().getDriverVersion() : "Not connected to database";
            }
            catch (SQLException e) {
                this.agent.getPrinter().startNewLine().print(e.getMessage());
                return "";
            }
            pw.printf(PrintHelper.generateItem("driver-type:", nativeOrPure, 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("protocol:", p.protocol.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("append-database:", p.append_db.get(), 40), new Object[0]);
            String database = "memory";
            String path = "";
            if (!p.path.get().equals(":memory:")) {
                database = "file";
                path = p.path.get();
            }
            pw.printf(PrintHelper.generateItem("database:", database, 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("path:", path, 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("lazy-commit:", p.lazy_commit.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateSection("Activation", 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("activation-mode:", p.activation_mode.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("activate-on-query:", p.activate_on_query.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("base-decay:", p.base_decay.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("base-update-policy", p.base_update.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("base-incremental-threshes", p.base_incremental_threshes.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("thresh", p.thresh.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateSection("Performance", 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("page-size:", p.page_size.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("cache-size:", p.cache_size.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("optimization:", p.optimization.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("timers:", "off - Not Implemented", 40), new Object[0]);
            pw.printf(PrintHelper.generateSection("Experimental", 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("merge:", p.merge.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("mirroring:", p.mirroring.get(), 40), new Object[0]);
            pw.flush();
            return sw.toString();
        }
    }

    public static class Provider
    implements SoarCommandProvider {
        @Override
        public void registerCommands(SoarCommandInterpreter interp, Adaptable context) {
            interp.addCommand("smem", new SmemCommand(context));
        }
    }
}

