/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.symbols;

import com.google.common.collect.Iterators;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jsoar.kernel.Goal;
import org.jsoar.kernel.GoalDependencySet;
import org.jsoar.kernel.memory.Slot;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.memory.WmeType;
import org.jsoar.kernel.symbols.GoalIdentifierInfo;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.util.ListHead;
import org.jsoar.util.ListItem;
import org.jsoar.util.markers.Marker;

public class IdentifierImpl
extends SymbolImpl
implements Identifier {
    private final long name_number;
    private final char name_letter;
    public short isa_operator;
    public boolean could_be_a_link_from_below;
    public int level;
    public int promotion_level;
    public int link_count;
    public ListItem<IdentifierImpl> unknown_level;
    public Slot slots;
    public Marker tc_number;
    public SymbolImpl variablization;
    public GoalIdentifierInfo goalInfo;
    private WmeImpl input_wmes;
    public int depth;
    public long smem_lti = 0L;
    public long smem_time_id = 0L;
    public long id_smem_valid = 0L;
    public long epmem_id = 0L;
    public long epmem_valid = 0L;

    IdentifierImpl(SymbolFactory factory, int hash_id, char name_letter, long name_number) {
        super(factory, hash_id);
        this.name_letter = name_letter;
        this.name_number = name_number;
    }

    @Override
    public char getNameLetter() {
        return this.name_letter;
    }

    @Override
    public long getNameNumber() {
        return this.name_number;
    }

    @Override
    public Iterator<Wme> getWmes() {
        return Iterators.concat((Iterator)new WmeIteratorSet(this));
    }

    @Override
    public Iterator<Wme> getWmes(EnumSet<WmeType> desired) {
        return Iterators.concat((Iterator)new WmeIteratorSet(this, desired));
    }

    @Override
    public IdentifierImpl asIdentifier() {
        return this;
    }

    @Override
    public boolean isSameTypeAs(SymbolImpl other) {
        return other.asIdentifier() != null;
    }

    @Override
    public char getFirstLetter() {
        return this.name_letter;
    }

    @Override
    public boolean isGoal() {
        return this.goalInfo != null;
    }

    @Override
    public boolean isOperator() {
        return this.isa_operator != 0;
    }

    private void mark_identifier_if_unmarked(Marker tc, ListHead<IdentifierImpl> id_list) {
        if (this.tc_number != tc) {
            this.tc_number = tc;
            if (id_list != null) {
                id_list.push(this);
            }
        }
    }

    public WmeImpl getInputWmes() {
        return this.input_wmes;
    }

    public void addInputWme(WmeImpl w) {
        this.input_wmes = w.addToList(this.input_wmes);
    }

    public void removeInputWme(WmeImpl w) {
        this.input_wmes = w.removeFromList(this.input_wmes);
    }

    public void removeAllInputWmes() {
        this.input_wmes = null;
    }

    public static void unmark(ListHead<IdentifierImpl> ids) {
        ListItem id = ids.first;
        while (id != null) {
            ((IdentifierImpl)id.item).tc_number = null;
            id = id.next;
        }
    }

    public void addSlot(Slot slot) {
        slot.next = this.slots;
        slot.prev = null;
        if (this.slots != null) {
            this.slots.prev = slot;
        }
        this.slots = slot;
    }

    public void removeSlot(Slot slot) {
        if (slot == this.slots) {
            this.slots = slot.next;
            if (this.slots != null) {
                this.slots.prev = null;
            }
        } else {
            slot.prev.next = slot.next;
            if (slot.next != null) {
                slot.next.prev = slot.prev;
            }
        }
        slot.prev = null;
        slot.next = null;
    }

    @Override
    public void add_symbol_to_tc(Marker tc, ListHead<IdentifierImpl> id_list, ListHead<Variable> var_list) {
        this.mark_identifier_if_unmarked(tc, id_list);
    }

    @Override
    public boolean symbol_is_in_tc(Marker tc) {
        return this.tc_number == tc;
    }

    @Override
    Symbol importInto(SymbolFactory factory) {
        throw new IllegalStateException("Cannot import identifiers");
    }

    @Override
    public boolean numericLess(SymbolImpl other) {
        IdentifierImpl i = other.asIdentifier();
        if (i != null) {
            if (this.name_letter == i.name_letter) {
                return this.name_number < i.name_number;
            }
            return this.name_letter < i.name_letter;
        }
        return super.numericLess(other);
    }

    @Override
    public boolean numericLessOrEqual(SymbolImpl other) {
        IdentifierImpl i = other.asIdentifier();
        if (i != null) {
            if (this.name_letter == i.name_letter) {
                return this.name_number <= i.name_number;
            }
            return this.name_letter <= i.name_letter;
        }
        return super.numericLessOrEqual(other);
    }

    @Override
    public boolean numericGreater(SymbolImpl other) {
        IdentifierImpl i = other.asIdentifier();
        if (i != null) {
            if (this.name_letter == i.name_letter) {
                return this.name_number > i.name_number;
            }
            return this.name_letter > i.name_letter;
        }
        return super.numericGreater(other);
    }

    @Override
    public boolean numericGreaterOrEqual(SymbolImpl other) {
        IdentifierImpl i = other.asIdentifier();
        if (i != null) {
            if (this.name_letter == i.name_letter) {
                return this.name_number >= i.name_number;
            }
            return this.name_letter >= i.name_letter;
        }
        return super.numericGreaterOrEqual(other);
    }

    public String toString() {
        return (this.smem_lti != 0L ? "@" : "") + this.name_letter + Long.toString(this.name_number);
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        formatter.format((this.smem_lti != 0L ? "@" : "") + this.name_letter + Long.toString(this.name_number), new Object[0]);
    }

    @Override
    public Object getAdapter(Class<?> klass) {
        if (Goal.class.equals(klass)) {
            return this.goalInfo;
        }
        if (this.isGoal() && GoalDependencySet.class.equals(klass)) {
            return this.goalInfo.gds;
        }
        return super.getAdapter(klass);
    }

    private static class WmeIteratorSet
    implements Iterator<Iterator<Wme>> {
        private final IdentifierImpl id;
        private boolean didImpasseWmes = false;
        private boolean didInputs = false;
        private Slot slot;

        public WmeIteratorSet(IdentifierImpl id, EnumSet<WmeType> desired) {
            this.id = id;
            this.didImpasseWmes = !desired.contains((Object)WmeType.IMPASSE);
            this.didInputs = !desired.contains((Object)WmeType.INPUT);
            this.slot = desired.contains((Object)WmeType.NORMAL) ? id.slots : null;
        }

        public WmeIteratorSet(IdentifierImpl id) {
            this.id = id;
            this.slot = id.slots;
        }

        @Override
        public boolean hasNext() {
            return !this.didImpasseWmes && this.id.goalInfo != null && this.id.goalInfo.getImpasseWmes() != null || !this.didInputs && this.id.getInputWmes() != null || this.slot != null;
        }

        @Override
        public Iterator<Wme> next() {
            if (!this.didImpasseWmes && this.id.goalInfo != null) {
                this.didImpasseWmes = true;
                if (this.id.goalInfo.getImpasseWmes() != null) {
                    return this.id.goalInfo.getImpasseWmes().iterator();
                }
            }
            if (!this.didInputs) {
                this.didInputs = true;
                if (this.id.getInputWmes() != null) {
                    return this.id.getInputWmes().iterator();
                }
            }
            if (this.slot == null) {
                throw new NoSuchElementException();
            }
            Iterator<Wme> r = this.slot.getWmeIterator();
            this.slot = this.slot.next;
            return r;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

