/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.symbols;

import java.util.Formatter;
import org.jsoar.kernel.symbols.DoubleSymbolImpl;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.SymbolImpl;

public class IntegerSymbolImpl
extends SymbolImpl
implements IntegerSymbol {
    private final long value;

    IntegerSymbolImpl(SymbolFactory factory, int hash_id, long value) {
        super(factory, hash_id);
        this.value = value;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public IntegerSymbolImpl asInteger() {
        return this;
    }

    @Override
    Symbol importInto(SymbolFactory factory) {
        return factory.createInteger(this.value);
    }

    @Override
    public boolean isSameTypeAs(SymbolImpl other) {
        return other.asInteger() != null;
    }

    @Override
    public boolean numericLess(SymbolImpl other) {
        IntegerSymbolImpl i = other.asInteger();
        if (i != null) {
            return this.getValue() < i.getValue();
        }
        DoubleSymbolImpl f = other.asDouble();
        return f != null ? (double)this.getValue() < f.getValue() : super.numericLess(other);
    }

    @Override
    public boolean numericLessOrEqual(SymbolImpl other) {
        IntegerSymbolImpl i = other.asInteger();
        if (i != null) {
            return this.getValue() <= i.getValue();
        }
        DoubleSymbolImpl f = other.asDouble();
        return f != null ? (double)this.getValue() <= f.getValue() : super.numericLess(other);
    }

    @Override
    public boolean numericGreater(SymbolImpl other) {
        IntegerSymbolImpl i = other.asInteger();
        if (i != null) {
            return this.getValue() > i.getValue();
        }
        DoubleSymbolImpl f = other.asDouble();
        return f != null ? (double)this.getValue() > f.getValue() : super.numericLess(other);
    }

    @Override
    public boolean numericGreaterOrEqual(SymbolImpl other) {
        IntegerSymbolImpl i = other.asInteger();
        if (i != null) {
            return this.getValue() >= i.getValue();
        }
        DoubleSymbolImpl f = other.asDouble();
        return f != null ? (double)this.getValue() >= f.getValue() : super.numericLess(other);
    }

    public String toString() {
        return Long.toString(this.getValue());
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        formatter.format(Long.toString(this.getValue()), new Object[0]);
    }
}

