/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.symbols;

import java.util.Formatter;
import org.jsoar.kernel.symbols.JavaSymbol;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.SymbolImpl;

public class JavaSymbolImpl
extends SymbolImpl
implements JavaSymbol {
    private final Object value;
    private final String classString;

    JavaSymbolImpl(SymbolFactory factory, int hash_id, Object value) {
        super(factory, hash_id);
        this.value = value;
        this.classString = value != null ? " (" + value.getClass().getName() + ")" : " (null Java Symbol)";
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public JavaSymbolImpl asJava() {
        return this;
    }

    @Override
    Symbol importInto(SymbolFactory factory) {
        return factory.createJavaSymbol(this.value);
    }

    @Override
    public boolean isSameTypeAs(SymbolImpl other) {
        return other.asJava() != null;
    }

    public String toString() {
        return this.value != null ? this.value.toString() + this.classString : "null";
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        formatter.format("%s", this.value + this.classString);
    }
}

