/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.symbols;

import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jsoar.kernel.symbols.DoubleSymbol;
import org.jsoar.kernel.symbols.DoubleSymbolImpl;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.IntegerSymbolImpl;
import org.jsoar.kernel.symbols.JavaSymbolImpl;
import org.jsoar.kernel.symbols.StringSymbol;
import org.jsoar.kernel.symbols.StringSymbolImpl;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.kernel.symbols.VariableGenerator;
import org.jsoar.util.ByRef;

public class SymbolFactoryImpl
implements SymbolFactory {
    private final long[] id_counter = new long[26];
    private final Map<String, StringSymbolImpl> symConstants = SymbolFactoryImpl.newReferenceMap();
    private final Map<Long, IntegerSymbolImpl> intConstants = SymbolFactoryImpl.newReferenceMap();
    private final Map<Double, DoubleSymbolImpl> floatConstants = SymbolFactoryImpl.newReferenceMap();
    private final Map<IdKey, IdentifierImpl> identifiers = SymbolFactoryImpl.newReferenceMap();
    private final Map<String, Variable> variables = SymbolFactoryImpl.newReferenceMap();
    private final Map<Object, JavaSymbolImpl> javaSyms = SymbolFactoryImpl.newReferenceMap();
    private final JavaSymbolImpl nullJavaSym;
    private int current_symbol_hash_id = 0;
    private final VariableGenerator vars = new VariableGenerator(this);

    private static <K, V> Map<K, V> newReferenceMap() {
        return new MapMaker().weakValues().makeMap();
    }

    public SymbolFactoryImpl() {
        this.nullJavaSym = new JavaSymbolImpl(this, this.get_next_hash_id(), null);
        this.reset();
    }

    public VariableGenerator getVariableGenerator() {
        return this.vars;
    }

    public List<Symbol> getAllSymbols() {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        result.addAll(this.identifiers.values());
        result.addAll(this.symConstants.values());
        result.addAll(this.intConstants.values());
        result.addAll(this.floatConstants.values());
        result.addAll(this.javaSyms.values());
        return result;
    }

    public <T extends Symbol> List<T> getSymbols(Class<T> klass) {
        if (klass.isAssignableFrom(StringSymbolImpl.class)) {
            return new ArrayList<StringSymbolImpl>(this.symConstants.values());
        }
        if (klass.isAssignableFrom(IntegerSymbolImpl.class)) {
            return new ArrayList<IntegerSymbolImpl>(this.intConstants.values());
        }
        if (klass.isAssignableFrom(DoubleSymbol.class)) {
            return new ArrayList<DoubleSymbolImpl>(this.floatConstants.values());
        }
        if (klass.isAssignableFrom(IdentifierImpl.class)) {
            return new ArrayList<IdentifierImpl>(this.identifiers.values());
        }
        if (klass.isAssignableFrom(Variable.class)) {
            return new ArrayList<Variable>(this.variables.values());
        }
        if (klass.isAssignableFrom(JavaSymbolImpl.class)) {
            ArrayList<JavaSymbolImpl> result = new ArrayList<JavaSymbolImpl>(this.javaSyms.values());
            result.add(this.nullJavaSym);
            return result;
        }
        throw new IllegalArgumentException("Expected Symbol implementation class, got '" + klass + "'");
    }

    public void reset() {
        Iterator<IdentifierImpl> it = this.identifiers.values().iterator();
        while (it.hasNext()) {
            IdentifierImpl id = it.next();
            if (id.smem_lti != 0L) continue;
            it.remove();
        }
        for (int i = 0; i < this.id_counter.length; ++i) {
            this.id_counter[i] = 1L;
        }
    }

    public void reset_id_and_variable_tc_numbers() {
        for (IdentifierImpl id : this.identifiers.values()) {
            id.tc_number = null;
        }
        for (Variable v : this.variables.values()) {
            v.tc_number = null;
        }
    }

    public void reset_variable_gensym_numbers() {
        for (Variable v : this.variables.values()) {
            v.gensym_number = 0;
        }
    }

    public void resetIdNumber(char name_letter, long letter_max) {
        int name_letter_index = name_letter - 65;
        if (this.id_counter[name_letter_index] <= letter_max) {
            this.id_counter[name_letter_index] = (int)letter_max + 1;
        }
    }

    public long getIdNumber(char name_letter) {
        return this.id_counter[name_letter - 65];
    }

    public long incrementIdNumber(char name_letter) {
        int n = name_letter - 65;
        long l = this.id_counter[n];
        this.id_counter[n] = l + 1L;
        return l;
    }

    public Variable find_variable(String name) {
        return this.variables.get(name);
    }

    public Variable make_variable(String name) {
        Variable v = this.find_variable(name);
        if (v == null) {
            v = new Variable(this, this.get_next_hash_id(), name);
            this.variables.put(v.name, v);
        }
        return v;
    }

    @Override
    public IdentifierImpl findIdentifier(char name_letter, long name_number) {
        return this.identifiers.get(SymbolFactoryImpl.getIdKey(name_letter, name_number));
    }

    public boolean findAndNullIdentifier(IdentifierImpl identifier) {
        if (identifier == null) {
            return false;
        }
        boolean found = this.identifiers.containsValue(identifier);
        if (found) {
            this.identifiers.remove(new IdKey(identifier.getNameLetter(), identifier.getNameNumber()));
        }
        return found;
    }

    public IdentifierImpl make_new_identifier(char name_letter, int level) {
        name_letter = (char)(Character.isLetter(name_letter) ? (int)Character.toUpperCase(name_letter) : 73);
        int n = name_letter - 65;
        long l = this.id_counter[n];
        this.id_counter[n] = l + 1L;
        long name_number = l;
        IdentifierImpl id = new IdentifierImpl(this, this.get_next_hash_id(), name_letter, name_number);
        id.level = level;
        id.promotion_level = level;
        this.identifiers.put(SymbolFactoryImpl.getIdKey(id.getNameLetter(), id.getNameNumber()), id);
        return id;
    }

    public IdentifierImpl make_new_identifier(char name_letter, long name_number, int level) {
        if (name_number >= this.id_counter[(name_letter = (char)(Character.isLetter(name_letter) ? (int)Character.toUpperCase(name_letter) : 73)) - 65]) {
            this.id_counter[name_letter - 65] = name_number + 1L;
        }
        IdentifierImpl id = new IdentifierImpl(this, this.get_next_hash_id(), name_letter, name_number);
        id.level = level;
        id.promotion_level = level;
        this.identifiers.put(SymbolFactoryImpl.getIdKey(id.getNameLetter(), id.getNameNumber()), id);
        return id;
    }

    @Override
    public IdentifierImpl createIdentifier(char name_letter) {
        return this.make_new_identifier(name_letter, 1);
    }

    @Override
    public IdentifierImpl findOrCreateIdentifier(char nameLetter, long nameNumber) {
        IdentifierImpl id = this.findIdentifier(nameLetter, nameNumber);
        if (id == null) {
            id = this.createIdentifier(nameLetter);
        }
        return id;
    }

    public IdentifierImpl findOrCreateIdentifierExact(char nameLetter, long nameNumber) {
        IdentifierImpl id = this.findIdentifier(nameLetter, nameNumber);
        if (id == null) {
            id = this.make_new_identifier(nameLetter, nameNumber, 1);
        }
        return id;
    }

    @Override
    public StringSymbolImpl findString(String name) {
        return this.symConstants.get(name);
    }

    @Override
    public StringSymbolImpl createString(String name) {
        StringSymbolImpl sym = this.findString(name);
        if (sym == null) {
            sym = new StringSymbolImpl(this, this.get_next_hash_id(), name);
            this.symConstants.put(name, sym);
        }
        return sym;
    }

    @Override
    public StringSymbol generateUniqueString(String prefix, ByRef<Integer> number) {
        ByRef<Integer> byRef = number;
        Object object = (Integer)byRef.value;
        byRef.value = (Integer)byRef.value + 1;
        Integer n = byRef.value;
        String name = prefix + object;
        StringSymbolImpl sym = this.findString(name);
        while (sym != null) {
            object = number;
            n = (Integer)((ByRef)object).value;
            ((ByRef)object).value = (Integer)((ByRef)object).value + 1;
            Integer n2 = ((ByRef)object).value;
            name = prefix + n;
            sym = this.findString(name);
        }
        return this.createString(name);
    }

    @Override
    public IntegerSymbolImpl createInteger(long value) {
        IntegerSymbolImpl sym = this.findInteger(value);
        if (sym == null) {
            sym = new IntegerSymbolImpl(this, this.get_next_hash_id(), value);
            this.intConstants.put(value, sym);
        }
        return sym;
    }

    @Override
    public IntegerSymbolImpl findInteger(long value) {
        return this.intConstants.get(value);
    }

    @Override
    public DoubleSymbolImpl createDouble(double value) {
        DoubleSymbolImpl sym = this.findDouble(value);
        if (sym == null) {
            sym = new DoubleSymbolImpl(this, this.get_next_hash_id(), value);
            this.floatConstants.put(value, sym);
        }
        return sym;
    }

    @Override
    public DoubleSymbolImpl findDouble(double value) {
        return this.floatConstants.get(value);
    }

    @Override
    public JavaSymbolImpl createJavaSymbol(Object value) {
        JavaSymbolImpl sym = this.findJavaSymbol(value);
        if (sym == null) {
            sym = new JavaSymbolImpl(this, this.get_next_hash_id(), value);
            this.javaSyms.put(value, sym);
        }
        return sym;
    }

    @Override
    public JavaSymbolImpl findJavaSymbol(Object value) {
        return value != null ? this.javaSyms.get(value) : this.nullJavaSym;
    }

    @Override
    public Symbol importSymbol(Symbol s) {
        if (s instanceof Identifier) {
            throw new IllegalArgumentException("Tried to import identifier " + s + " into symbol factory.");
        }
        if (s instanceof Variable) {
            throw new IllegalArgumentException("Tried to import variable " + s + " into symbol factory.");
        }
        return ((SymbolImpl)s).importInto(this);
    }

    private int get_next_hash_id() {
        return this.current_symbol_hash_id += 137;
    }

    private static IdKey getIdKey(char letter, long number) {
        return new IdKey(letter, number);
    }

    private static class IdKey {
        private final char letter;
        private final long number;

        public IdKey(char letter, long number) {
            this.letter = letter;
            this.number = number;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.letter;
            result = 31 * result + (int)(this.number ^ this.number >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            IdKey other = (IdKey)obj;
            if (this.letter != other.letter) {
                return false;
            }
            return this.number == other.number;
        }
    }
}

