/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.symbols;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.parser.original.Lexeme;
import org.jsoar.kernel.parser.original.Lexer;
import org.jsoar.kernel.symbols.DoubleSymbol;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.JavaSymbol;
import org.jsoar.kernel.symbols.StringSymbol;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.util.Arguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Symbols {
    private static final Logger logger = LoggerFactory.getLogger(Agent.class);
    private static final boolean WARN_ON_JAVA_SYMBOLS = Boolean.valueOf(System.getProperty("jsoar.warnOnJavaSymbols", "true"));
    public static final int IDENTIFIER_SYMBOL_TYPE = 1;
    public static final int SYM_CONSTANT_SYMBOL_TYPE = 2;
    public static final int INT_CONSTANT_SYMBOL_TYPE = 3;
    public static final int FLOAT_CONSTANT_SYMBOL_TYPE = 4;
    private static Pattern ID_PATTERN = Pattern.compile("^\\s*([a-zA-Z])(\\d+)\\s*$");
    public static final Object NEW_ID = new Object(){

        public String toString() {
            return "*create a new identifier*";
        }
    };

    public static int getSymbolType(Symbol sym) {
        if (sym.asIdentifier() != null) {
            return 1;
        }
        if (sym.asString() != null) {
            return 2;
        }
        if (sym.asInteger() != null) {
            return 3;
        }
        if (sym.asDouble() != null) {
            return 4;
        }
        throw new IllegalArgumentException("Don't know integer type of symbol " + sym);
    }

    private Symbols() {
    }

    public static Symbol create(SymbolFactory factory, Object value) {
        Arguments.checkNotNull(factory, "factory");
        if (value == NEW_ID) {
            return factory.createIdentifier('Z');
        }
        if (value instanceof Symbol) {
            return (Symbol)value;
        }
        if (value instanceof Character || value instanceof String) {
            return factory.createString(value.toString());
        }
        if (value instanceof Double || value instanceof Float) {
            return factory.createDouble(((Number)value).doubleValue());
        }
        if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte || value instanceof AtomicInteger || value instanceof AtomicLong) {
            return factory.createInteger(((Number)value).longValue());
        }
        if (WARN_ON_JAVA_SYMBOLS) {
            logger.warn("A Java symbol with value '" + value + "' is being created. Are you sure this is what you want to do? Disable this message with -Djsoar.warnOnJavaSymbols=false.");
        }
        return factory.createJavaSymbol(value);
    }

    public static Object valueOf(Symbol sym) {
        Arguments.checkNotNull(sym, "sym");
        Identifier id = sym.asIdentifier();
        if (id != null) {
            return id;
        }
        DoubleSymbol d = sym.asDouble();
        if (d != null) {
            return d.getValue();
        }
        IntegerSymbol i = sym.asInteger();
        if (i != null) {
            return i.getValue();
        }
        StringSymbol s = sym.asString();
        if (s != null) {
            return s.toString();
        }
        JavaSymbol js = sym.asJava();
        if (js != null) {
            return js.getValue();
        }
        throw new IllegalStateException("Unknown symbol type: " + sym.getClass());
    }

    public static List<Symbol> asList(SymbolFactory factory, Object ... objects) {
        ArrayList<Symbol> result = new ArrayList<Symbol>(objects.length);
        for (Object o : objects) {
            result.add(Symbols.create(factory, o));
        }
        return result;
    }

    public static char getFirstLetter(Object attr) {
        if (attr == null) {
            return 'Z';
        }
        String s = attr.toString();
        if (s.length() == 0) {
            return 'Z';
        }
        char c = s.charAt(0);
        if (!Character.isLetter(c)) {
            return 'Z';
        }
        return Character.toUpperCase(c);
    }

    public static Identifier parseIdentifier(SymbolFactory symbols, String idString) {
        Matcher matcher = ID_PATTERN.matcher(idString);
        if (matcher.matches()) {
            char letter = matcher.group(1).toUpperCase().charAt(0);
            try {
                long number = Long.parseLong(matcher.group(2));
                return symbols.findIdentifier(letter, number);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static Symbol readAttributeFromString(Agent agent, String s) {
        if (s == null) {
            return null;
        }
        if (s.length() > 0 && s.charAt(0) == '^') {
            s = s.substring(1);
        }
        try {
            Symbol attr;
            Lexer lexer = new Lexer(agent.getPrinter(), new StringReader(s));
            lexer.getNextLexeme();
            Lexeme lexeme = lexer.getCurrentLexeme();
            if (lexeme == null) {
                return null;
            }
            SymbolFactory syms = agent.getSymbols();
            switch (lexeme.type) {
                case SYM_CONSTANT: {
                    attr = syms.findString(lexeme.string);
                    break;
                }
                case INTEGER: {
                    attr = syms.findInteger(lexeme.int_val);
                    break;
                }
                case FLOAT: {
                    attr = syms.findDouble(lexeme.float_val);
                    break;
                }
                case IDENTIFIER: {
                    attr = syms.findIdentifier(lexeme.id_letter, lexeme.id_number);
                    break;
                }
                case VARIABLE: {
                    attr = agent.readIdentifierOrContextVariable(lexeme.string);
                    break;
                }
                default: {
                    return null;
                }
            }
            return attr;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static double asDouble(Symbol sym) {
        IntegerSymbol ic = sym.asInteger();
        if (ic != null) {
            return ic.getValue();
        }
        DoubleSymbol d = sym.asDouble();
        if (d != null) {
            return d.getValue();
        }
        return 0.0;
    }

    public static boolean equalByValue(Symbol s1, Symbol s2) {
        Identifier i1 = s1.asIdentifier();
        Identifier i2 = s2.asIdentifier();
        if (i1 != null && i2 != null) {
            return i1.getNameLetter() == i2.getNameLetter() && i1.getNameNumber() == i2.getNameNumber();
        }
        if (i1 != null || i2 != null) {
            return false;
        }
        return Symbols.valueOf(s1).equals(Symbols.valueOf(s2));
    }
}

