/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.symbols;

import java.util.Formatter;
import java.util.LinkedList;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.util.ListHead;
import org.jsoar.util.ListItem;
import org.jsoar.util.markers.Marker;

public class Variable
extends SymbolImpl {
    public final String name;
    public Marker tc_number;
    public SymbolImpl current_binding_value;
    public int unbound_variable_index;
    public int gensym_number;
    public final LinkedList<Integer> rete_binding_locations = new LinkedList();

    Variable(SymbolFactory factory, int hash_id, String name) {
        super(factory, hash_id);
        this.name = name;
    }

    public void markIfUnmarked(Marker tc_number, ListHead<Variable> var_list) {
        if (this.tc_number != tc_number) {
            this.tc_number = tc_number;
            if (var_list != null) {
                var_list.push(this);
            }
        }
    }

    public static void unmark(ListHead<Variable> vars) {
        ListItem it = vars.first;
        while (it != null) {
            ((Variable)it.item).unmark();
            it = it.next;
        }
    }

    public void unmark() {
        this.tc_number = null;
    }

    public boolean var_is_bound() {
        return !this.rete_binding_locations.isEmpty();
    }

    private static int varloc_to_dummy(int depth, int field_num) {
        return (depth << 2) + field_num;
    }

    public static int dummy_to_varloc_depth(int d) {
        return d >> 2;
    }

    public static int dummy_to_varloc_field_num(int d) {
        return d & 3;
    }

    public void push_var_binding(int depth, int field_num) {
        int dummy_xy312 = Variable.varloc_to_dummy(depth, field_num);
        this.rete_binding_locations.push(dummy_xy312);
    }

    public void pop_var_binding() {
        this.rete_binding_locations.pop();
    }

    public static void pop_bindings_and_deallocate_list_of_variables(ListHead<Variable> vars) {
        ListItem v = vars.first;
        while (v != null) {
            ((Variable)v.item).pop_var_binding();
            v = v.next;
        }
    }

    @Override
    public Variable asVariable() {
        return this;
    }

    @Override
    Symbol importInto(SymbolFactory factory) {
        throw new IllegalStateException("Cannot import variable symbols");
    }

    @Override
    public boolean isSameTypeAs(SymbolImpl other) {
        return other.asVariable() != null;
    }

    @Override
    public char getFirstLetter() {
        return this.name.charAt(1);
    }

    @Override
    public void add_symbol_to_tc(Marker tc, ListHead<IdentifierImpl> id_list, ListHead<Variable> var_list) {
        this.markIfUnmarked(tc, var_list);
    }

    @Override
    public boolean symbol_is_in_tc(Marker tc) {
        return this.tc_number == tc;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        formatter.format(this.name, new Object[0]);
    }
}

