/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.symbols;

import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.rhs.Action;
import org.jsoar.kernel.symbols.SymbolFactoryImpl;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.util.ListHead;
import org.jsoar.util.ListItem;
import org.jsoar.util.markers.DefaultMarker;

public class VariableGenerator {
    private SymbolFactoryImpl syms;
    private int[] gensymed_variable_count = new int[26];
    private int current_variable_gensym_number = 0;

    VariableGenerator(SymbolFactoryImpl syms) {
        this.syms = syms;
    }

    public SymbolFactoryImpl getSyms() {
        return this.syms;
    }

    public void reset(Condition conds_with_vars_to_avoid, Action actions_with_vars_to_avoid) {
        for (int i = 0; i < 26; ++i) {
            this.gensymed_variable_count[i] = 1;
        }
        ++this.current_variable_gensym_number;
        if (this.current_variable_gensym_number == Integer.MAX_VALUE) {
            this.syms.reset_variable_gensym_numbers();
            this.current_variable_gensym_number = 1;
        }
        DefaultMarker tc_number = DefaultMarker.create();
        ListHead<Variable> var_list = ListHead.newInstance();
        Condition.addAllVariables(conds_with_vars_to_avoid, tc_number, var_list);
        Action.addAllVariables(actions_with_vars_to_avoid, tc_number, var_list);
        ListItem var = var_list.first;
        while (var != null) {
            ((Variable)var.item).gensym_number = this.current_variable_gensym_number;
            var = var.next;
        }
    }

    public Variable generate_new_variable(String prefix) {
        int first_letter = prefix.charAt(0);
        first_letter = Character.isLetter((char)first_letter) ? (int)Character.toLowerCase((char)first_letter) : 118;
        Variable New = null;
        do {
            int n = first_letter - 97;
            int n2 = this.gensymed_variable_count[n];
            this.gensymed_variable_count[n] = n2 + 1;
            String name = "<" + prefix + n2 + ">";
            New = this.syms.make_variable(name);
        } while (New.gensym_number == this.current_variable_gensym_number);
        New.current_binding_value = null;
        New.gensym_number = this.current_variable_gensym_number;
        return New;
    }
}

