/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.tracing;

import java.io.OutputStreamWriter;
import java.util.EnumSet;
import java.util.Formattable;
import java.util.Formatter;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Traceable;
import org.jsoar.util.Arguments;

public class Trace {
    private final Printer printer;
    private EnumSet<Category> settings = EnumSet.noneOf(Category.class);
    private boolean enabled = true;
    private WmeTraceType wmeTraceType = WmeTraceType.NONE;

    public static Trace createStdOutTrace() {
        return new Trace(new Printer(new OutputStreamWriter(System.out)));
    }

    public Trace(Printer printer) {
        this.printer = printer;
        for (Category c : Category.values()) {
            if (!c.defaultSetting) continue;
            this.settings.add(c);
        }
    }

    public Printer getPrinter() {
        return this.printer;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Trace setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Trace enableAll() {
        this.setEnabled(true);
        this.settings = EnumSet.allOf(Category.class);
        this.setWmeTraceType(WmeTraceType.FULL);
        return this;
    }

    public Trace disableAll() {
        this.settings.clear();
        return this;
    }

    public boolean isEnabled(Category c) {
        return this.settings.contains((Object)c);
    }

    public boolean isEnabled(EnumSet<Category> anyOf) {
        for (Category c : anyOf) {
            if (!this.isEnabled(c)) continue;
            return true;
        }
        return false;
    }

    public Trace setEnabled(Category c, boolean enabled) {
        if (enabled) {
            this.setEnabled(true);
            this.settings.add(c);
        } else {
            this.settings.remove((Object)c);
        }
        return this;
    }

    public Trace setWatchLevel(int watchLevel) {
        Arguments.check(0 <= watchLevel && watchLevel <= 5, "watch level must be in 0, 1, 2, 3, 4, or 5");
        this.enabled = true;
        for (Category c : Category.values()) {
            if (!c.isWatchable()) continue;
            if (c.isActiveInWatchLevel(watchLevel)) {
                this.settings.add(c);
                continue;
            }
            this.settings.remove((Object)c);
        }
        return this;
    }

    public WmeTraceType getWmeTraceType() {
        return this.wmeTraceType;
    }

    public void setWmeTraceType(WmeTraceType wmeTraceType) {
        this.wmeTraceType = wmeTraceType;
    }

    public Trace print(String format, Object ... args) {
        if (this.enabled) {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof Traceable)) continue;
                args[i] = new Proxy((Traceable)args[i]);
            }
            this.printer.print(format, args);
        }
        return this;
    }

    public Trace print(String output) {
        if (this.enabled) {
            this.printer.print(output);
        }
        return this;
    }

    public Trace print(Category c, String format, Object ... args) {
        if (this.enabled && this.isEnabled(c)) {
            this.print(format, args);
        }
        return this;
    }

    public Trace print(EnumSet<Category> anyOf, String format, Object ... args) {
        if (this.enabled && this.isEnabled(anyOf)) {
            this.print(format, args);
        }
        return this;
    }

    public Trace print(Category c, String output) {
        if (this.enabled && this.isEnabled(c)) {
            this.print(output);
        }
        return this;
    }

    public void flush() {
        this.printer.flush();
    }

    public Trace startNewLine() {
        if (this.enabled) {
            this.printer.startNewLine();
        }
        return this;
    }

    private class Proxy
    implements Formattable {
        private final Traceable traceable;

        public Proxy(Traceable traceable) {
            this.traceable = traceable;
        }

        @Override
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            this.traceable.trace(Trace.this, formatter, flags, width, precision);
        }
    }

    public static enum MatchSetTraceType {
        MS_ASSERT,
        MS_RETRACT;

    }

    public static enum WmeTraceType {
        NONE,
        TIMETAG,
        FULL;

    }

    public static enum Category {
        VERBOSE(-1),
        CONTEXT_DECISIONS(true, 1),
        PHASES(2),
        FIRINGS_OF_USER_PRODS(3),
        FIRINGS_OF_DEFAULT_PRODS(3),
        FIRINGS_OF_CHUNKS(3),
        FIRINGS_OF_JUSTIFICATIONS(3),
        FIRINGS_OF_TEMPLATES(3),
        FIRINGS_PREFERENCES(5),
        WM_CHANGES(4),
        CHUNK_NAMES(-1),
        JUSTIFICATION_NAMES(-1),
        CHUNKS(-1),
        JUSTIFICATIONS(-1),
        BACKTRACING(-1),
        LOADING(true, -1),
        OPERAND2_REMOVALS(-1),
        INDIFFERENT(-1),
        RL(-1),
        EPMEM(-1),
        SMEM(-1),
        WMA(-1),
        WATERFALL(-1),
        GDS(2);

        private final boolean defaultSetting;
        private final int watchLevel;

        private Category(int watchLevel) {
            this(false, watchLevel);
        }

        private Category(boolean defaultSetting, int watchLevel) {
            this.defaultSetting = defaultSetting;
            this.watchLevel = watchLevel;
        }

        public boolean getDefault() {
            return this.defaultSetting;
        }

        public boolean isActiveInWatchLevel(int watchLevel) {
            return this.watchLevel != -1 && watchLevel >= this.watchLevel;
        }

        public boolean isWatchable() {
            return this.watchLevel != -1;
        }
    }
}

