/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.wma;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jsoar.kernel.Decider;
import org.jsoar.kernel.DecisionCycle;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.PositiveCondition;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.memory.PreferenceType;
import org.jsoar.kernel.memory.RecognitionMemory;
import org.jsoar.kernel.memory.Slot;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.memory.WorkingMemory;
import org.jsoar.kernel.rete.Rete;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.kernel.wma.DefaultWorkingMemoryActivationParams;
import org.jsoar.kernel.wma.DefaultWorkingMemoryActivationStats;
import org.jsoar.kernel.wma.DefaultWorkingMemoryActivationTimers;
import org.jsoar.kernel.wma.WorkingMemoryActivation;
import org.jsoar.kernel.wma.wma_decay_element;
import org.jsoar.kernel.wma.wma_go_action;
import org.jsoar.kernel.wma.wma_history;
import org.jsoar.util.adaptables.Adaptable;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.properties.PropertyChangeEvent;
import org.jsoar.util.properties.PropertyListener;
import org.jsoar.util.properties.PropertyManager;

public class DefaultWorkingMemoryActivation
implements WorkingMemoryActivation {
    private static final int WMA_REFERENCES_PER_DECISION = 50;
    private static final double WMA_ACTIVATION_NONE = 1.0;
    private static final double WMA_TIME_SUM_NONE = 2.71828182845905;
    private static final double WMA_ACTIVATION_LOW = -1.0E9;
    private static final long WMA_FORGOTTEN_CYCLE = 0L;
    private Adaptable context;
    private Trace trace;
    private DecisionCycle decisionCycle;
    private RecognitionMemory recMemory;
    private Rete rete;
    private Decider decider;
    private WorkingMemory workingMemory;
    private DefaultWorkingMemoryActivationParams params;
    private DefaultWorkingMemoryActivationStats stats;
    private DefaultWorkingMemoryActivationTimers timers;
    private Set<Wme> wma_touched_elements;
    private TreeMap<Long, Set<wma_decay_element>> wma_forget_pq;
    private Set<Long> wma_touched_sets;
    private Map<Wme, wma_decay_element> wmaDecayElements = new HashMap<Wme, wma_decay_element>();
    private int wma_power_size;
    private double[] wma_power_array;
    private long[] wma_approx_array;
    private double wma_thresh_exp;
    private boolean wma_initialized;
    private long wma_d_cycle_count;

    public DefaultWorkingMemoryActivation(Adaptable context) {
        this.context = context;
    }

    public void d_cycle_count_increment() {
        ++this.wma_d_cycle_count;
    }

    public void d_cycle_count_decrement() {
        --this.wma_d_cycle_count;
    }

    public void resetTimers() {
        this.timers.reset();
    }

    public long get_d_cycle_count() {
        return this.wma_d_cycle_count;
    }

    public DefaultWorkingMemoryActivationParams getParams() {
        return this.params;
    }

    public DefaultWorkingMemoryActivationStats getStats() {
        return this.stats;
    }

    public DefaultWorkingMemoryActivationTimers getTimers() {
        return this.timers;
    }

    public void initialize() {
        this.trace = Adaptables.require(this.getClass(), this.context, Trace.class);
        this.decisionCycle = Adaptables.adapt(this.context, DecisionCycle.class);
        this.recMemory = Adaptables.require(this.getClass(), this.context, RecognitionMemory.class);
        this.rete = Adaptables.require(this.getClass(), this.context, Rete.class);
        this.decider = Adaptables.require(this.getClass(), this.context, Decider.class);
        this.workingMemory = Adaptables.require(this.getClass(), this.context, WorkingMemory.class);
        PropertyManager properties = Adaptables.require(DefaultWorkingMemoryActivation.class, this.context, PropertyManager.class);
        this.params = new DefaultWorkingMemoryActivationParams(properties);
        this.stats = new DefaultWorkingMemoryActivationStats(properties);
        this.timers = new DefaultWorkingMemoryActivationTimers(properties);
        this.wma_forget_pq = new TreeMap();
        this.wma_touched_elements = new HashSet<Wme>();
        this.wma_touched_sets = new HashSet<Long>();
        properties.addListener(DefaultWorkingMemoryActivationParams.ACTIVATION, new PropertyListener<DefaultWorkingMemoryActivationParams.ActivationChoices>(){

            @Override
            public void propertyChanged(PropertyChangeEvent<DefaultWorkingMemoryActivationParams.ActivationChoices> event) {
                if (event.getNewValue() != event.getOldValue()) {
                    if (event.getNewValue() == DefaultWorkingMemoryActivationParams.ActivationChoices.on) {
                        DefaultWorkingMemoryActivation.this.wma_init();
                    } else {
                        DefaultWorkingMemoryActivation.this.wma_deinit();
                    }
                }
            }
        });
        this.wma_initialized = false;
    }

    public void reset() {
        this.timers.reset();
        this.wma_d_cycle_count = 0L;
    }

    @Override
    public boolean wma_enabled() {
        return this.params.activation.get() == DefaultWorkingMemoryActivationParams.ActivationChoices.on;
    }

    private void wma_init() {
        int i;
        double cache_bound;
        if (this.wma_initialized) {
            return;
        }
        double decay_rate = this.params.decay_rate.get();
        double decay_thresh = this.params.decay_thresh.get();
        long max_pow_cache = this.params.max_pow_cache.get().intValue();
        double cache_full = Math.exp((decay_thresh - Math.log(50.0)) / decay_rate);
        this.wma_power_size = (int)Math.ceil(cache_full > (cache_bound = (double)(max_pow_cache * 1024L * 1024L / 8L)) ? cache_bound : cache_full);
        this.wma_power_array = new double[this.wma_power_size];
        this.wma_power_array[0] = 0.0;
        for (i = 1; i < this.wma_power_size; ++i) {
            this.wma_power_array[i] = Math.pow(i, decay_rate);
        }
        this.wma_thresh_exp = Math.exp(decay_thresh);
        if (this.params.forgetting.get() == DefaultWorkingMemoryActivationParams.ForgettingChoices.approx) {
            this.wma_approx_array = new long[50];
            this.wma_approx_array[0] = 0L;
            for (i = 1; i < 50; ++i) {
                this.wma_approx_array[i] = (long)Math.ceil(Math.exp((decay_thresh - Math.log(i)) / decay_rate));
            }
        }
        this.wma_initialized = true;
    }

    private void wma_deinit() {
        if (!this.wma_initialized) {
            return;
        }
        this.wma_power_array = null;
        if (this.params.forgetting.get() == DefaultWorkingMemoryActivationParams.ForgettingChoices.approx) {
            this.wma_approx_array = null;
        }
        this.wma_touched_elements.clear();
        this.wma_touched_sets.clear();
        this.wma_forget_pq.clear();
        this.wmaDecayElements.clear();
        this.wma_initialized = false;
    }

    private int wma_history_next(int current) {
        return current == 9 ? 0 : current + 1;
    }

    private int wma_history_prev(int current) {
        return current == 0 ? 9 : current - 1;
    }

    private boolean wma_should_have_decay_element(Wme w) {
        Iterator<Preference> it = w.getPreferences();
        if (!it.hasNext()) {
            return false;
        }
        Preference preference = it.next();
        return preference.reference_count != 0 && preference.o_supported;
    }

    private double wma_pow(long cycle_diff) {
        if (cycle_diff < (long)this.wma_power_size) {
            return this.wma_power_array[(int)cycle_diff];
        }
        return Math.pow(cycle_diff, this.params.decay_rate.get());
    }

    private double wma_sum_history(wma_history history, long current_cycle) {
        double return_val = 0.0;
        int p = history.next_p;
        long cycle_diff = 0L;
        for (int counter = history.history_ct; counter != 0; --counter) {
            p = this.wma_history_prev(p);
            cycle_diff = current_cycle - history.access_history[p].d_cycle;
            assert (cycle_diff > 0L);
            return_val += (double)history.access_history[p].num_references * this.wma_pow(cycle_diff);
        }
        if (this.params.petrov_approx.get() == DefaultWorkingMemoryActivationParams.PetrovApproxChoices.on && history.total_references > history.history_references) {
            double d_inv = 1.0 + this.params.decay_rate.get();
            return_val += (double)(history.total_references - history.history_references) * (Math.pow(current_cycle - history.first_reference, d_inv) - Math.pow(cycle_diff, d_inv)) / (d_inv * (double)(current_cycle - history.first_reference - cycle_diff));
        }
        return return_val;
    }

    private double wma_calculate_decay_activation(wma_decay_element decay_el, long current_cycle, boolean log_result) {
        wma_history history = decay_el.touches;
        if (history.history_ct != 0) {
            double history_sum = this.wma_sum_history(history, current_cycle);
            if (!log_result) {
                return history_sum;
            }
            if (history_sum > 0.0) {
                return Math.log(history_sum);
            }
            return -1.0E9;
        }
        return log_result ? -1.0E9 : 0.0;
    }

    private long wma_calculate_initial_boost(Wme w) {
        long return_val = 0L;
        HashSet<Wme> alreadyProcessed = new HashSet<Wme>();
        long num_cond_wmes = 0L;
        double combined_time_sum = 0.0;
        Preference pref = w.getPreferences().next().slot.getPreferencesByType(PreferenceType.ACCEPTABLE);
        while (pref != null) {
            if (pref.value == w.getValue() && pref.o_supported) {
                Condition cond = pref.inst.top_of_instantiated_conditions;
                while (cond != null) {
                    PositiveCondition pc = cond.asPositiveCondition();
                    if (pc != null && !alreadyProcessed.contains(pc.bt().wme_)) {
                        WmeImpl cond_wme = pc.bt().wme_;
                        alreadyProcessed.add(cond_wme);
                        wma_decay_element wma_decay_el = this.wmaDecayElements.get(cond_wme);
                        if (wma_decay_el != null) {
                            if (!wma_decay_el.just_created) {
                                ++num_cond_wmes;
                                combined_time_sum += this.wma_get_wme_activation(cond_wme, false);
                            }
                        } else if (cond_wme.getPreferences().hasNext()) {
                            Preference p = cond_wme.getPreferences().next();
                            if (p.wma_o_set != null) {
                                for (Wme wme : p.wma_o_set) {
                                    wma_decay_el = this.wmaDecayElements.get(wme);
                                    if (alreadyProcessed.contains(wme) || wma_decay_el != null && wma_decay_el.just_created) continue;
                                    ++num_cond_wmes;
                                    combined_time_sum += this.wma_get_wme_activation(wme, false);
                                    alreadyProcessed.add(wme);
                                }
                            }
                        } else {
                            ++num_cond_wmes;
                            combined_time_sum += this.wma_get_wme_activation(cond_wme, false);
                        }
                    }
                    cond = cond.next;
                }
            }
            pref = pref.next;
        }
        if (num_cond_wmes != 0L) {
            return_val = (long)Math.floor(combined_time_sum / (double)num_cond_wmes);
        }
        return return_val;
    }

    @Override
    public void wma_activate_wme(Wme w, long num_references, Set<Wme> o_set) {
        this.wma_activate_wme(w, num_references, o_set, false);
    }

    @Override
    public void wma_activate_wme(Wme w, long num_references) {
        this.wma_activate_wme(w, num_references, null, false);
    }

    @Override
    public void wma_activate_wme(Wme w) {
        this.wma_activate_wme(w, 1L, null, false);
    }

    @Override
    public void wma_activate_wme(Wme w, long num_references, Set<Wme> o_set, boolean o_only) {
        if (this.wma_should_have_decay_element(w)) {
            wma_decay_element temp_el = this.wmaDecayElements.get(w);
            if (temp_el == null) {
                temp_el = new wma_decay_element();
                temp_el.this_wme = w;
                temp_el.just_removed = false;
                temp_el.just_created = true;
                temp_el.num_references = this.wma_calculate_initial_boost(w);
                temp_el.touches.history_ct = 0;
                temp_el.touches.next_p = 0;
                for (int i = 0; i < 10; ++i) {
                    temp_el.touches.access_history[i].d_cycle = 0L;
                    temp_el.touches.access_history[i].num_references = 0L;
                }
                temp_el.touches.history_references = 0L;
                temp_el.touches.total_references = 0L;
                temp_el.touches.first_reference = 0L;
                temp_el.forget_cycle = -1L;
                this.wmaDecayElements.put(w, temp_el);
                if (this.trace.isEnabled(Trace.Category.WMA)) {
                    this.trace.getPrinter().print("WMA @" + this.decisionCycle.d_cycle_count + ": add " + w.getTimetag() + " " + w.getIdentifier() + " " + w.getAttribute() + " " + w.getValue() + "\n");
                }
            }
            if (o_set != null) {
                o_set.add(w);
            } else {
                temp_el.num_references += num_references;
                this.wma_touched_elements.add(w);
            }
        } else if (!o_only && w.getPreferences().hasNext() && w.getPreferences().next().reference_count != 0) {
            Set<Wme> my_o_set = w.getPreferences().next().wma_o_set;
            if (my_o_set == null) {
                w.getPreferences().next().wma_o_set = my_o_set = new HashSet<Wme>();
                Condition c = w.getPreferences().next().inst.top_of_instantiated_conditions;
                while (c != null) {
                    PositiveCondition pc = c.asPositiveCondition();
                    if (pc != null) {
                        this.wma_activate_wme(pc.bt().wme_, 0L, my_o_set);
                    }
                    c = c.next;
                }
            }
            for (Wme wme : my_o_set) {
                if (o_set != null) {
                    o_set.add(wme);
                    continue;
                }
                wma_decay_element wma_decay_el = this.wmaDecayElements.get(wme);
                if (wma_decay_el == null) continue;
                wma_decay_el.num_references += num_references;
                this.wma_touched_elements.add(wme);
            }
        } else if (!o_only && !w.getPreferences().hasNext() && o_set != null) {
            o_set.add(w);
        }
    }

    private void wma_deactivate_element(Wme w, wma_decay_element temp_el) {
        if (temp_el != null && !temp_el.just_removed) {
            this.wma_touched_elements.remove(w);
            if (this.params.forgetting.get() == DefaultWorkingMemoryActivationParams.ForgettingChoices.approx || this.params.forgetting.get() == DefaultWorkingMemoryActivationParams.ForgettingChoices.bsearch) {
                this.wma_forgetting_remove_from_p_queue(temp_el);
            }
            temp_el.just_removed = true;
        }
    }

    @Override
    public void wma_remove_decay_element(Wme w) {
        wma_decay_element temp_el = this.wmaDecayElements.get(w);
        if (temp_el != null) {
            if (!temp_el.just_removed) {
                this.wma_deactivate_element(w, temp_el);
            }
            if (this.trace.isEnabled(Trace.Category.WMA)) {
                this.trace.getPrinter().print("WMA @" + this.decisionCycle.d_cycle_count + ": remove " + w.getTimetag() + "\n");
            }
            this.wmaDecayElements.remove(w);
        }
    }

    private void wma_forgetting_add_to_p_queue(wma_decay_element decay_el, long new_cycle) {
        if (decay_el != null) {
            decay_el.forget_cycle = new_cycle;
            Set<wma_decay_element> pq = this.wma_forget_pq.get(new_cycle);
            if (pq == null) {
                HashSet<wma_decay_element> newbie = new HashSet<wma_decay_element>();
                newbie.add(decay_el);
                this.wma_forget_pq.put(new_cycle, newbie);
            } else {
                pq.add(decay_el);
            }
        }
    }

    private void wma_forgetting_remove_from_p_queue(wma_decay_element decay_el) {
        Set<wma_decay_element> pq;
        if (decay_el != null && (pq = this.wma_forget_pq.get(decay_el.forget_cycle)) != null && pq.contains(decay_el)) {
            pq.remove(decay_el);
            if (pq.isEmpty()) {
                this.wma_touched_sets.add(decay_el.forget_cycle);
            }
        }
    }

    private void wma_forgetting_move_in_p_queue(wma_decay_element decay_el, long new_cycle) {
        if (decay_el != null && decay_el.forget_cycle != new_cycle) {
            this.wma_forgetting_remove_from_p_queue(decay_el);
            this.wma_forgetting_add_to_p_queue(decay_el, new_cycle);
        }
    }

    private long wma_forgetting_estimate_cycle(wma_decay_element decay_el, boolean fresh_reference) {
        long return_val = this.wma_d_cycle_count;
        DefaultWorkingMemoryActivationParams.ForgettingChoices forgetting = (DefaultWorkingMemoryActivationParams.ForgettingChoices)((Object)this.params.forgetting.get());
        if (fresh_reference && forgetting == DefaultWorkingMemoryActivationParams.ForgettingChoices.approx) {
            long to_add = 0L;
            wma_history history = decay_el.touches;
            int p = history.next_p;
            for (int counter = history.history_ct; counter != 0; --counter) {
                long cycle_diff;
                p = this.wma_history_prev(p);
                int approx_ref = (int)(history.access_history[p].num_references < 50L ? history.access_history[p].num_references : 49L);
                if (this.wma_approx_array[approx_ref] <= (cycle_diff = return_val - history.access_history[p].d_cycle)) continue;
                to_add += this.wma_approx_array[approx_ref] - cycle_diff;
            }
            return_val += to_add;
        }
        if (return_val == this.wma_d_cycle_count) {
            double my_thresh = this.wma_thresh_exp;
            long to_add = 1L;
            double act = this.wma_calculate_decay_activation(decay_el, return_val + to_add, false);
            if (act >= my_thresh) {
                while (act >= my_thresh) {
                    act = this.wma_calculate_decay_activation(decay_el, return_val + (to_add *= 2L), false);
                }
                long upper_bound = to_add;
                long lower_bound = to_add < 4L ? upper_bound : to_add / 2L;
                while (lower_bound != upper_bound) {
                    long mid = (lower_bound + upper_bound) / 2L;
                    act = this.wma_calculate_decay_activation(decay_el, return_val + mid, false);
                    if (act < my_thresh) {
                        upper_bound = mid;
                        if (upper_bound - lower_bound > 1L) continue;
                        lower_bound = mid;
                        continue;
                    }
                    lower_bound = mid;
                    if (upper_bound - lower_bound > 1L) continue;
                    lower_bound = upper_bound;
                }
                to_add = upper_bound;
            }
            return_val += to_add;
        }
        return return_val;
    }

    private boolean wma_forgetting_forget_wme(Wme w) {
        boolean fake;
        boolean return_val = false;
        boolean bl = fake = this.params.fake_forgetting.get() == DefaultWorkingMemoryActivationParams.FakeForgettingChoices.on;
        if (w.getPreferences().hasNext() && w.getPreferences().next().slot != null) {
            Preference p = w.getPreferences().next().slot.getAllPreferences();
            while (p != null) {
                Preference next_p = p.nextOfSlot;
                if (p.o_supported && p.isInTempMemory() && p.value == w.getValue() && !fake) {
                    this.recMemory.remove_preference_from_tm(p);
                    return_val = true;
                }
                p = next_p;
            }
        }
        return return_val;
    }

    private boolean wma_forgetting_update_p_queue() {
        boolean return_val = false;
        boolean do_forget = false;
        if (!this.wma_forget_pq.isEmpty()) {
            long current_cycle = this.wma_d_cycle_count;
            double decay_thresh = this.wma_thresh_exp;
            boolean forget_only_lti = this.params.forget_wme.get() == DefaultWorkingMemoryActivationParams.ForgetWmeChoices.lti;
            Map.Entry<Long, Set<wma_decay_element>> pq = this.wma_forget_pq.firstEntry();
            if (pq.getKey() == current_cycle) {
                for (wma_decay_element current : pq.getValue()) {
                    if (this.wma_calculate_decay_activation(current, current_cycle, false) < decay_thresh) {
                        WmeImpl w;
                        Slot s;
                        current.forget_cycle = 0L;
                        if (forget_only_lti && ((IdentifierImpl)current.this_wme.getIdentifier()).smem_lti == 0L) continue;
                        do_forget = true;
                        if (forget_only_lti) {
                            s = ((IdentifierImpl)current.this_wme.getIdentifier()).slots;
                            while (s != null && do_forget) {
                                w = s.getWmes();
                                while (w != null && do_forget) {
                                    wma_decay_element wma_decay_el = this.wmaDecayElements.get(w);
                                    if (w.preference.o_supported && (wma_decay_el == null || wma_decay_el.forget_cycle != 0L)) {
                                        do_forget = false;
                                    }
                                    w = w.next;
                                }
                                s = s.next;
                            }
                        }
                        if (!do_forget) continue;
                        if (forget_only_lti) {
                            s = ((IdentifierImpl)current.this_wme.getIdentifier()).slots;
                            while (s != null && do_forget) {
                                w = s.getWmes();
                                while (w != null && do_forget) {
                                    if (this.wma_forgetting_forget_wme(w)) {
                                        return_val = true;
                                    }
                                    w = w.next;
                                }
                                s = s.next;
                            }
                            continue;
                        }
                        if (!this.wma_forgetting_forget_wme(current.this_wme)) continue;
                        return_val = true;
                        continue;
                    }
                    this.wma_forgetting_move_in_p_queue(current, this.wma_forgetting_estimate_cycle(current, false));
                }
                this.wma_touched_sets.add(pq.getKey());
                pq.getValue().clear();
            }
            Iterator<Object> iterator = this.wma_touched_sets.iterator();
            while (iterator.hasNext()) {
                long touched = (Long)iterator.next();
                Set<wma_decay_element> pq_v = this.wma_forget_pq.get(touched);
                if (pq_v == null || !pq_v.isEmpty()) continue;
                this.wma_forget_pq.remove(touched);
            }
            this.wma_touched_sets.clear();
        }
        return return_val;
    }

    private boolean wma_forgetting_naive_sweep() {
        long current_cycle = this.wma_d_cycle_count;
        double decay_thresh = this.wma_thresh_exp;
        boolean forget_only_lti = this.params.forget_wme.get() == DefaultWorkingMemoryActivationParams.ForgetWmeChoices.lti;
        boolean return_val = false;
        for (Wme wme : this.rete.getAllWmes()) {
            wma_decay_element wma_decay_el = this.wmaDecayElements.get(wme);
            if (wma_decay_el == null || forget_only_lti && ((IdentifierImpl)wme.getIdentifier()).smem_lti == 0L || wma_decay_el.touches.total_references <= 0L || wma_decay_el.touches.access_history[this.wma_history_prev((int)wma_decay_el.touches.next_p)].d_cycle >= current_cycle || !(this.wma_calculate_decay_activation(wma_decay_el, current_cycle, false) < decay_thresh) || !this.wma_forgetting_forget_wme(wme)) continue;
            return_val = true;
        }
        return return_val;
    }

    @Override
    public void wma_activate_wmes_in_pref(Preference pref) {
        if (pref.type == PreferenceType.ACCEPTABLE) {
            WmeImpl w = pref.slot.getWmes();
            while (w != null) {
                if (w.getValue() == pref.value) {
                    this.wma_activate_wme(w);
                }
                w = w.next;
            }
        }
    }

    private void wma_update_decay_histories() {
        long current_cycle = this.wma_d_cycle_count;
        boolean forgetting = this.params.forgetting.get() == DefaultWorkingMemoryActivationParams.ForgettingChoices.approx || this.params.forgetting.get() == DefaultWorkingMemoryActivationParams.ForgettingChoices.bsearch;
        for (Wme w : this.wma_touched_elements) {
            wma_decay_element temp_el = this.wmaDecayElements.get(w);
            temp_el.touches.history_references += temp_el.num_references - temp_el.touches.access_history[temp_el.touches.next_p].num_references;
            temp_el.touches.access_history[temp_el.touches.next_p].d_cycle = current_cycle;
            temp_el.touches.access_history[temp_el.touches.next_p].num_references = temp_el.num_references;
            if (this.trace.isEnabled(Trace.Category.WMA)) {
                this.trace.getPrinter().print("WMA @" + this.decisionCycle.d_cycle_count + ": activate " + temp_el.this_wme.getTimetag() + " " + temp_el.num_references + "\n");
            }
            if (temp_el.touches.total_references == 0L) {
                temp_el.touches.first_reference = current_cycle;
            }
            if (temp_el.touches.history_ct < 10) {
                ++temp_el.touches.history_ct;
            }
            temp_el.touches.next_p = this.wma_history_next(temp_el.touches.next_p);
            temp_el.touches.total_references += temp_el.num_references;
            temp_el.num_references = 0L;
            if (forgetting) {
                if (temp_el.just_created) {
                    this.wma_forgetting_add_to_p_queue(temp_el, this.wma_forgetting_estimate_cycle(temp_el, true));
                } else {
                    this.wma_forgetting_move_in_p_queue(temp_el, this.wma_forgetting_estimate_cycle(temp_el, true));
                }
            }
            temp_el.just_created = false;
        }
        this.wma_touched_elements.clear();
    }

    @Override
    public double wma_get_wme_activation(Wme w, boolean log_result) {
        double return_val = log_result ? 1.0 : 2.71828182845905;
        wma_decay_element wma_decay_el = this.wmaDecayElements.get(w);
        if (wma_decay_el != null) {
            return_val = this.wma_calculate_decay_activation(wma_decay_el, this.wma_d_cycle_count, log_result);
        }
        return return_val;
    }

    @Override
    public String wma_get_wme_history(Wme w) {
        String ret = "";
        wma_decay_element wma_decay_el = this.wmaDecayElements.get(w);
        if (wma_decay_el != null) {
            wma_history history = wma_decay_el.touches;
            long current_cycle = this.wma_d_cycle_count;
            ret = ret + "history (" + history.history_references + "/" + history.total_references + ", first @ d" + history.first_reference + "):";
            int p = history.next_p;
            for (int counter = history.history_ct; counter != 0; --counter) {
                p = this.wma_history_prev(p);
                ret = ret + "\n" + history.access_history[p].toString(current_cycle);
            }
            DefaultWorkingMemoryActivationParams.ForgettingChoices forget = (DefaultWorkingMemoryActivationParams.ForgettingChoices)((Object)this.params.forgetting.get());
            if (forget == DefaultWorkingMemoryActivationParams.ForgettingChoices.bsearch || forget == DefaultWorkingMemoryActivationParams.ForgettingChoices.approx) {
                ret = ret + "\n\nconsidering WME for decay @ d" + wma_decay_el.forget_cycle;
            }
        } else {
            ret = "WME has no decay history";
        }
        return ret;
    }

    @Override
    public void wma_go(wma_go_action go_action) {
        DefaultWorkingMemoryActivationParams.ForgettingChoices forgetting;
        if (go_action == wma_go_action.wma_histories) {
            this.timers.start(this.timers.history);
            this.wma_update_decay_histories();
            this.timers.pause(this.timers.history);
        } else if (go_action == wma_go_action.wma_forgetting && (forgetting = (DefaultWorkingMemoryActivationParams.ForgettingChoices)((Object)this.params.forgetting.get())) != DefaultWorkingMemoryActivationParams.ForgettingChoices.off) {
            this.timers.start(this.timers.forgetting);
            boolean forgot_something = false;
            forgot_something = forgetting == DefaultWorkingMemoryActivationParams.ForgettingChoices.naive ? this.wma_forgetting_naive_sweep() : this.wma_forgetting_update_p_queue();
            if (forgot_something) {
                if (this.trace.isEnabled(Trace.Category.WM_CHANGES)) {
                    this.trace.getPrinter().print("\n\nWMA: BEGIN FORGOTTEN WME LIST\n\n");
                }
                long wm_removal_diff = this.workingMemory.getWmeRemovalCount();
                this.decider.do_working_memory_phase();
                wm_removal_diff = this.workingMemory.getWmeRemovalCount() - wm_removal_diff;
                if (wm_removal_diff > 0L) {
                    this.stats.forgotten_wmes.set(this.stats.forgotten_wmes.get() + wm_removal_diff);
                }
                if (this.trace.isEnabled(Trace.Category.WM_CHANGES)) {
                    this.trace.getPrinter().print("\nWMA: END FORGOTTEN WME LIST\n\n");
                }
            }
            this.timers.pause(this.timers.forgetting);
        }
    }
}

