/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.wma;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jsoar.kernel.wma.DefaultWorkingMemoryActivationParams;
import org.jsoar.util.properties.PropertyManager;
import org.jsoar.util.timing.DefaultExecutionTimer;
import org.jsoar.util.timing.ExecutionTimer;

public class DefaultWorkingMemoryActivationTimers {
    private final PropertyManager properties;
    ExecutionTimer history = DefaultExecutionTimer.newInstance().setName("wma_history");
    ExecutionTimer forgetting = DefaultExecutionTimer.newInstance().setName("wma_forgetting");
    Map<DefaultWorkingMemoryActivationParams.TimerLevels, Set<ExecutionTimer>> timerMap = new HashMap<DefaultWorkingMemoryActivationParams.TimerLevels, Set<ExecutionTimer>>();
    Set<ExecutionTimer> timerSet = new HashSet<ExecutionTimer>();

    DefaultWorkingMemoryActivationTimers(PropertyManager properties) {
        this.properties = properties;
        this.timerMap.put(DefaultWorkingMemoryActivationParams.TimerLevels.off, new HashSet());
        HashSet<ExecutionTimer> one = new HashSet<ExecutionTimer>();
        one.add(this.history);
        one.add(this.forgetting);
        this.timerMap.put(DefaultWorkingMemoryActivationParams.TimerLevels.one, one);
        this.timerSet.add(this.history);
        this.timerSet.add(this.forgetting);
    }

    void start(ExecutionTimer timer) {
        if (this.timerMap.get((Object)this.properties.get(DefaultWorkingMemoryActivationParams.TIMERS)).contains(timer)) {
            timer.start();
        }
    }

    void pause(ExecutionTimer timer) {
        if (this.timerMap.get((Object)this.properties.get(DefaultWorkingMemoryActivationParams.TIMERS)).contains(timer)) {
            timer.pause();
        }
    }

    void reset(ExecutionTimer timer) {
        timer.reset();
    }

    void reset() {
        for (Set<ExecutionTimer> timerSet : this.timerMap.values()) {
            for (ExecutionTimer timer : timerSet) {
                this.reset(timer);
            }
        }
    }

    ExecutionTimer get(String timerName) {
        for (ExecutionTimer t : this.timerSet) {
            if (!t.getName().equals(timerName)) continue;
            return t;
        }
        return null;
    }
}

