/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.script;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.rhs.functions.RhsFunctionManager;
import org.jsoar.script.ScriptContext;
import org.jsoar.script.ScriptRhsFunction;
import org.jsoar.util.adaptables.Adaptable;
import org.jsoar.util.adaptables.Adaptables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEngineState {
    private static final Logger logger = LoggerFactory.getLogger(ScriptEngineState.class);
    private final Adaptable context;
    private final String engineName;
    private final ScriptEngine engine;

    public ScriptEngineState(Adaptable context, String engineName, ScriptEngine engine) throws SoarException {
        this.context = context;
        this.engineName = engineName;
        this.engine = engine;
        this.initializeGlobalScope();
        this.installRhsFunction();
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }

    public Object eval(String script) throws SoarException {
        try {
            return this.engine.eval(script);
        }
        catch (ScriptException e) {
            e.printStackTrace();
            throw new SoarException("Error executing script: " + e.getMessage(), e);
        }
    }

    public void dispose() throws SoarException {
        this.uninstallRhsFunction();
        this.invokeDisposeMethod();
    }

    private void invokeDisposeMethod() throws SoarException {
        if (!(this.engine instanceof Invocable)) {
            return;
        }
        Invocable invocable = (Invocable)((Object)this.engine);
        try {
            invocable.invokeFunction("soar_dispose", new Object[0]);
        }
        catch (ScriptException e) {
            logger.error(this.engineName + ": Error calling soar_dispose: " + e.getMessage(), (Throwable)e);
            throw new SoarException("Error executing script: " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            try {
                this.engine.eval("soar_dispose()");
            }
            catch (ScriptException die) {
                logger.error(this.engineName + ": soar_dispose method not defined. " + die.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeGlobalScope() throws SoarException {
        block10: {
            InputStream is = this.getClass().getResourceAsStream(this.engineName.toLowerCase());
            if (is != null) {
                this.engine.put("_soar", new ScriptContext(this.context));
                this.engine.put("javax.script.filename", "/org/jsoar/script/" + this.engineName);
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charsets.UTF_8));
                try {
                    try {
                        this.engine.eval(reader);
                        break block10;
                    }
                    catch (ScriptException e) {
                        throw new SoarException(e.getMessage(), e);
                    }
                }
                finally {
                    this.engine.put("javax.script.filename", null);
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        throw new SoarException("While initializing '" + this.engineName + "' engine: " + e.getMessage(), e);
                    }
                }
            }
            this.engine.put("soar", new ScriptContext(this.context));
        }
    }

    private void installRhsFunction() {
        RhsFunctionManager rhsFunctions = Adaptables.adapt(this.context, RhsFunctionManager.class);
        if (rhsFunctions != null) {
            ScriptRhsFunction rhsFunction = new ScriptRhsFunction(this.engineName, this);
            rhsFunctions.registerHandler(rhsFunction);
        }
    }

    private void uninstallRhsFunction() {
        RhsFunctionManager rhsFunctions = Adaptables.adapt(this.context, RhsFunctionManager.class);
        if (rhsFunctions != null) {
            rhsFunctions.unregisterHandler(this.engineName);
        }
    }

    public String toString() {
        return this.engineName;
    }
}

