/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util;

import org.jsoar.util.SourceLocation;

public class DefaultSourceLocation
implements SourceLocation {
    public static final DefaultSourceLocation UNKNOWN = new DefaultSourceLocation(null, -1, -1, -1);
    private final String file;
    private final int offset;
    private final int length;
    private final int line;

    public static Builder newBuilder() {
        return new Builder();
    }

    private DefaultSourceLocation(String file, int offset, int length, int line) {
        this.file = file;
        this.offset = offset;
        this.length = length;
        this.line = line;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    public String toString() {
        return (this.file != null && this.file.length() > 0 ? this.file : "*unknown*") + (this.line != -1 ? ":" + (this.line + 1) : "");
    }

    public static class Builder {
        private String file;
        private int offset = -1;
        private int length = -1;
        private int line = -1;

        private Builder() {
        }

        public Builder file(String v) {
            this.file = v;
            return this;
        }

        public Builder offset(int v) {
            this.offset = v;
            return this;
        }

        public Builder length(int v) {
            this.length = v;
            return this;
        }

        public Builder line(int v) {
            this.line = v;
            return this;
        }

        public DefaultSourceLocation build() {
            return new DefaultSourceLocation(this.file, this.offset, this.length, this.line);
        }
    }
}

