/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class UrlTools {
    private static final Logger logger = LoggerFactory.getLogger(UrlTools.class);
    private static ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();

    public static URL normalize(URL url) throws URISyntaxException, MalformedURLException {
        URI uri = url.toURI();
        if (uri.getScheme().equals("jar")) {
            logger.debug("uri: " + uri);
            URI ssp1 = new URI(uri.getRawSchemeSpecificPart());
            logger.debug("ssp1: " + ssp1);
            URI ssp2 = new URI(ssp1.getRawSchemeSpecificPart());
            logger.debug("ssp2: " + ssp2);
            String sspScheme = ssp1.getScheme();
            logger.debug("scheme: " + sspScheme);
            URI normalizedSsp2 = new URI(ssp2.getRawSchemeSpecificPart()).normalize();
            logger.debug("normalzied ssp2: " + normalizedSsp2);
            URI normalized = new URI("jar:" + sspScheme + ":" + normalizedSsp2);
            logger.debug("normalized: " + normalized);
            url = normalized.toURL();
        } else {
            url = uri.normalize().toURL();
        }
        return url;
    }

    public static URL getParent(URL url) throws Exception {
        URI uri = url.toURI().getPath().endsWith("/") ? url.toURI().resolve("..") : url.toURI().resolve(".");
        return uri.toURL();
    }

    public static URL lookupClassPathURL(String url) throws IOException {
        List<Resource> resources;
        if (UrlTools.isClassPath(url) && !(resources = Arrays.asList(resourceResolver.getResources(url))).isEmpty()) {
            return resources.get(0).getURL();
        }
        throw new IOException("Invalid classpath resource: " + url);
    }

    public static void setClasspathResourceResolver(ResourcePatternResolver resourcePatternResolver) {
        resourceResolver = resourcePatternResolver;
    }

    public static void setClasspathResourceResolverClassLoader(ClassLoader cl) {
        resourceResolver = new PathMatchingResourcePatternResolver(cl);
    }

    public static boolean isClassPath(String url) {
        return url.startsWith("classpath:");
    }

    public static File toFile(URL url) throws Exception {
        URI uri = url.toURI();
        if (uri.toString().startsWith("file:") && uri.getAuthority() != null && uri.getAuthority().length() > 0) {
            uri = new URL("file://" + url.toString().substring("file:".length())).toURI();
        }
        return new File(uri);
    }

    public static File toFile2(URL url) {
        try {
            return UrlTools.toFile(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isFileURL(URL url) {
        try {
            UrlTools.toFile(url);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

