/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util.commands;

import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.LoadCommand;
import org.jsoar.kernel.commands.PopdCommand;
import org.jsoar.kernel.commands.PushdCommand;
import org.jsoar.kernel.commands.PwdCommand;
import org.jsoar.kernel.commands.SaveCommand;
import org.jsoar.kernel.commands.SourceCommand;
import org.jsoar.kernel.commands.SourceCommandAdapter;
import org.jsoar.kernel.commands.StandardCommands;
import org.jsoar.kernel.exceptions.SoarInterpreterException;
import org.jsoar.util.ByRef;
import org.jsoar.util.SourceLocation;
import org.jsoar.util.StringTools;
import org.jsoar.util.UrlTools;
import org.jsoar.util.commands.DefaultInterpreterParser;
import org.jsoar.util.commands.DefaultSoarCommandContext;
import org.jsoar.util.commands.ParsedCommand;
import org.jsoar.util.commands.ParserBuffer;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import org.jsoar.util.commands.SoarCommandInterpreter;
import org.jsoar.util.commands.SoarTclExceptionsManager;

public class DefaultInterpreter
implements SoarCommandInterpreter {
    private final Map<String, SoarCommand> commands = new HashMap<String, SoarCommand>();
    private final Map<String, List<String>> aliases = new LinkedHashMap<String, List<String>>();
    private final SourceCommand sourceCommand;
    private final LoadCommand loadCommand;
    private final SaveCommand saveCommand;
    private SoarTclExceptionsManager exceptionsManager = new SoarTclExceptionsManager();

    public DefaultInterpreter(Agent agent) {
        this.addCommand("alias", new AliasCommand());
        this.sourceCommand = new SourceCommand(new MySourceCommandAdapter(), agent.getEvents());
        this.addCommand("source", this.sourceCommand);
        this.addCommand("pushd", new PushdCommand(this.sourceCommand, agent));
        this.addCommand("popd", new PopdCommand(this.sourceCommand, agent));
        this.addCommand("pwd", new PwdCommand(this.sourceCommand));
        this.loadCommand = new LoadCommand(this.sourceCommand, agent);
        this.addCommand("load", this.loadCommand);
        this.saveCommand = new SaveCommand(this.sourceCommand, agent);
        this.addCommand("save", this.saveCommand);
        StandardCommands.addToInterpreter(agent, this);
    }

    @Override
    public void addCommand(String name, SoarCommand handler) {
        this.commands.put(name, handler);
    }

    @Override
    public SoarCommand getCommand(String name, SourceLocation srcLoc) throws SoarException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(name);
        return this.getSoarCommand(ByRef.create(new ParsedCommand(srcLoc, command)));
    }

    @Override
    public ParsedCommand getParsedCommand(String name, SourceLocation srcLoc) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(name);
        return this.resolveAliases(new ParsedCommand(srcLoc, command));
    }

    @Override
    public String getName() {
        return "default";
    }

    @Override
    public void dispose() {
    }

    @Override
    public String eval(String code) throws SoarException {
        return this.evalAndClose(new StringReader(code), code.length() > 100 ? code.substring(0, 100) : code);
    }

    @Override
    public void source(File file) throws SoarException {
        this.sourceCommand.source(file.getAbsolutePath());
    }

    @Override
    public void source(URL url) throws SoarException {
        this.sourceCommand.source(url.toExternalForm());
    }

    @Override
    public void loadRete(File file) throws SoarException {
        this.loadCommand.execute(DefaultSoarCommandContext.empty(), new String[]{file.getAbsolutePath()});
    }

    @Override
    public void loadRete(URL url) throws SoarException {
        this.loadCommand.execute(DefaultSoarCommandContext.empty(), new String[]{url.toExternalForm()});
    }

    @Override
    public void saveRete(File file) throws SoarException {
        this.saveCommand.execute(DefaultSoarCommandContext.empty(), new String[]{file.getAbsolutePath()});
    }

    @Override
    public String getWorkingDirectory() {
        return this.sourceCommand.getWorkingDirectory();
    }

    @Override
    public String[] getCompletionList(String command, int cursorPosition) {
        String[] commands = null;
        ArrayList<String> commandsList = new ArrayList<String>();
        for (String s : this.getCommandStrings()) {
            if (!s.startsWith(command)) continue;
            commandsList.add(s);
        }
        for (String s : this.getAliasStrings()) {
            if (!s.startsWith(command)) continue;
            commandsList.add(s);
        }
        commands = new String[commandsList.size()];
        commands = commandsList.toArray(commands);
        return commands;
    }

    @Override
    public Collection<String> getSourcedFiles() {
        return this.sourceCommand.getSourcedFiles();
    }

    public Set<String> getAliasStrings() {
        return this.aliases.keySet();
    }

    private String evalAndClose(Reader reader, String context) throws SoarException {
        try {
            String string = this.eval(reader);
            return string;
        }
        catch (IOException e) {
            throw new SoarException("Error while evaluating '" + context + "': " + e.getMessage(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new SoarException("Error while closing '" + context + "': " + e.getMessage(), e);
            }
        }
    }

    private String eval(Reader reader) throws IOException, SoarException {
        DefaultInterpreterParser parser = new DefaultInterpreterParser();
        ParserBuffer pbReader = new ParserBuffer(new PushbackReader(reader));
        pbReader.setFile(this.sourceCommand.getCurrentFile());
        ParsedCommand parsedCommand = parser.parseCommand(pbReader);
        String lastResult = "";
        while (!parsedCommand.isEof()) {
            lastResult = this.executeParsedCommand(parsedCommand);
            parsedCommand = parser.parseCommand(pbReader);
        }
        return lastResult;
    }

    private String executeParsedCommand(ParsedCommand parsedCommand) throws SoarException {
        ByRef<ParsedCommand> parsedCommandRef = new ByRef<ParsedCommand>(parsedCommand);
        SoarCommand command = this.getSoarCommand(parsedCommandRef);
        DefaultSoarCommandContext commandContext = new DefaultSoarCommandContext(((ParsedCommand)parsedCommandRef.value).getLocation());
        return command.execute(commandContext, ((ParsedCommand)parsedCommandRef.value).getArgs().toArray(new String[0]));
    }

    private SoarCommand getSoarCommand(ByRef<ParsedCommand> parsedCommand) throws SoarException {
        parsedCommand.value = this.resolveAliases((ParsedCommand)parsedCommand.value);
        SoarCommand command = this.resolveCommand(((ParsedCommand)parsedCommand.value).getArgs().get(0));
        if (command != null) {
            return command;
        }
        throw new SoarInterpreterException(((ParsedCommand)parsedCommand.value).getLocation() + ": Unknown command '" + ((ParsedCommand)parsedCommand.value).getArgs().get(0) + "'", parsedCommand);
    }

    private List<Map.Entry<String, SoarCommand>> resolvePossibleCommands(String prefix) {
        ArrayList<Map.Entry<String, SoarCommand>> result = new ArrayList<Map.Entry<String, SoarCommand>>();
        for (Map.Entry<String, SoarCommand> entry : this.commands.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            result.add(entry);
        }
        return result;
    }

    private List<String> getNames(List<Map.Entry<String, SoarCommand>> possible) {
        ArrayList<String> result = new ArrayList<String>(possible.size());
        for (Map.Entry<String, SoarCommand> e : possible) {
            result.add(e.getKey());
        }
        return result;
    }

    private SoarCommand resolveCommand(String name) throws SoarException {
        SoarCommand quick = this.commands.get(name);
        if (quick != null) {
            return quick;
        }
        List<Map.Entry<String, SoarCommand>> possible = this.resolvePossibleCommands(name);
        if (possible.isEmpty()) {
            return null;
        }
        if (possible.size() == 1) {
            return possible.get(0).getValue();
        }
        throw new SoarException("Ambiguous command '" + name + "'. Could be one of '" + Joiner.on((String)", ").join(this.getNames(possible)));
    }

    private ParsedCommand resolveAliases(ParsedCommand parsedCommand) {
        String first = parsedCommand.getArgs().get(0);
        List<String> alias = this.aliases.get(first);
        if (alias == null) {
            return parsedCommand;
        }
        ArrayList<String> result = new ArrayList<String>(alias);
        result.addAll(parsedCommand.getArgs().subList(1, parsedCommand.getArgs().size()));
        return new ParsedCommand(parsedCommand.getLocation(), result);
    }

    public SoarCommand getCommand(String s) {
        return this.commands.get(s);
    }

    @Override
    public List<String> getCommandStrings() {
        ArrayList<String> commandList = new ArrayList<String>(this.commands.keySet());
        Collections.sort(commandList);
        return commandList;
    }

    @Override
    public SoarTclExceptionsManager getExceptionsManager() {
        return this.exceptionsManager;
    }

    private class MySourceCommandAdapter
    implements SourceCommandAdapter {
        private MySourceCommandAdapter() {
        }

        @Override
        public void eval(File file) throws SoarException {
            try {
                String code = this.getReaderContents(new BufferedReader(new FileReader(file)));
                code = this.fixLineEndings(code);
                DefaultInterpreter.this.evalAndClose(new StringReader(code), file.getAbsolutePath());
            }
            catch (IOException e) {
                throw new SoarException(e.getMessage(), e);
            }
        }

        @Override
        public void eval(URL url) throws SoarException {
            try {
                url = UrlTools.normalize(url);
                String code = this.getReaderContents(new BufferedReader(new InputStreamReader(url.openStream())));
                code = this.fixLineEndings(code);
                DefaultInterpreter.this.evalAndClose(new StringReader(code), url.toExternalForm());
            }
            catch (IOException | URISyntaxException e) {
                throw new SoarException("Failed to open '" + url + "': " + e.getStackTrace(), e);
            }
        }

        @Override
        public String eval(String code) throws SoarException {
            code = this.fixLineEndings(code);
            return DefaultInterpreter.this.eval(code);
        }

        private String getReaderContents(Reader reader) throws IOException {
            int ch;
            StringBuilder builder = new StringBuilder();
            while ((ch = reader.read()) != -1) {
                builder.append((char)ch);
            }
            return builder.toString();
        }

        private String fixLineEndings(String code) {
            code = code.replaceAll("\r\n", "\n");
            code = code.replaceAll("\r", "\n");
            return code;
        }
    }

    private class AliasCommand
    implements SoarCommand {
        private AliasCommand() {
        }

        private String aliasToString(String name, List<String> args) {
            return name + "=" + StringTools.join(args, " ");
        }

        @Override
        public String execute(SoarCommandContext context, String[] args) throws SoarException {
            if (args.length == 1) {
                StringBuilder b = new StringBuilder();
                for (Map.Entry e : DefaultInterpreter.this.aliases.entrySet()) {
                    b.append(this.aliasToString((String)e.getKey(), (List)e.getValue()));
                    b.append('\n');
                }
                return b.toString();
            }
            if (args.length == 2) {
                List aliasArgs = (List)DefaultInterpreter.this.aliases.get(args[1]);
                if (aliasArgs == null) {
                    throw new SoarException("Unknown alias '" + args[1] + "'");
                }
                return this.aliasToString(args[1], aliasArgs);
            }
            ArrayList<String> aliasArgs = new ArrayList<String>(args.length - 2);
            for (int i = 2; i < args.length; ++i) {
                aliasArgs.add(args[i]);
            }
            DefaultInterpreter.this.aliases.put(args[1], aliasArgs);
            return this.aliasToString(args[1], aliasArgs);
        }

        @Override
        public Object getCommand() {
            return null;
        }
    }
}

