/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util.commands;

import java.io.IOException;
import java.util.ArrayList;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.exceptions.SoarInterpreterException;
import org.jsoar.kernel.exceptions.SoarParserException;
import org.jsoar.util.DefaultSourceLocation;
import org.jsoar.util.commands.ParsedCommand;
import org.jsoar.util.commands.ParserBuffer;

public class DefaultInterpreterParser {
    private int startOfCommand;
    private int lineOfCommand;

    public ParsedCommand parseCommand(ParserBuffer reader) throws IOException, SoarException {
        this.startOfCommand = -1;
        this.lineOfCommand = -1;
        ArrayList<String> result = new ArrayList<String>();
        this.skipWhitespaceAndComments(reader);
        if (!this.atEndOfCommand(reader)) {
            String word = this.parseWord(reader);
            while (word != null) {
                result.add(word);
                if (this.atEndOfCommand(reader)) break;
                this.skipWhitespaceAndComments(reader);
                word = this.parseWord(reader);
            }
        }
        DefaultSourceLocation loc = DefaultSourceLocation.newBuilder().file(reader.getFile()).offset(this.startOfCommand).length(reader.getCurrentOffset() - this.startOfCommand).line(this.lineOfCommand).build();
        return new ParsedCommand(loc, result);
    }

    private boolean atEndOfCommand(ParserBuffer reader) throws IOException {
        int c = 0;
        block5: while ((c = this.read(reader)) != -1) {
            switch (c) {
                case 10: 
                case 13: 
                case 35: {
                    this.unread(reader, c);
                    return true;
                }
                case 59: {
                    return true;
                }
                case 9: 
                case 12: 
                case 32: {
                    continue block5;
                }
            }
            this.unread(reader, c);
            return false;
        }
        return true;
    }

    public void skipWhitespace(ParserBuffer reader) throws IOException {
        int c = 0;
        while ((c = this.read(reader)) != -1 && Character.isWhitespace(c)) {
        }
        if (c != -1) {
            this.unread(reader, c);
        }
    }

    private void skipToEndOfLine(ParserBuffer reader) throws IOException {
        int c = 0;
        while ((c = this.read(reader)) != -1 && c != 10 && c != 13) {
        }
        if (c != -1 && c != 10 && c != 13) {
            this.unread(reader, c);
        }
    }

    public void skipWhitespaceAndComments(ParserBuffer reader) throws IOException {
        this.skipWhitespace(reader);
        int c = this.read(reader);
        if (c == -1) {
            return;
        }
        if (c == 35) {
            this.skipToEndOfLine(reader);
            this.skipWhitespaceAndComments(reader);
        } else {
            this.unread(reader, c);
        }
    }

    public String parseWord(ParserBuffer reader) throws SoarException, IOException {
        this.skipWhitespace(reader);
        StringBuilder result = new StringBuilder();
        int c = this.read(reader);
        if (c == -1) {
            return null;
        }
        if (this.startOfCommand == -1) {
            this.startOfCommand = reader.getCurrentOffset();
            this.lineOfCommand = reader.getCurrentLine();
        }
        if (c == 34) {
            while ((c = this.read(reader)) != -1 && c != 34) {
                switch (c) {
                    case 92: {
                        c = this.parseEscapeSequence(reader);
                        if (c != -1) break;
                        throw new SoarParserException("Unexpected end of file", this.startOfCommand);
                    }
                }
                result.append((char)c);
            }
            if (c == -1) {
                throw new SoarParserException("Unexpected end of input. Unmatched quote.", this.startOfCommand);
            }
        } else if (c == 123) {
            int braces = 1;
            block8: while (braces > 0 && (c = this.read(reader)) != -1) {
                switch (c) {
                    case 125: {
                        if (--braces <= 0) continue block8;
                        result.append((char)c);
                        continue block8;
                    }
                    case 123: {
                        ++braces;
                    }
                }
                result.append((char)c);
            }
            if (braces > 0) {
                throw new SoarParserException("Unexpected end of input. Unmatched opening brace", this.startOfCommand);
            }
        } else {
            result.append((char)c);
            while ((c = this.read(reader)) != -1 && !Character.isWhitespace(c)) {
                result.append((char)c);
            }
            if (c != -1) {
                this.unread(reader, c);
            }
        }
        return result.toString();
    }

    private int parseEscapeSequence(ParserBuffer reader) throws IOException {
        int c = this.read(reader);
        switch (c) {
            case 110: {
                c = 10;
                break;
            }
            case 114: {
                c = 13;
                break;
            }
            case 116: {
                c = 9;
                break;
            }
            case 102: {
                c = 12;
                break;
            }
            case 98: {
                c = 8;
            }
        }
        return c;
    }

    private SoarException error(ParserBuffer reader, String message) {
        return new SoarInterpreterException(reader.getLocation() + ": " + message);
    }

    private int read(ParserBuffer reader) throws IOException {
        return reader.read();
    }

    private void unread(ParserBuffer reader, int c) throws IOException {
        reader.unread(c);
    }
}

