/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util.commands;

import java.io.IOException;
import java.io.PushbackReader;
import org.jsoar.util.DefaultSourceLocation;
import org.jsoar.util.SourceLocation;

public class ParserBuffer {
    private final PushbackReader reader;
    private String file;
    private int currentOffset;
    private int line;

    public ParserBuffer(PushbackReader reader) {
        this.reader = reader;
        this.file = null;
        this.currentOffset = 0;
        this.line = 0;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }

    public void setCurrentOffset(int currentOffset) {
        this.currentOffset = currentOffset;
    }

    public int getCurrentLine() {
        return this.line;
    }

    public void setCurrentLine(int line) {
        this.line = line;
    }

    public int read() throws IOException {
        int c = this.reader.read();
        if (c != -1) {
            ++this.currentOffset;
        }
        if (c == 10) {
            ++this.line;
        }
        return c;
    }

    public void unread(int c) throws IOException {
        if (c == 10) {
            --this.line;
        }
        --this.currentOffset;
        this.reader.unread(c);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public SourceLocation getLocation() {
        return DefaultSourceLocation.newBuilder().file(this.file).offset(this.currentOffset).line(this.line).build();
    }
}

