/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util.commands;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jsoar.kernel.SoarException;
import org.jsoar.util.SourceLocation;
import org.jsoar.util.commands.ParsedCommand;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarTclExceptionsManager;
import picocli.CommandLine;

public interface SoarCommandInterpreter {
    public String getName();

    public void dispose();

    public void addCommand(String var1, SoarCommand var2);

    public SoarCommand getCommand(String var1, SourceLocation var2) throws SoarException;

    public ParsedCommand getParsedCommand(String var1, SourceLocation var2);

    public Collection<String> getSourcedFiles();

    public String eval(String var1) throws SoarException;

    public void source(File var1) throws SoarException;

    public void source(URL var1) throws SoarException;

    public void loadRete(File var1) throws SoarException;

    public void loadRete(URL var1) throws SoarException;

    public void saveRete(File var1) throws SoarException;

    public String getWorkingDirectory();

    public String[] getCompletionList(String var1, int var2);

    default public CommandLine findCommand(String command) {
        if (!(command = command.trim()).isEmpty()) {
            SoarCommand cmd;
            String[] parts = command.split(" ");
            ParsedCommand parsedCommand = null;
            parsedCommand = this.getParsedCommand(parts[0], null);
            if (parts.length > 1) {
                parsedCommand.getArgs().addAll(Arrays.asList(parts).subList(1, parts.length));
            }
            try {
                cmd = this.getCommand(parsedCommand.getArgs().get(0), null);
            }
            catch (SoarException e) {
                return null;
            }
            if (cmd != null && cmd.getCommand() != null) {
                CommandLine commandLine = new CommandLine(cmd.getCommand());
                int part = 0;
                List<String> args = parsedCommand.getArgs().subList(1, parsedCommand.getArgs().size());
                while (part < args.size() && commandLine.getSubcommands().containsKey(args.get(part))) {
                    commandLine = (CommandLine)commandLine.getSubcommands().get(args.get(part));
                }
                return commandLine;
            }
        }
        return null;
    }

    public List<String> getCommandStrings() throws SoarException;

    public SoarTclExceptionsManager getExceptionsManager();
}

