/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util.db;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jsoar.kernel.SoarException;
import org.jsoar.util.JdbcTools;
import org.jsoar.util.db.SoarPreparedStatement;

public abstract class AbstractSoarDatabase {
    private final String driver;
    private final Connection db;
    private final Properties statements = new Properties();
    private final Map<String, String> filterMap = new HashMap<String, String>();

    public AbstractSoarDatabase(String driver, Connection db) {
        this.driver = driver;
        this.db = db;
    }

    public String getDriver() {
        return this.driver;
    }

    public Connection getConnection() {
        return this.db;
    }

    public Map<String, String> getFilterMap() {
        return this.filterMap;
    }

    public void prepare() throws SoarException, IOException {
        this.loadStatementsFromResource("statements.properties", true);
        this.loadStatementsFromResource(this.driver + ".statements.properties", false);
        this.assignStatements();
    }

    public boolean structure() throws SoarException, IOException {
        InputStream is = AbstractSoarDatabase.filter(this.getClass().getResourceAsStream("structures.sql"), this.getFilterMap());
        if (is == null) {
            throw new FileNotFoundException("Failed to open '" + this.getResourcePath("structures.sql") + "' resource");
        }
        try {
            JdbcTools.executeSqlBatch(this.getConnection(), is, this.getDriver());
        }
        finally {
            is.close();
        }
        return true;
    }

    private String getResourcePath(String name) {
        return "/" + this.getClass().getPackage().getName().replace('.', '/') + "/" + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStatementsFromResource(String resource, boolean required) throws IOException {
        InputStream is = AbstractSoarDatabase.filter(this.getClass().getResourceAsStream(resource), this.filterMap);
        if (is == null) {
            if (required) {
                throw new FileNotFoundException("Failed to open '" + this.getResourcePath(resource) + "' resource");
            }
            return;
        }
        try {
            this.statements.load(is);
        }
        finally {
            is.close();
        }
    }

    private void assignStatements() throws SoarException {
        for (Object name : this.statements.keySet()) {
            this.assignStatement(name.toString());
        }
    }

    private void assignStatement(String name) throws SoarException {
        try {
            Field field = this.getClass().getDeclaredField(name);
            field.setAccessible(true);
            PreparedStatement ps = this.prepareNamedStatement(name);
            if (ps == null) {
                throw new SoarException("Failed to prepare statement '" + name + "'");
            }
            field.set(this, ps);
        }
        catch (SecurityException e) {
            throw new SoarException("While assigning statement field '" + name + "': " + e.getMessage(), e);
        }
        catch (NoSuchFieldException e) {
            throw new SoarException("While assigning statement field '" + name + "': " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new SoarException("While assigning statement field '" + name + "': " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new SoarException("While assigning statement field '" + name + "': " + e.getMessage(), e);
        }
    }

    private PreparedStatement prepareNamedStatement(String name) throws SoarException {
        String sql = this.statements.getProperty(name);
        if (sql == null) {
            throw new SoarException("Could not find statement '" + name + "'");
        }
        try {
            String trimmed = sql.trim();
            if (trimmed.startsWith("INSERT")) {
                return new SoarPreparedStatement(this.db.prepareStatement(trimmed, 1), trimmed);
            }
            if (trimmed.startsWith("backup") || trimmed.startsWith("restore")) {
                return new SoarPreparedStatement(trimmed);
            }
            return new SoarPreparedStatement(this.db.prepareStatement(trimmed), trimmed);
        }
        catch (SQLException e) {
            throw new SoarException("Failed to prepare statement '" + sql + "': " + e.getMessage(), e);
        }
    }

    private static final InputStream filter(InputStream in, Map<String, String> replacements) throws IOException {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        try {
            ByteStreams.copy((InputStream)in, (OutputStream)temp);
        }
        finally {
            in.close();
        }
        String tempString = temp.toString("UTF-8");
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            tempString = tempString.replace(entry.getKey(), entry.getValue());
        }
        return new ByteArrayInputStream(tempString.getBytes("UTF-8"));
    }
}

