/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util.events;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jsoar.util.events.SoarEvent;
import org.jsoar.util.events.SoarEventListener;

public class SoarEventManager {
    private List<SoarEventListener> listenersForAny = new CopyOnWriteArrayList<SoarEventListener>();
    private Map<Class<? extends SoarEvent>, List<SoarEventListener>> listeners = Collections.synchronizedMap(new HashMap());

    public <T extends SoarEvent> void addListener(Class<T> klass, SoarEventListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.getListenersForEventType(klass).add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SoarEvent> void removeListener(Class<T> klass, SoarEventListener listener) {
        if (klass == null) {
            this.listenersForAny.remove(listener);
            Map<Class<? extends SoarEvent>, List<SoarEventListener>> map = this.listeners;
            synchronized (map) {
                for (List<SoarEventListener> list : this.listeners.values()) {
                    list.remove(listener);
                }
            }
        } else {
            this.getListenersForEventType(klass).remove(listener);
        }
    }

    public <T extends SoarEvent> void fireEvent(T event) {
        this.fireEvent(event, event.getClass());
    }

    public <T extends SoarEvent> void fireEvent(T event, Class<? extends T> eventType) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        for (SoarEventListener l : this.getListenersForEventType(eventType)) {
            l.onEvent(event);
        }
        for (SoarEventListener l : this.listenersForAny) {
            l.onEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends SoarEvent> List<SoarEventListener> getListenersForEventType(Class<T> klass) {
        if (klass == null || klass.equals(SoarEvent.class)) {
            return this.listenersForAny;
        }
        Map<Class<? extends SoarEvent>, List<SoarEventListener>> map = this.listeners;
        synchronized (map) {
            List<SoarEventListener> list = this.listeners.get(klass);
            if (list == null) {
                list = new CopyOnWriteArrayList<SoarEventListener>();
                this.listeners.put(klass, list);
            }
            return list;
        }
    }
}

